/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.List;
import java.util.Objects;
import org.apache.hop.base.BaseHopMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.w3c.dom.Node;

public class PipelineHopMeta
extends BaseHopMeta<TransformMeta>
implements Comparable<PipelineHopMeta>,
Cloneable {
    private static final Class<?> PKG = Pipeline.class;

    public PipelineHopMeta(TransformMeta from, TransformMeta to, boolean en) {
        this.from = from;
        this.to = to;
        this.enabled = en;
    }

    public PipelineHopMeta(TransformMeta from, TransformMeta to) {
        this.from = from;
        this.to = to;
        this.enabled = true;
    }

    public PipelineHopMeta() {
        this(null, null, false);
    }

    public PipelineHopMeta(Node hopNode, List<TransformMeta> transforms) throws HopXmlException {
        try {
            this.from = this.searchTransform(transforms, XmlHandler.getTagValue((Node)hopNode, (String)"from"));
            this.to = this.searchTransform(transforms, XmlHandler.getTagValue((Node)hopNode, (String)"to"));
            this.enabled = this.getTagValueAsBoolean(hopNode, "enabled", true);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"PipelineHopMeta.Exception.UnableToLoadHopInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public PipelineHopMeta(PipelineHopMeta hop) {
        super(hop.isSplit(), hop.getFromTransform(), hop.getToTransform(), hop.isEnabled(), hop.hasChanged(), hop.isErrorHop());
    }

    public PipelineHopMeta clone() {
        return new PipelineHopMeta(this);
    }

    public void setFromTransform(TransformMeta from) {
        this.from = from;
    }

    public void setToTransform(TransformMeta to) {
        this.to = to;
    }

    public TransformMeta getFromTransform() {
        return (TransformMeta)this.from;
    }

    public TransformMeta getToTransform() {
        return (TransformMeta)this.to;
    }

    private TransformMeta searchTransform(List<TransformMeta> transforms, String name) {
        for (TransformMeta transformMeta : transforms) {
            if (!transformMeta.getName().equalsIgnoreCase(name)) continue;
            return transformMeta;
        }
        return null;
    }

    public boolean equals(Object obj) {
        PipelineHopMeta other = (PipelineHopMeta)obj;
        if (this.from == null || this.to == null) {
            return false;
        }
        return ((TransformMeta)this.from).equals(other.getFromTransform()) && ((TransformMeta)this.to).equals(other.getToTransform());
    }

    public int hashCode() {
        return Objects.hash(this.to, this.from);
    }

    @Override
    public int compareTo(PipelineHopMeta obj) {
        return this.toString().compareTo(obj.toString());
    }

    public void flip() {
        TransformMeta dummy = (TransformMeta)this.from;
        this.from = this.to;
        this.to = dummy;
    }

    public String toString() {
        String strFrom = this.from == null ? "(empty)" : ((TransformMeta)this.from).getName();
        String strTo = this.to == null ? "(empty)" : ((TransformMeta)this.to).getName();
        return strFrom + " --> " + strTo + " (" + (this.enabled ? "enabled" : "disabled") + ")";
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(200);
        if (this.from != null && this.to != null) {
            xml.append("    ").append(XmlHandler.openTag((String)"hop")).append(Const.CR);
            xml.append("      ").append(XmlHandler.addTagValue((String)"from", (String)((TransformMeta)this.from).getName()));
            xml.append("      ").append(XmlHandler.addTagValue((String)"to", (String)((TransformMeta)this.to).getName()));
            xml.append("      ").append(XmlHandler.addTagValue((String)"enabled", (boolean)this.enabled));
            xml.append("    ").append(XmlHandler.closeTag((String)"hop")).append(Const.CR);
        }
        return xml.toString();
    }
}

