/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hop.core.compress.CompressionPluginType;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.ICompressionProviderFactory;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;

public class CompressionProviderFactory
implements ICompressionProviderFactory {
    protected static CompressionProviderFactory INSTANCE = new CompressionProviderFactory();

    private CompressionProviderFactory() {
    }

    public static CompressionProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public ICompressionProvider createCompressionProviderInstance(String name) {
        Object provider = null;
        List<IPlugin> providers = this.getPlugins();
        if (providers != null) {
            for (IPlugin plugin : providers) {
                if (name == null || !name.equalsIgnoreCase(plugin.getName())) continue;
                try {
                    return (ICompressionProvider)PluginRegistry.getInstance().loadClass(plugin, ICompressionProvider.class);
                }
                catch (Exception e) {
                    provider = null;
                }
            }
        }
        return provider;
    }

    @Override
    public Collection<ICompressionProvider> getCompressionProviders() {
        ArrayList<ICompressionProvider> providerClasses = new ArrayList<ICompressionProvider>();
        List<IPlugin> providers = this.getPlugins();
        if (providers != null) {
            for (IPlugin plugin : providers) {
                try {
                    providerClasses.add((ICompressionProvider)PluginRegistry.getInstance().loadClass(plugin, ICompressionProvider.class));
                }
                catch (Exception exception) {}
            }
        }
        return providerClasses;
    }

    @Override
    public String[] getCompressionProviderNames() {
        ArrayList<String> providerNames = new ArrayList<String>();
        List<IPlugin> providers = this.getPlugins();
        if (providers != null) {
            for (IPlugin plugin : providers) {
                try {
                    ICompressionProvider provider = (ICompressionProvider)PluginRegistry.getInstance().loadClass(plugin, ICompressionProvider.class);
                    if (provider == null) continue;
                    providerNames.add(provider.getName());
                }
                catch (Exception exception) {}
            }
        }
        return providerNames.toArray(new String[providerNames.size()]);
    }

    @Override
    public ICompressionProvider getCompressionProviderByName(String name) {
        if (name == null) {
            return null;
        }
        ICompressionProvider foundProvider = null;
        List<IPlugin> providers = this.getPlugins();
        if (providers != null) {
            for (IPlugin plugin : providers) {
                try {
                    ICompressionProvider provider = (ICompressionProvider)PluginRegistry.getInstance().loadClass(plugin, ICompressionProvider.class);
                    if (provider == null || !name.equals(provider.getName())) continue;
                    foundProvider = provider;
                }
                catch (Exception exception) {}
            }
        }
        return foundProvider;
    }

    protected List<IPlugin> getPlugins() {
        return PluginRegistry.getInstance().getPlugins(CompressionPluginType.class);
    }
}

