/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.base;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.IAttributes;
import org.apache.hop.core.IEngineMeta;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.changed.ChangedFlag;
import org.apache.hop.core.changed.IChanged;
import org.apache.hop.core.changed.IHopObserver;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.listeners.IContentChangedListener;
import org.apache.hop.core.listeners.ICurrentDirectoryChangedListener;
import org.apache.hop.core.listeners.IFilenameChangedListener;
import org.apache.hop.core.listeners.INameChangedListener;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.undo.ChangeAction;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.server.HopServer;

public abstract class AbstractMeta
implements IChanged,
IUndo,
IEngineMeta,
INamedParameterDefinitions,
IAttributes {
    public static final int TYPE_UNDO_CHANGE = 1;
    public static final int TYPE_UNDO_NEW = 2;
    public static final int TYPE_UNDO_DELETE = 3;
    public static final int TYPE_UNDO_POSITION = 4;
    protected String filename;
    protected Set<INameChangedListener> nameChangedListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Set<IFilenameChangedListener> filenameChangedListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Set<IContentChangedListener> contentChangedListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Set<ICurrentDirectoryChangedListener> currentDirectoryChangedListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    @HopMetadataProperty(groupKey="notepads", key="notepad")
    protected List<NotePadMeta> notes;
    protected boolean changedNotes;
    protected List<ChangeAction> undo;
    protected Map<String, Map<String, String>> attributesMap;
    protected INamedParameters namedParams = new NamedParameters();
    protected IHopMetadataProvider metadataProvider;
    protected final ChangedFlag changedFlag = new ChangedFlag();
    protected int maxUndo;
    protected int undoPosition;
    protected RunOptions runOptions = new RunOptions();
    private boolean showDialog = true;
    private boolean alwaysShowRunOptions = true;
    private Boolean versioningEnabled;

    public boolean isShowDialog() {
        return this.showDialog;
    }

    public void setShowDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }

    public boolean isAlwaysShowRunOptions() {
        return this.alwaysShowRunOptions;
    }

    public void setAlwaysShowRunOptions(boolean alwaysShowRunOptions) {
        this.alwaysShowRunOptions = alwaysShowRunOptions;
    }

    protected abstract String getExtension();

    public static final String extractNameFromFilename(boolean sync, String name, String filename, String extension) {
        if (filename == null) {
            return name;
        }
        if (sync) {
            int lastSlashIndex;
            int lastExtIndex = filename.toLowerCase().lastIndexOf(extension);
            if (lastExtIndex < 0) {
                lastExtIndex = filename.length();
            }
            if ((lastSlashIndex = filename.lastIndexOf(47)) < 0) {
                lastSlashIndex = filename.lastIndexOf(92);
            }
            if (lastSlashIndex < 0) {
                lastSlashIndex = -1;
            }
            return filename.substring(lastSlashIndex + 1, lastExtIndex);
        }
        return name;
    }

    public void setNotes(List<NotePadMeta> notes) {
        this.notes = notes;
    }

    @Override
    public abstract String getName();

    @Override
    public abstract void setName(String var1);

    @Override
    public abstract boolean isNameSynchronizedWithFilename();

    @Override
    public abstract void setNameSynchronizedWithFilename(boolean var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    public abstract String getExtendedDescription();

    public abstract void setExtendedDescription(String var1);

    @Override
    public void nameFromFilename() {
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            this.setName(Const.createName((String)this.filename));
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String newFilename) {
        this.fireFilenameChangedListeners(this.filename, newFilename);
        this.filename = newFilename;
    }

    @Override
    public abstract void setInternalHopVariables(IVariables var1);

    protected abstract void setInternalFilenameHopVariables(IVariables var1);

    @Deprecated(since="2.0")
    public DatabaseMeta findDatabase(String name) {
        if (this.metadataProvider == null || StringUtils.isEmpty((String)name)) {
            return null;
        }
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)this.metadataProvider.getSerializer(DatabaseMeta.class).load(name);
            return databaseMeta;
        }
        catch (HopException e) {
            throw new RuntimeException("Unable to load database with name '" + name + "' from the metadata", e);
        }
    }

    public DatabaseMeta findDatabase(String name, IVariables variables) {
        return this.findDatabase(name, variables, false);
    }

    public DatabaseMeta findDatabase(String name, IVariables variables, boolean haltOnMissingMeta) {
        if (this.metadataProvider == null || StringUtils.isEmpty((String)variables.resolve(name))) {
            return null;
        }
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)this.metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(name));
            if (databaseMeta == null && haltOnMissingMeta) {
                throw new RuntimeException("Unable to load database with name '" + variables.resolve(name) + "' from the metadata. Please verify that the case of the connection name is correct because that could be an issue!");
            }
            return databaseMeta;
        }
        catch (HopException e) {
            throw new RuntimeException("Unable to load database with name '" + variables.resolve(name) + "' from the metadata", e);
        }
    }

    public int nrDatabases() {
        try {
            return this.metadataProvider.getSerializer(DatabaseMeta.class).listObjectNames().size();
        }
        catch (HopException e) {
            throw new RuntimeException("Unable to count the number of RDBMS connections in the metadata", e);
        }
    }

    public void addNameChangedListener(INameChangedListener listener) {
        if (listener != null) {
            this.nameChangedListeners.add(listener);
        }
    }

    public void removeNameChangedListener(INameChangedListener listener) {
        if (listener != null) {
            this.nameChangedListeners.remove(listener);
        }
    }

    public void clearNameChangedListeners() {
        this.nameChangedListeners.clear();
    }

    protected void fireNameChangedListeners(String oldName, String newName) {
        if (this.nameChanged(oldName, newName)) {
            for (INameChangedListener listener : this.nameChangedListeners) {
                listener.nameChanged(this, oldName, newName);
            }
        }
    }

    public void addFilenameChangedListener(IFilenameChangedListener listener) {
        if (listener != null) {
            this.filenameChangedListeners.add(listener);
        }
    }

    public void removeFilenameChangedListener(IFilenameChangedListener listener) {
        if (listener != null) {
            this.filenameChangedListeners.remove(listener);
        }
    }

    protected void fireFilenameChangedListeners(String oldFilename, String newFilename) {
        if (this.nameChanged(oldFilename, newFilename)) {
            for (IFilenameChangedListener listener : this.filenameChangedListeners) {
                listener.filenameChanged(this, oldFilename, newFilename);
            }
        }
    }

    public void addContentChangedListener(IContentChangedListener listener) {
        if (listener != null) {
            this.contentChangedListeners.add(listener);
        }
    }

    public void removeContentChangedListener(IContentChangedListener listener) {
        if (listener != null) {
            this.contentChangedListeners.remove(listener);
        }
    }

    public List<IContentChangedListener> getContentChangedListeners() {
        return ImmutableList.copyOf(this.contentChangedListeners);
    }

    protected void fireContentChangedListeners() {
        this.fireContentChangedListeners(true);
    }

    protected void fireContentChangedListeners(boolean ch) {
        if (ch) {
            for (IContentChangedListener listener : this.contentChangedListeners) {
                listener.contentChanged(this);
            }
        } else {
            for (IContentChangedListener listener : this.contentChangedListeners) {
                listener.contentSafe(this);
            }
        }
    }

    public void addCurrentDirectoryChangedListener(ICurrentDirectoryChangedListener listener) {
        if (listener != null && !this.currentDirectoryChangedListeners.contains(listener)) {
            this.currentDirectoryChangedListeners.add(listener);
        }
    }

    public void removeCurrentDirectoryChangedListener(ICurrentDirectoryChangedListener listener) {
        if (listener != null) {
            this.currentDirectoryChangedListeners.remove(listener);
        }
    }

    protected void fireCurrentDirectoryChanged(String previous, String current) {
        if (this.nameChanged(previous, current)) {
            for (ICurrentDirectoryChangedListener listener : this.currentDirectoryChangedListeners) {
                listener.directoryChanged(this, previous, current);
            }
        }
    }

    public HopServer findHopServer(String serverString) {
        if (this.metadataProvider == null || StringUtils.isEmpty((String)this.getName())) {
            return null;
        }
        try {
            return (HopServer)this.metadataProvider.getSerializer(HopServer.class).load(this.getName());
        }
        catch (HopException e) {
            throw new RuntimeException("Unable to load hop server with name '" + this.getName() + "' from the metadata", e);
        }
    }

    public String[] getHopServerNames() {
        try {
            List names = this.metadataProvider.getSerializer(HopServer.class).listObjectNames();
            Collections.sort(names);
            return names.toArray(new String[0]);
        }
        catch (HopException e) {
            throw new RuntimeException("Unable to get hop server names from the metadata", e);
        }
    }

    @Override
    public void addUndo(Object[] from, Object[] to, int[] pos, Point[] prev, Point[] curr, int typeOfChange, boolean nextAlso) {
        while (this.undo.size() > this.undoPosition + 1 && this.undo.size() > 0) {
            int last = this.undo.size() - 1;
            this.undo.remove(last);
        }
        ChangeAction ta = new ChangeAction();
        switch (typeOfChange) {
            case 1: {
                ta.setChanged(from, to, pos);
                break;
            }
            case 3: {
                ta.setDelete(from, pos);
                break;
            }
            case 2: {
                ta.setNew(from, pos);
                break;
            }
            case 4: {
                ta.setPosition(from, pos, prev, curr);
                break;
            }
        }
        this.undo.add(ta);
        ++this.undoPosition;
        if (this.undo.size() > this.maxUndo) {
            this.undo.remove(0);
            --this.undoPosition;
        }
    }

    public void clearUndo() {
        this.undo = new ArrayList<ChangeAction>();
        this.undoPosition = -1;
    }

    @Override
    public ChangeAction nextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undoPosition >= size - 1) {
            return null;
        }
        ++this.undoPosition;
        ChangeAction retval = this.undo.get(this.undoPosition);
        return retval;
    }

    @Override
    public ChangeAction viewNextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undoPosition >= size - 1) {
            return null;
        }
        ChangeAction retval = this.undo.get(this.undoPosition + 1);
        return retval;
    }

    @Override
    public ChangeAction previousUndo() {
        if (this.undo.isEmpty() || this.undoPosition < 0) {
            return null;
        }
        ChangeAction retval = this.undo.get(this.undoPosition);
        --this.undoPosition;
        return retval;
    }

    @Override
    public ChangeAction viewThisUndo() {
        if (this.undo.isEmpty() || this.undoPosition < 0) {
            return null;
        }
        ChangeAction retval = this.undo.get(this.undoPosition);
        return retval;
    }

    @Override
    public ChangeAction viewPreviousUndo() {
        if (this.undo.isEmpty() || this.undoPosition < 0) {
            return null;
        }
        ChangeAction retval = this.undo.get(this.undoPosition);
        return retval;
    }

    @Override
    public int getMaxUndo() {
        return this.maxUndo;
    }

    @Override
    public void setMaxUndo(int mu) {
        this.maxUndo = mu;
        while (this.undo.size() > mu && this.undo.size() > 0) {
            this.undo.remove(0);
        }
    }

    public int getUndoSize() {
        if (this.undo == null) {
            return 0;
        }
        return this.undo.size();
    }

    public void setAttributesMap(Map<String, Map<String, String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public Map<String, Map<String, String>> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttribute(String groupName, String key, String value) {
        Map<String, String> attributes = this.getAttributes(groupName);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            this.attributesMap.put(groupName, attributes);
        }
        attributes.put(key, value);
    }

    public void setAttributes(String groupName, Map<String, String> attributes) {
        this.attributesMap.put(groupName, attributes);
    }

    public Map<String, String> getAttributes(String groupName) {
        return this.attributesMap.get(groupName);
    }

    public String getAttribute(String groupName, String key) {
        Map<String, String> attributes = this.attributesMap.get(groupName);
        if (attributes == null) {
            return null;
        }
        return attributes.get(key);
    }

    public void addNote(int p, NotePadMeta ni) {
        this.notes.add(p, ni);
        this.changedNotes = true;
    }

    public void addNote(NotePadMeta ni) {
        this.notes.add(ni);
        this.changedNotes = true;
    }

    public NotePadMeta getNote(int x, int y) {
        int s = this.notes.size();
        for (int i = s - 1; i >= 0; --i) {
            NotePadMeta ni = this.notes.get(i);
            Point loc = ni.getLocation();
            Point p = new Point(loc.x, loc.y);
            if (x < p.x || x > p.x + ni.width + 10 || y < p.y || y > p.y + ni.height + 10) continue;
            return ni;
        }
        return null;
    }

    public NotePadMeta getNote(int i) {
        return this.notes.get(i);
    }

    public List<NotePadMeta> getNotes() {
        return this.notes;
    }

    public List<NotePadMeta> getSelectedNotes() {
        ArrayList<NotePadMeta> selection = new ArrayList<NotePadMeta>();
        for (NotePadMeta note : this.notes) {
            if (!note.isSelected()) continue;
            selection.add(note);
        }
        return selection;
    }

    public int indexOfNote(NotePadMeta ni) {
        return this.notes.indexOf(ni);
    }

    public void lowerNote(int p) {
        if (p > 0 && p < this.notes.size()) {
            NotePadMeta note = this.notes.remove(p);
            this.notes.add(0, note);
            this.changedNotes = true;
        }
    }

    public int nrNotes() {
        return this.notes.size();
    }

    public void raiseNote(int p) {
        if (p >= 0 && p < this.notes.size() - 1) {
            NotePadMeta note = this.notes.remove(p);
            this.notes.add(note);
            this.changedNotes = true;
        }
    }

    public void removeNote(int i) {
        if (i < 0 || i >= this.notes.size()) {
            return;
        }
        this.notes.remove(i);
        this.changedNotes = true;
    }

    public boolean haveNotesChanged() {
        if (this.changedNotes) {
            return true;
        }
        for (int i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta note = this.getNote(i);
            if (!note.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public int[] getNoteIndexes(List<NotePadMeta> notes) {
        int[] retval = new int[notes.size()];
        for (int i = 0; i < notes.size(); ++i) {
            retval[i] = this.indexOfNote(notes.get(i));
        }
        return retval;
    }

    public List<DatabaseMeta> getDatabases() {
        try {
            return this.metadataProvider.getSerializer(DatabaseMeta.class).loadAll();
        }
        catch (HopException e) {
            throw new RuntimeException("Unable to load databases from the metadata", e);
        }
    }

    public String[] getDatabaseNames() {
        try {
            List names = this.metadataProvider.getSerializer(DatabaseMeta.class).listObjectNames();
            Collections.sort(names);
            return names.toArray(new String[0]);
        }
        catch (HopException e) {
            throw new RuntimeException("Unable to get database names from the metadata", e);
        }
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void removeAllParameters() {
        this.namedParams.removeAllParameters();
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    protected abstract void setInternalNameHopVariable(IVariables var1);

    @Override
    public abstract Date getCreatedDate();

    @Override
    public abstract void setCreatedDate(Date var1);

    @Override
    public abstract void setCreatedUser(String var1);

    @Override
    public abstract String getCreatedUser();

    @Override
    public abstract void setModifiedDate(Date var1);

    @Override
    public abstract Date getModifiedDate();

    @Override
    public abstract void setModifiedUser(String var1);

    @Override
    public abstract String getModifiedUser();

    public void clear() {
        this.setName(null);
        this.setFilename(null);
        this.notes = new ArrayList<NotePadMeta>();
        this.attributesMap = new HashMap<String, Map<String, String>>();
        this.maxUndo = 100;
        this.clearUndo();
        this.clearChanged();
        this.setChanged(false);
    }

    @Override
    public void clearChanged() {
        this.changedNotes = false;
        for (int i = 0; i < this.nrNotes(); ++i) {
            this.getNote(i).setChanged(false);
        }
        this.changedFlag.clearChanged();
        this.fireContentChangedListeners(false);
    }

    @Override
    public void setChanged() {
        this.changedFlag.setChanged();
        this.fireContentChangedListeners(true);
    }

    @Override
    public final void setChanged(boolean ch) {
        if (ch) {
            this.setChanged();
        } else {
            this.clearChanged();
        }
    }

    public void addObserver(IHopObserver o) {
        this.changedFlag.addObserver(o);
    }

    public void deleteObserver(IHopObserver o) {
        this.changedFlag.deleteObserver(o);
    }

    public void notifyObservers(Object arg) {
        this.changedFlag.notifyObservers(arg);
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public boolean hasChanged() {
        if (this.changedFlag.hasChanged()) {
            return true;
        }
        return this.haveNotesChanged();
    }

    private boolean nameChanged(String oldName, String newName) {
        if (oldName == null && newName == null) {
            return false;
        }
        if (oldName == null && newName != null) {
            return true;
        }
        return !oldName.equals(newName);
    }

    public boolean hasMissingPlugins() {
        return false;
    }

    protected int compare(AbstractMeta meta1, AbstractMeta meta2) {
        if (StringUtils.isEmpty((String)meta1.getFilename()) && StringUtils.isNotEmpty((String)meta2.getFilename())) {
            return -1;
        }
        if (StringUtils.isNotEmpty((String)meta1.getFilename()) && StringUtils.isEmpty((String)meta2.getFilename())) {
            return 1;
        }
        if (StringUtils.isEmpty((String)meta1.getFilename()) && StringUtils.isEmpty((String)meta2.getFilename()) || meta1.getFilename().equals(meta2.getFilename())) {
            if (Utils.isEmpty((CharSequence)meta1.getName()) && !Utils.isEmpty((CharSequence)meta2.getName())) {
                return -1;
            }
            if (!Utils.isEmpty((CharSequence)meta1.getName()) && Utils.isEmpty((CharSequence)meta2.getName())) {
                return 1;
            }
            int cmpName = meta1.getName().compareTo(meta2.getName());
            return cmpName;
        }
        return meta1.getFilename().compareTo(meta2.getFilename());
    }

    public int hashCode() {
        return Objects.hash(this.filename, this.getName());
    }

    public boolean isClearingLog() {
        return this.runOptions.clearingLog;
    }

    public void setClearingLog(boolean clearingLog) {
        this.runOptions.clearingLog = clearingLog;
    }

    public boolean isSafeModeEnabled() {
        return this.runOptions.safeModeEnabled;
    }

    public void setSafeModeEnabled(boolean safeModeEnabled) {
        this.runOptions.safeModeEnabled = safeModeEnabled;
    }

    private static class RunOptions {
        boolean clearingLog = true;
        boolean safeModeEnabled = false;

        RunOptions() {
        }
    }
}

