/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.Awaitable;

public class BlockingQueues {
    public static <T> BlockingQueue<T> newBlockingQueue() {
        return new LinkedBlockingQueue();
    }

    public static <T> BlockingQueue<T> newBlockingQueue(int capacity) {
        return capacity == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(capacity);
    }

    public static class Sync<T>
    implements BlockingQueue<T> {
        final int capacity;
        final Queue<T> wrapped;

        public Sync(int capacity, Queue<T> wrapped) {
            this.capacity = capacity;
            this.wrapped = wrapped;
        }

        @Override
        public synchronized boolean add(T t) {
            if (!this.wrapped.add(t)) {
                throw new IllegalStateException();
            }
            this.notify();
            return true;
        }

        @Override
        public synchronized boolean offer(T t) {
            if (this.wrapped.size() == this.capacity) {
                return false;
            }
            return this.add(t);
        }

        @Override
        public synchronized T remove() {
            return this.poll();
        }

        @Override
        public synchronized T poll() {
            if (this.wrapped.size() == this.capacity) {
                this.notify();
            }
            return this.wrapped.poll();
        }

        @Override
        public synchronized T element() {
            return this.wrapped.element();
        }

        @Override
        public synchronized T peek() {
            return this.wrapped.peek();
        }

        @Override
        public synchronized void put(T t) throws InterruptedException {
            while (!this.offer(t)) {
                this.wait();
            }
        }

        @Override
        public synchronized boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
            if (this.offer(t)) {
                return true;
            }
            long deadline = Clock.Global.nanoTime() + unit.toNanos(timeout);
            do {
                if (!this.offer(t)) continue;
                return true;
            } while (Awaitable.SyncAwaitable.waitUntil(this, deadline));
            return false;
        }

        @Override
        public synchronized T take() throws InterruptedException {
            T result;
            while (null == (result = this.poll())) {
                this.wait();
            }
            return result;
        }

        @Override
        public synchronized T poll(long timeout, TimeUnit unit) throws InterruptedException {
            T result = this.poll();
            if (result != null) {
                return result;
            }
            long deadline = Clock.Global.nanoTime() + unit.toNanos(timeout);
            while (null == (result = this.poll())) {
                if (Awaitable.SyncAwaitable.waitUntil(this, deadline)) continue;
                return null;
            }
            return result;
        }

        @Override
        public synchronized int remainingCapacity() {
            return this.capacity - this.wrapped.size();
        }

        @Override
        public synchronized boolean remove(Object o) {
            if (!this.wrapped.remove(o)) {
                return false;
            }
            if (this.wrapped.size() == this.capacity - 1) {
                this.notify();
            }
            return true;
        }

        @Override
        public synchronized boolean containsAll(Collection<?> c) {
            return this.wrapped.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(Collection<? extends T> c) {
            c.forEach(this::add);
            return true;
        }

        @Override
        public synchronized boolean removeAll(Collection<?> c) {
            boolean result = this.wrapped.removeAll(c);
            this.notifyAll();
            return result;
        }

        @Override
        public synchronized boolean retainAll(Collection<?> c) {
            boolean result = this.wrapped.retainAll(c);
            this.notifyAll();
            return result;
        }

        @Override
        public synchronized void clear() {
            this.wrapped.clear();
            this.notifyAll();
        }

        @Override
        public synchronized int size() {
            return this.wrapped.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public synchronized boolean contains(Object o) {
            return this.wrapped.contains(o);
        }

        @Override
        public synchronized Iterator<T> iterator() {
            final Iterator iter = this.wrapped.iterator();
            return new Iterator<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    Sync sync = this;
                    synchronized (sync) {
                        return iter.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T next() {
                    Sync sync = this;
                    synchronized (sync) {
                        return iter.next();
                    }
                }
            };
        }

        @Override
        public synchronized Object[] toArray() {
            return this.wrapped.toArray();
        }

        @Override
        public synchronized <T1> T1[] toArray(T1[] a) {
            return this.wrapped.toArray(a);
        }

        @Override
        public synchronized int drainTo(Collection<? super T> c) {
            return this.drainTo(c, Integer.MAX_VALUE);
        }

        @Override
        public synchronized int drainTo(Collection<? super T> c, int maxElements) {
            int count;
            for (count = 0; count < maxElements && !this.isEmpty(); ++count) {
                c.add(this.poll());
            }
            return count;
        }
    }
}

