/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoVerbHandler
implements IVerbHandler<NoPayload> {
    public static final EchoVerbHandler instance = new EchoVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(EchoVerbHandler.class);

    @Override
    public void doVerb(Message<NoPayload> message) {
        if (!StorageService.instance.isShutdown()) {
            logger.trace("Sending ECHO_RSP to {}", (Object)message.from());
            MessagingService.instance().send(message.emptyResponse(), message.from());
        } else {
            logger.trace("Not sending ECHO_RSP to {} - we are shutting down", (Object)message.from());
        }
    }
}

