/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.utils.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterMutationVerbHandler
implements IVerbHandler<CounterMutation> {
    public static final CounterMutationVerbHandler instance = new CounterMutationVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(CounterMutationVerbHandler.class);

    @Override
    public void doVerb(Message<CounterMutation> message) {
        long queryStartNanoTime = Clock.Global.nanoTime();
        CounterMutation cm = (CounterMutation)message.payload;
        logger.trace("Applying forwarded {}", (Object)cm);
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter();
        StorageProxy.applyCounterMutationOnLeader(cm, localDataCenter, () -> MessagingService.instance().send(message.emptyResponse(), message.from()), queryStartNanoTime);
    }
}

