/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Operations;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.Validation;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.conditions.ColumnCondition;
import org.apache.cassandra.cql3.conditions.ColumnConditions;
import org.apache.cassandra.cql3.conditions.Conditions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.CQL3CasRequest;
import org.apache.cassandra.cql3.statements.QualifiedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.cql3.statements.SingleTableUpdatesCollector;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.cql3.statements.UpdatesCollector;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaLayout;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.disk.usage.DiskUsageBroadcaster;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.BallotGenerator;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.triggers.TriggerExecutor;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModificationStatement
implements CQLStatement.SingleKeyspaceCqlStatement {
    protected static final Logger logger = LoggerFactory.getLogger(ModificationStatement.class);
    private static final MD5Digest EMPTY_HASH = MD5Digest.wrap(new byte[0]);
    public static final String CUSTOM_EXPRESSIONS_NOT_ALLOWED = "Custom index expressions cannot be used in WHERE clauses for UPDATE or DELETE statements";
    private static final ColumnIdentifier CAS_RESULT_COLUMN = new ColumnIdentifier("[applied]", false);
    protected final StatementType type;
    protected final VariableSpecifications bindVariables;
    public final TableMetadata metadata;
    private final Attributes attrs;
    private final StatementRestrictions restrictions;
    private final Operations operations;
    private final RegularAndStaticColumns updatedColumns;
    private final Conditions conditions;
    private final RegularAndStaticColumns conditionColumns;
    private final RegularAndStaticColumns requiresRead;

    public ModificationStatement(StatementType type, VariableSpecifications bindVariables, TableMetadata metadata, Operations operations, StatementRestrictions restrictions, Conditions conditions, Attributes attrs) {
        this.type = type;
        this.bindVariables = bindVariables;
        this.metadata = metadata;
        this.restrictions = restrictions;
        this.operations = operations;
        this.conditions = conditions;
        this.attrs = attrs;
        if (!conditions.isEmpty()) {
            RequestValidations.checkFalse(metadata.isCounter(), "Conditional updates are not supported on counter tables");
            RequestValidations.checkFalse(attrs.isTimestampSet(), "Cannot provide custom timestamp for conditional updates");
        }
        RegularAndStaticColumns.Builder conditionColumnsBuilder = RegularAndStaticColumns.builder();
        Iterable<ColumnMetadata> columns = conditions.getColumns();
        if (columns != null) {
            conditionColumnsBuilder.addAll(columns);
        }
        RegularAndStaticColumns.Builder updatedColumnsBuilder = RegularAndStaticColumns.builder();
        RegularAndStaticColumns.Builder requiresReadBuilder = RegularAndStaticColumns.builder();
        for (Operation operation : operations) {
            updatedColumnsBuilder.add(operation.column);
            if (!operation.requiresRead()) continue;
            conditionColumnsBuilder.add(operation.column);
            requiresReadBuilder.add(operation.column);
        }
        RegularAndStaticColumns modifiedColumns = updatedColumnsBuilder.build();
        if (metadata.isCompactTable() && modifiedColumns.isEmpty() && this.updatesRegularRows()) {
            modifiedColumns = metadata.regularAndStaticColumns();
        }
        this.updatedColumns = modifiedColumns;
        this.conditionColumns = conditionColumnsBuilder.build();
        this.requiresRead = requiresReadBuilder.build();
    }

    @Override
    public List<ColumnSpecification> getBindVariables() {
        return this.bindVariables.getBindVariables();
    }

    @Override
    public short[] getPartitionKeyBindVariableIndexes() {
        return this.bindVariables.getPartitionKeyBindVariableIndexes(this.metadata);
    }

    @Override
    public Iterable<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        this.addFunctionsTo(functions);
        return functions;
    }

    public void addFunctionsTo(List<Function> functions) {
        this.attrs.addFunctionsTo(functions);
        this.restrictions.addFunctionsTo(functions);
        this.operations.addFunctionsTo(functions);
        this.conditions.addFunctionsTo(functions);
    }

    public TableMetadata metadata() {
        return this.metadata;
    }

    public StatementRestrictions getRestrictions() {
        return this.restrictions;
    }

    public abstract void addUpdateForKey(PartitionUpdate.Builder var1, Clustering<?> var2, UpdateParameters var3);

    public abstract void addUpdateForKey(PartitionUpdate.Builder var1, Slice var2, UpdateParameters var3);

    @Override
    public String keyspace() {
        return this.metadata.keyspace;
    }

    public String table() {
        return this.metadata.name;
    }

    public boolean isCounter() {
        return this.metadata().isCounter();
    }

    public boolean isView() {
        return this.metadata().isView();
    }

    public boolean isVirtual() {
        return this.metadata().isVirtual();
    }

    public long getTimestamp(long now, QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimestamp(now, options);
    }

    public boolean isTimestampSet() {
        return this.attrs.isTimestampSet();
    }

    public int getTimeToLive(QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimeToLive(options, this.metadata);
    }

    @Override
    public void authorize(ClientState state) throws InvalidRequestException, UnauthorizedException {
        Iterator<ViewMetadata> views;
        state.ensureTablePermission(this.metadata, Permission.MODIFY);
        if (this.hasConditions()) {
            state.ensureTablePermission(this.metadata, Permission.SELECT);
        }
        if ((views = View.findAll(this.keyspace(), this.table()).iterator()).hasNext()) {
            state.ensureTablePermission(this.metadata, Permission.SELECT);
            do {
                state.ensureTablePermission(views.next().metadata, Permission.MODIFY);
            } while (views.hasNext());
        }
        for (Function function : this.getFunctions()) {
            state.ensurePermission(Permission.EXECUTE, function);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        RequestValidations.checkFalse(this.hasConditions() && this.attrs.isTimestampSet(), "Cannot provide custom timestamp for conditional updates");
        RequestValidations.checkFalse(this.isCounter() && this.attrs.isTimestampSet(), "Cannot provide custom timestamp for counter updates");
        RequestValidations.checkFalse(this.isCounter() && this.attrs.isTimeToLiveSet(), "Cannot provide custom TTL for counter updates");
        RequestValidations.checkFalse(this.isView(), "Cannot directly modify a materialized view");
        RequestValidations.checkFalse(this.isVirtual() && this.attrs.isTimestampSet(), "Custom timestamp is not supported by virtual tables");
        RequestValidations.checkFalse(this.isVirtual() && this.attrs.isTimeToLiveSet(), "Expiring columns are not supported by virtual tables");
        RequestValidations.checkFalse(this.isVirtual() && this.hasConditions(), "Conditional updates are not supported by virtual tables");
        if (this.attrs.isTimestampSet()) {
            Guardrails.userTimestampsEnabled.ensureEnabled(state);
        }
    }

    public void validateDiskUsage(QueryOptions options, ClientState state) {
        if (Guardrails.replicaDiskUsage.enabled(state) && DiskUsageBroadcaster.instance.hasStuffedOrFullNode()) {
            Keyspace keyspace = Keyspace.open(this.keyspace());
            for (ByteBuffer key : this.buildPartitionKeyNames(options, state)) {
                Token token = this.metadata().partitioner.getToken(key);
                for (Replica replica : (EndpointsForToken)ReplicaLayout.forTokenWriteLiveAndDown(keyspace, token).all()) {
                    Guardrails.replicaDiskUsage.guard(replica.endpoint(), state);
                }
            }
        }
    }

    public RegularAndStaticColumns updatedColumns() {
        return this.updatedColumns;
    }

    public RegularAndStaticColumns conditionColumns() {
        return this.conditionColumns;
    }

    public boolean updatesRegularRows() {
        return this.metadata().clusteringColumns().isEmpty() || this.restrictions.hasClusteringColumnsRestrictions();
    }

    public boolean updatesStaticRow() {
        return this.operations.appliesToStaticColumns();
    }

    public List<Operation> getRegularOperations() {
        return this.operations.regularOperations();
    }

    public List<Operation> getStaticOperations() {
        return this.operations.staticOperations();
    }

    public Iterable<Operation> allOperations() {
        return this.operations;
    }

    public Iterable<ColumnMetadata> getColumnsWithConditions() {
        return this.conditions.getColumns();
    }

    public boolean hasIfNotExistCondition() {
        return this.conditions.isIfNotExists();
    }

    public boolean hasIfExistCondition() {
        return this.conditions.isIfExists();
    }

    public List<ByteBuffer> buildPartitionKeyNames(QueryOptions options, ClientState state) throws InvalidRequestException {
        List<ByteBuffer> partitionKeys = this.restrictions.getPartitionKeys(options, state);
        for (ByteBuffer key : partitionKeys) {
            QueryProcessor.validateKey(key);
        }
        return partitionKeys;
    }

    public NavigableSet<Clustering<?>> createClustering(QueryOptions options, ClientState state) throws InvalidRequestException {
        if (this.appliesOnlyToStaticColumns() && !this.restrictions.hasClusteringColumnsRestrictions()) {
            return FBUtilities.singleton(CBuilder.STATIC_BUILDER.build(), this.metadata().comparator);
        }
        return this.restrictions.getClusteringColumns(options, state);
    }

    private boolean appliesOnlyToStaticColumns() {
        return ModificationStatement.appliesOnlyToStaticColumns(this.operations, this.conditions);
    }

    public static boolean appliesOnlyToStaticColumns(Operations operation, Conditions conditions) {
        return !operation.appliesToRegularColumns() && !conditions.appliesToRegularColumns() && (operation.appliesToStaticColumns() || conditions.appliesToStaticColumns());
    }

    public boolean requiresRead() {
        return !this.requiresRead.isEmpty();
    }

    /*
     * Exception decompiling
     */
    private Map<DecoratedKey, Partition> readRequiredLists(Collection<ByteBuffer> partitionKeys, ClusteringIndexFilter filter, DataLimits limits, boolean local, ConsistencyLevel cl, int nowInSeconds, long queryStartNanoTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<DecoratedKey, Partition> asMaterializedMap(PartitionIterator iterator) {
        HashMap<DecoratedKey, Partition> map = new HashMap<DecoratedKey, Partition>();
        while (iterator.hasNext()) {
            RowIterator partition = (RowIterator)iterator.next();
            Throwable throwable = null;
            try {
                map.put(partition.partitionKey(), FilteredPartition.create(partition));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
        return map;
    }

    @Override
    public boolean hasConditions() {
        return !this.conditions.isEmpty();
    }

    public boolean hasSlices() {
        return this.type.allowClusteringColumnSlices() && this.getRestrictions().hasClusteringColumnsRestrictions() && this.getRestrictions().isColumnRange();
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        Guardrails.writeConsistencyLevels.guard(EnumSet.of(options.getConsistency(), options.getSerialConsistency()), queryState.getClientState());
        return this.hasConditions() ? this.executeWithCondition(queryState, options, queryStartNanoTime) : this.executeWithoutCondition(queryState, options, queryStartNanoTime);
    }

    private ResultMessage executeWithoutCondition(QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        if (this.isVirtual()) {
            return this.executeInternalWithoutCondition(queryState, options, queryStartNanoTime);
        }
        ConsistencyLevel cl = options.getConsistency();
        if (this.isCounter()) {
            cl.validateCounterForWrite(this.metadata());
        } else {
            cl.validateForWrite();
        }
        this.validateDiskUsage(options, queryState.getClientState());
        List<? extends IMutation> mutations = this.getMutations(queryState.getClientState(), options, false, options.getTimestamp(queryState), options.getNowInSeconds(queryState), queryStartNanoTime);
        if (!mutations.isEmpty()) {
            StorageProxy.mutateWithTriggers(mutations, cl, false, queryStartNanoTime);
        }
        return null;
    }

    private ResultMessage executeWithCondition(QueryState queryState, QueryOptions options, long queryStartNanoTime) {
        CQL3CasRequest request = this.makeCasRequest(queryState, options);
        try (RowIterator result = StorageProxy.cas(this.keyspace(), this.table(), request.key, request, options.getSerialConsistency(), options.getConsistency(), queryState.getClientState(), options.getNowInSeconds(queryState), queryStartNanoTime);){
            ResultMessage.Rows rows = new ResultMessage.Rows(this.buildCasResultSet(result, queryState, options));
            return rows;
        }
    }

    private CQL3CasRequest makeCasRequest(QueryState queryState, QueryOptions options) {
        ClientState clientState = queryState.getClientState();
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options, clientState);
        RequestValidations.checkFalse(this.restrictions.keyIsInRelation(), "IN on the partition key is not supported with conditional %s", this.type.isUpdate() ? "updates" : "deletions");
        DecoratedKey key = this.metadata().partitioner.decorateKey(keys.get(0));
        long timestamp = options.getTimestamp(queryState);
        int nowInSeconds = options.getNowInSeconds(queryState);
        RequestValidations.checkFalse(this.restrictions.clusteringKeyRestrictionsHasIN(), "IN on the clustering key columns is not supported with conditional %s", this.type.isUpdate() ? "updates" : "deletions");
        Clustering clustering = (Clustering)Iterables.getOnlyElement(this.createClustering(options, clientState));
        CQL3CasRequest request = new CQL3CasRequest(this.metadata(), key, this.conditionColumns(), this.updatesRegularRows(), this.updatesStaticRow());
        this.addConditions(clustering, request, options);
        request.addRowUpdate(clustering, this, options, timestamp, nowInSeconds);
        return request;
    }

    public void addConditions(Clustering<?> clustering, CQL3CasRequest request, QueryOptions options) throws InvalidRequestException {
        this.conditions.addConditionsTo(request, clustering, options);
    }

    private static ResultSet.ResultMetadata buildCASSuccessMetadata(String ksName, String cfName) {
        ArrayList<ColumnSpecification> specs = new ArrayList<ColumnSpecification>();
        specs.add(ModificationStatement.casResultColumnSpecification(ksName, cfName));
        return new ResultSet.ResultMetadata(EMPTY_HASH, specs);
    }

    private static ColumnSpecification casResultColumnSpecification(String ksName, String cfName) {
        return new ColumnSpecification(ksName, cfName, CAS_RESULT_COLUMN, BooleanType.instance);
    }

    private ResultSet buildCasResultSet(RowIterator partition, QueryState state, QueryOptions options) {
        return ModificationStatement.buildCasResultSet(this.keyspace(), this.table(), partition, this.getColumnsWithConditions(), false, state, options);
    }

    static ResultSet buildCasResultSet(String ksName, String tableName, RowIterator partition, Iterable<ColumnMetadata> columnsWithConditions, boolean isBatch, QueryState state, QueryOptions options) {
        boolean success = partition == null;
        ResultSet.ResultMetadata metadata = ModificationStatement.buildCASSuccessMetadata(ksName, tableName);
        List<List<ByteBuffer>> rows = Collections.singletonList(Collections.singletonList(BooleanType.instance.decompose(success)));
        ResultSet rs = new ResultSet(metadata, rows);
        return success ? rs : ModificationStatement.merge(rs, ModificationStatement.buildCasFailureResultSet(partition, columnsWithConditions, isBatch, options, options.getNowInSeconds(state)));
    }

    private static ResultSet merge(ResultSet left, ResultSet right) {
        if (left.size() == 0) {
            return right;
        }
        if (right.size() == 0) {
            return left;
        }
        assert (left.size() == 1);
        int size = left.metadata.names.size() + right.metadata.names.size();
        ArrayList<ColumnSpecification> specs = new ArrayList<ColumnSpecification>(size);
        specs.addAll(left.metadata.names);
        specs.addAll(right.metadata.names);
        ArrayList<List<ByteBuffer>> rows = new ArrayList<List<ByteBuffer>>(right.size());
        for (int i = 0; i < right.size(); ++i) {
            ArrayList row = new ArrayList(size);
            row.addAll(left.rows.get(0));
            row.addAll(right.rows.get(i));
            rows.add(row);
        }
        return new ResultSet(new ResultSet.ResultMetadata(EMPTY_HASH, specs), rows);
    }

    private static ResultSet buildCasFailureResultSet(RowIterator partition, Iterable<ColumnMetadata> columnsWithConditions, boolean isBatch, QueryOptions options, int nowInSeconds) {
        Selection selection;
        TableMetadata metadata = partition.metadata();
        if (columnsWithConditions == null) {
            selection = Selection.wildcard(metadata, false, false);
        } else {
            LinkedHashSet defs = new LinkedHashSet();
            if (isBatch) {
                Iterables.addAll(defs, metadata.primaryKeyColumns());
            }
            Iterables.addAll(defs, columnsWithConditions);
            selection = Selection.forColumns(metadata, new ArrayList<ColumnMetadata>(defs), false);
        }
        Selection.Selectors selectors = selection.newSelectors(options);
        ResultSetBuilder builder = new ResultSetBuilder(selection.getResultMetadata(), selectors);
        SelectStatement.forSelection(metadata, selection).processPartition(partition, options, builder, nowInSeconds);
        return builder.build();
    }

    @Override
    public ResultMessage executeLocally(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        return this.hasConditions() ? this.executeInternalWithCondition(queryState, options) : this.executeInternalWithoutCondition(queryState, options, Clock.Global.nanoTime());
    }

    public ResultMessage executeInternalWithoutCondition(QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestValidationException, RequestExecutionException {
        long timestamp = options.getTimestamp(queryState);
        int nowInSeconds = options.getNowInSeconds(queryState);
        for (IMutation iMutation : this.getMutations(queryState.getClientState(), options, true, timestamp, nowInSeconds, queryStartNanoTime)) {
            iMutation.apply();
        }
        return null;
    }

    public ResultMessage executeInternalWithCondition(QueryState state, QueryOptions options) {
        CQL3CasRequest request = this.makeCasRequest(state, options);
        try (RowIterator result = ModificationStatement.casInternal(state.getClientState(), request, options.getTimestamp(state), options.getNowInSeconds(state));){
            ResultMessage.Rows rows = new ResultMessage.Rows(this.buildCasResultSet(result, state, options));
            return rows;
        }
    }

    static RowIterator casInternal(ClientState state, CQL3CasRequest request, long timestamp, int nowInSeconds) {
        FilteredPartition current;
        Ballot ballot = BallotGenerator.Global.atUnixMicros(timestamp, Ballot.Flag.NONE);
        SinglePartitionReadCommand readCommand = request.readCommand(nowInSeconds);
        try (ReadExecutionController executionController = readCommand.executionController();
             PartitionIterator iter = readCommand.executeInternal(executionController);){
            current = FilteredPartition.create(PartitionIterators.getOnlyElement(iter, readCommand));
        }
        if (!request.appliesTo(current)) {
            return current.rowIterator();
        }
        PartitionUpdate updates = request.makeUpdates(current, state, ballot);
        updates = TriggerExecutor.instance.execute(updates);
        Commit.Proposal proposal = Commit.Proposal.of(ballot, updates);
        proposal.makeMutation().apply();
        return null;
    }

    private List<? extends IMutation> getMutations(ClientState state, QueryOptions options, boolean local, long timestamp, int nowInSeconds, long queryStartNanoTime) {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options, state);
        HashMultiset perPartitionKeyCounts = HashMultiset.create(keys);
        SingleTableUpdatesCollector collector = new SingleTableUpdatesCollector(this.metadata, this.updatedColumns, (HashMultiset<ByteBuffer>)perPartitionKeyCounts);
        this.addUpdates(collector, keys, state, options, local, timestamp, nowInSeconds, queryStartNanoTime);
        return collector.toMutations();
    }

    final void addUpdates(UpdatesCollector collector, List<ByteBuffer> keys, ClientState state, QueryOptions options, boolean local, long timestamp, int nowInSeconds, long queryStartNanoTime) {
        if (this.hasSlices()) {
            Slices slices = this.createSlices(options);
            if (slices.isEmpty()) {
                return;
            }
            UpdateParameters params = this.makeUpdateParameters(keys, new ClusteringIndexSliceFilter(slices, false), state, options, DataLimits.NONE, local, timestamp, nowInSeconds, queryStartNanoTime);
            for (ByteBuffer key : keys) {
                Validation.validateKey(this.metadata(), key);
                DecoratedKey dk = this.metadata().partitioner.decorateKey(key);
                PartitionUpdate.Builder updateBuilder = collector.getPartitionUpdateBuilder(this.metadata(), dk, options.getConsistency());
                for (Slice slice : slices) {
                    this.addUpdateForKey(updateBuilder, slice, params);
                }
            }
        } else {
            NavigableSet<Clustering<?>> clusterings = this.createClustering(options, state);
            if (this.restrictions.hasClusteringColumnsRestrictions() && clusterings.isEmpty()) {
                return;
            }
            UpdateParameters params = this.makeUpdateParameters(keys, clusterings, state, options, local, timestamp, nowInSeconds, queryStartNanoTime);
            for (ByteBuffer key : keys) {
                Validation.validateKey(this.metadata(), key);
                DecoratedKey dk = this.metadata().partitioner.decorateKey(key);
                PartitionUpdate.Builder updateBuilder = collector.getPartitionUpdateBuilder(this.metadata(), dk, options.getConsistency());
                if (!this.restrictions.hasClusteringColumnsRestrictions()) {
                    this.addUpdateForKey(updateBuilder, Clustering.EMPTY, params);
                    continue;
                }
                for (Clustering<?> clustering : clusterings) {
                    this.validateClustering(clustering);
                    this.addUpdateForKey(updateBuilder, clustering, params);
                }
            }
        }
    }

    private <V> void validateClustering(Clustering<V> clustering) {
        ValueAccessor accessor = clustering.accessor();
        for (Object v : clustering.getRawValues()) {
            if (v == null || accessor.size(v) <= 65535) continue;
            throw new InvalidRequestException(String.format("Key length of %d is longer than maximum of %d", clustering.dataSize(), 65535));
        }
    }

    public Slices createSlices(QueryOptions options) {
        NavigableSet<ClusteringBound<?>> startBounds = this.restrictions.getClusteringColumnsBounds(Bound.START, options);
        NavigableSet<ClusteringBound<?>> endBounds = this.restrictions.getClusteringColumnsBounds(Bound.END, options);
        return this.toSlices(startBounds, endBounds);
    }

    private UpdateParameters makeUpdateParameters(Collection<ByteBuffer> keys, NavigableSet<Clustering<?>> clusterings, ClientState state, QueryOptions options, boolean local, long timestamp, int nowInSeconds, long queryStartNanoTime) {
        if (clusterings.contains(Clustering.STATIC_CLUSTERING)) {
            return this.makeUpdateParameters(keys, new ClusteringIndexSliceFilter(Slices.ALL, false), state, options, DataLimits.cqlLimits(1), local, timestamp, nowInSeconds, queryStartNanoTime);
        }
        return this.makeUpdateParameters(keys, new ClusteringIndexNamesFilter(clusterings, false), state, options, DataLimits.NONE, local, timestamp, nowInSeconds, queryStartNanoTime);
    }

    private UpdateParameters makeUpdateParameters(Collection<ByteBuffer> keys, ClusteringIndexFilter filter, ClientState state, QueryOptions options, DataLimits limits, boolean local, long timestamp, int nowInSeconds, long queryStartNanoTime) {
        Map<DecoratedKey, Partition> lists = this.readRequiredLists(keys, filter, limits, local, options.getConsistency(), nowInSeconds, queryStartNanoTime);
        return new UpdateParameters(this.metadata(), this.updatedColumns(), state, options, this.getTimestamp(timestamp, options), nowInSeconds, this.getTimeToLive(options), lists);
    }

    private Slices toSlices(SortedSet<ClusteringBound<?>> startBounds, SortedSet<ClusteringBound<?>> endBounds) {
        return ModificationStatement.toSlices(this.metadata, startBounds, endBounds);
    }

    public static Slices toSlices(TableMetadata metadata, SortedSet<ClusteringBound<?>> startBounds, SortedSet<ClusteringBound<?>> endBounds) {
        return ModificationStatement.toSlices(metadata.comparator, startBounds, endBounds);
    }

    public static Slices toSlices(ClusteringComparator comparator, SortedSet<ClusteringBound<?>> startBounds, SortedSet<ClusteringBound<?>> endBounds) {
        assert (startBounds.size() == endBounds.size());
        Slices.Builder builder = new Slices.Builder(comparator);
        Iterator starts = startBounds.iterator();
        Iterator ends = endBounds.iterator();
        while (starts.hasNext()) {
            Slice slice = Slice.make((ClusteringBound)starts.next(), (ClusteringBound)ends.next());
            if (slice.isEmpty(comparator)) continue;
            builder.add(slice);
        }
        return builder.build();
    }

    public static abstract class Parsed
    extends QualifiedStatement {
        protected final StatementType type;
        private final Attributes.Raw attrs;
        private final List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions;
        private final boolean ifNotExists;
        private final boolean ifExists;

        protected Parsed(QualifiedName name, StatementType type, Attributes.Raw attrs, List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions, boolean ifNotExists, boolean ifExists) {
            super(name);
            this.type = type;
            this.attrs = attrs;
            this.conditions = conditions == null ? Collections.emptyList() : conditions;
            this.ifNotExists = ifNotExists;
            this.ifExists = ifExists;
        }

        @Override
        public ModificationStatement prepare(ClientState state) {
            return this.prepare(this.bindVariables);
        }

        public ModificationStatement prepare(VariableSpecifications bindVariables) {
            TableMetadata metadata = Schema.instance.validateTable(this.keyspace(), this.name());
            Attributes preparedAttributes = this.attrs.prepare(this.keyspace(), this.name());
            preparedAttributes.collectMarkerSpecification(bindVariables);
            Conditions preparedConditions = this.prepareConditions(metadata, bindVariables);
            return this.prepareInternal(metadata, bindVariables, preparedConditions, preparedAttributes);
        }

        private Conditions prepareConditions(TableMetadata metadata, VariableSpecifications bindVariables) {
            if (this.ifExists) {
                assert (this.conditions.isEmpty());
                assert (!this.ifNotExists);
                return Conditions.IF_EXISTS_CONDITION;
            }
            if (this.ifNotExists) {
                assert (this.conditions.isEmpty());
                assert (!this.ifExists);
                return Conditions.IF_NOT_EXISTS_CONDITION;
            }
            if (this.conditions.isEmpty()) {
                return Conditions.EMPTY_CONDITION;
            }
            return this.prepareColumnConditions(metadata, bindVariables);
        }

        private ColumnConditions prepareColumnConditions(TableMetadata metadata, VariableSpecifications bindVariables) {
            RequestValidations.checkNull(this.attrs.timestamp, "Cannot provide custom timestamp for conditional updates");
            ColumnConditions.Builder builder = ColumnConditions.newBuilder();
            for (Pair<ColumnIdentifier, ColumnCondition.Raw> entry : this.conditions) {
                ColumnMetadata def = metadata.getExistingColumn((ColumnIdentifier)entry.left);
                ColumnCondition condition = ((ColumnCondition.Raw)entry.right).prepare(this.keyspace(), def, metadata);
                condition.collectMarkerSpecification(bindVariables);
                RequestValidations.checkFalse(def.isPrimaryKeyColumn(), "PRIMARY KEY column '%s' cannot have IF conditions", def.name);
                builder.add(condition);
            }
            return builder.build();
        }

        protected abstract ModificationStatement prepareInternal(TableMetadata var1, VariableSpecifications var2, Conditions var3, Attributes var4);

        protected StatementRestrictions newRestrictions(TableMetadata metadata, VariableSpecifications boundNames, Operations operations, WhereClause where, Conditions conditions) {
            if (where.containsCustomExpressions()) {
                throw new InvalidRequestException(ModificationStatement.CUSTOM_EXPRESSIONS_NOT_ALLOWED);
            }
            boolean applyOnlyToStaticColumns = ModificationStatement.appliesOnlyToStaticColumns(operations, conditions);
            return new StatementRestrictions(this.type, metadata, where, boundNames, applyOnlyToStaticColumns, false, false);
        }

        public List<Pair<ColumnIdentifier, ColumnCondition.Raw>> getConditions() {
            return this.conditions;
        }
    }
}

