/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.Callable;
import org.apache.cassandra.concurrent.ExecutionFailure;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.apache.cassandra.utils.concurrent.RunnableFuture;

public class FutureTask<V>
extends AsyncFuture<V>
implements RunnableFuture<V> {
    private Callable<? extends V> call;

    public FutureTask(Callable<? extends V> call) {
        this.call = call;
    }

    public FutureTask(Runnable run) {
        this.call = FutureTask.callable(run);
    }

    V call() throws Exception {
        return this.call.call();
    }

    @Override
    public void run() {
        try {
            if (!this.setUncancellable()) {
                return;
            }
            this.trySuccess(this.call());
        }
        catch (Throwable t) {
            this.tryFailure(t);
        }
        finally {
            this.call = null;
        }
    }

    @Override
    protected boolean tryFailure(Throwable t) {
        ExecutionFailure.handle(t);
        return super.tryFailure(t);
    }

    public static <T> Callable<T> callable(final Runnable run) {
        return new Callable<T>(){

            @Override
            public T call() {
                run.run();
                return null;
            }

            public String toString() {
                return run.toString();
            }
        };
    }

    public static <T> Callable<T> callable(final Object id, final Runnable run) {
        return new Callable<T>(){

            @Override
            public T call() {
                run.run();
                return null;
            }

            public String toString() {
                return id.toString();
            }
        };
    }

    public static <T> Callable<T> callable(final Runnable run, final T result) {
        return new Callable<T>(){

            @Override
            public T call() {
                run.run();
                return result;
            }

            public String toString() {
                return run + "->" + result;
            }
        };
    }

    public static <T> Callable<T> callable(final Object id, final Runnable run, final T result) {
        return new Callable<T>(){

            @Override
            public T call() {
                run.run();
                return result;
            }

            public String toString() {
                return id.toString();
            }
        };
    }

    @Override
    protected String description() {
        Callable<? extends V> desc = this.call;
        return desc == null ? null : this.call.toString();
    }
}

