/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.client.program.StreamContextEnvironment;
import org.apache.flink.client.program.rest.retry.ExponentialWaitStrategy;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.runtime.client.JobInitializationException;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ClientUtils {

    private static final Logger LOG = LoggerFactory.getLogger(ClientUtils.class);

    public static URLClassLoader buildUserCodeClassLoader(List<URL> jars, List<URL> classpaths, ClassLoader parent, Configuration configuration) {
        int i;
        URL[] urls = new URL[jars.size() + classpaths.size()];
        for (i = 0; i < jars.size(); ++i) {
            urls[i] = jars.get(i);
        }
        for (i = 0; i < classpaths.size(); ++i) {
            urls[i + jars.size()] = classpaths.get(i);
        }
        return FlinkUserCodeClassLoaders.create((URL[])urls, (ClassLoader)parent, (ReadableConfig)configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeProgram(PipelineExecutorServiceLoader executorServiceLoader, Configuration configuration, PackagedProgram program, boolean enforceSingleJobExecution, boolean suppressSysout) throws ProgramInvocationException {
        Preconditions.checkNotNull((Object)executorServiceLoader);
        ClassLoader userCodeClassLoader = program.getUserCodeClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(userCodeClassLoader);
            LOG.info("Starting program (detached: {})", (Object)(!configuration.getBoolean(DeploymentOptions.ATTACHED) ? 1 : 0));
            ContextEnvironment.setAsContext(executorServiceLoader, configuration, userCodeClassLoader, enforceSingleJobExecution, suppressSysout);
            StreamContextEnvironment.setAsContext(executorServiceLoader, configuration, userCodeClassLoader, enforceSingleJobExecution, suppressSysout);
            try {
                program.invokeInteractiveModeForExecution();
            }
            finally {
                ContextEnvironment.unsetAsContext();
                StreamContextEnvironment.unsetAsContext();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static void waitUntilJobInitializationFinished(SupplierWithException<JobStatus, Exception> jobStatusSupplier, SupplierWithException<JobResult, Exception> jobResultSupplier, ClassLoader userCodeClassloader) throws JobInitializationException {
        LOG.debug("Wait until job initialization is finished");
        ExponentialWaitStrategy waitStrategy = new ExponentialWaitStrategy(50L, 2000L);
        try {
            Throwable t;
            JobResult result;
            Optional throwable;
            JobStatus status = (JobStatus)jobStatusSupplier.get();
            long attempt = 0L;
            while (status == JobStatus.INITIALIZING) {
                Thread.sleep(waitStrategy.sleepTime(attempt++));
                status = (JobStatus)jobStatusSupplier.get();
            }
            if (status == JobStatus.FAILED && (throwable = (result = (JobResult)jobResultSupplier.get()).getSerializedThrowable()).isPresent() && (t = ((SerializedThrowable)throwable.get()).deserializeError(userCodeClassloader)) instanceof JobInitializationException) {
                throw t;
            }
        }
        catch (JobInitializationException initializationException) {
            throw initializationException;
        }
        catch (Throwable throwable) {
            ExceptionUtils.checkInterrupted((Throwable)throwable);
            throw new RuntimeException("Error while waiting for job to be initialized", throwable);
        }
    }
}

