/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.parser;

import org.monetdb.mcl.parser.MCLParseException;
import org.monetdb.mcl.parser.MCLParser;

public final class TupleLineParser
extends MCLParser {
    private StringBuilder uesc = null;

    public TupleLineParser(int n) {
        super(n);
    }

    @Override
    public int parse(String string) throws MCLParseException {
        int n = string.length();
        if (n <= 0) {
            throw new MCLParseException("Missing tuple data");
        }
        char c = string.charAt(0);
        if (c == '=') {
            if (this.values.length != 1) {
                throw new MCLParseException(this.values.length + " columns expected, but only single value found");
            }
            this.values[0] = string.substring(1);
            this.colnr = 0;
            return 0;
        }
        if (c != '[') {
            throw new MCLParseException("Expected a data row starting with [");
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 2;
        block14: for (int i = 2; i < n; ++i) {
            switch (cArray[i]) {
                case '\\': {
                    bl2 = !bl2;
                    bl3 = true;
                    continue block14;
                }
                case '\"': {
                    if (!bl) {
                        bl = true;
                    } else if (!bl2) {
                        bl = false;
                    }
                    bl2 = false;
                    continue block14;
                }
                case '\t': {
                    if (!bl && (cArray[i - 1] == ',' || i + 1 == n - 1 && cArray[++i] == ']')) {
                        int n4;
                        int n5 = i - 2;
                        if (cArray[n3] == '\"' && cArray[n5] == '\"') {
                            n4 = n5 - ++n3;
                            if (bl3) {
                                if (this.uesc == null) {
                                    this.uesc = new StringBuilder(n4 > 1024 ? n4 : 1024);
                                } else {
                                    this.uesc.setLength(0);
                                    if (n4 > 1024) {
                                        this.uesc.ensureCapacity(n4);
                                    }
                                }
                                for (int j = n3; j < n5; ++j) {
                                    c = cArray[j];
                                    if (c == '\\' && j + 1 < n5) {
                                        c = cArray[++j];
                                        switch (c) {
                                            case 'f': {
                                                this.uesc.append('\f');
                                                break;
                                            }
                                            case 'n': {
                                                this.uesc.append('\n');
                                                break;
                                            }
                                            case 'r': {
                                                this.uesc.append('\r');
                                                break;
                                            }
                                            case 't': {
                                                this.uesc.append('\t');
                                                break;
                                            }
                                            case '0': 
                                            case '1': 
                                            case '2': 
                                            case '3': {
                                                if (j + 2 < n5) {
                                                    char c2 = cArray[j + 1];
                                                    char c3 = cArray[j + 2];
                                                    if (c2 >= '0' && c2 <= '7' && c3 >= '0' && c3 <= '7') {
                                                        try {
                                                            this.uesc.append((char)Integer.parseInt(new String(cArray, j, 3), 8));
                                                            j += 2;
                                                            break;
                                                        }
                                                        catch (NumberFormatException numberFormatException) {
                                                            throw new AssertionError((Object)"Flow error, should never try to parse non-number");
                                                        }
                                                    }
                                                    this.uesc.append(c);
                                                    break;
                                                }
                                                this.uesc.append(c);
                                                break;
                                            }
                                            default: {
                                                this.uesc.append(c);
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    this.uesc.append(c);
                                }
                                this.values[n2] = this.uesc.toString();
                            } else {
                                this.values[n2] = new String(cArray, n3, n4);
                            }
                        } else {
                            n4 = i - 1 - n3;
                            this.values[n2] = n4 == 4 && cArray[n3] == 'N' && cArray[n3 + 1] == 'U' && cArray[n3 + 2] == 'L' && cArray[n3 + 3] == 'L' ? null : new String(cArray, n3, n4);
                        }
                        n3 = i + 1;
                        bl3 = false;
                        ++n2;
                    }
                    bl2 = false;
                    continue block14;
                }
                default: {
                    bl2 = false;
                }
            }
        }
        if (n2 != this.values.length) {
            throw new MCLParseException("illegal result length: " + n2 + "\nlast read: " + (n2 > 0 ? this.values[n2 - 1] : "<none>"));
        }
        this.colnr = 0;
        return 0;
    }
}

