/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.services.dataflow.model.JobMessage;
import com.google.api.services.dataflow.model.JobMetrics;
import com.google.api.services.dataflow.model.MetricUpdate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.TestDataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.MonitoringUtil;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataflowRunner
extends PipelineRunner<DataflowPipelineJob> {
    private static final @UnknownKeyFor @NonNull @Initialized String TENTATIVE_COUNTER = "tentative";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TestDataflowRunner.class);
    private final @UnknownKeyFor @NonNull @Initialized TestDataflowPipelineOptions options;
    private final @UnknownKeyFor @NonNull @Initialized DataflowClient dataflowClient;
    private final @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
    private @UnknownKeyFor @NonNull @Initialized int expectedNumberOfAssertions = 0;

    TestDataflowRunner(@UnknownKeyFor @NonNull @Initialized TestDataflowPipelineOptions options, @UnknownKeyFor @NonNull @Initialized DataflowClient client) {
        this.options = options;
        this.dataflowClient = client;
        this.runner = DataflowRunner.fromOptions(options);
    }

    public static @UnknownKeyFor @NonNull @Initialized TestDataflowRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        TestDataflowPipelineOptions dataflowOptions = (TestDataflowPipelineOptions)options.as(TestDataflowPipelineOptions.class);
        String tempLocation = FileSystems.matchNewDirectory((String)dataflowOptions.getTempRoot(), (String[])new String[]{dataflowOptions.getJobName(), "output", "results"}).toString();
        if (tempLocation.endsWith("/")) {
            tempLocation = tempLocation.substring(0, tempLocation.length() - 1);
        } else if (tempLocation.endsWith(File.separator)) {
            tempLocation = tempLocation.substring(0, tempLocation.length() - File.separator.length());
        }
        dataflowOptions.setTempLocation(tempLocation);
        return new TestDataflowRunner(dataflowOptions, DataflowClient.create((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class)));
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized TestDataflowRunner fromOptionsAndClient(@UnknownKeyFor @NonNull @Initialized TestDataflowPipelineOptions options, @UnknownKeyFor @NonNull @Initialized DataflowClient client) {
        return new TestDataflowRunner(options, client);
    }

    public @UnknownKeyFor @NonNull @Initialized DataflowPipelineJob run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        return this.run(pipeline, this.runner);
    }

    @UnknownKeyFor @NonNull @Initialized DataflowPipelineJob run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized DataflowRunner runner) {
        Optional<Boolean> allAssertionsPassed;
        Boolean jobSuccess;
        this.updatePAssertCount(pipeline);
        TestPipelineOptions testPipelineOptions = (TestPipelineOptions)this.options.as(TestPipelineOptions.class);
        DataflowPipelineJob job = runner.run(pipeline);
        LOG.info("Running Dataflow job {} with {} expected assertions.", (Object)job.getJobId(), (Object)this.expectedNumberOfAssertions);
        MatcherAssert.assertThat((Object)job, (Matcher)testPipelineOptions.getOnCreateMatcher());
        ErrorMonitorMessagesHandler messageHandler = new ErrorMonitorMessagesHandler(job, new MonitoringUtil.LoggingHandler());
        if (this.options.isStreaming()) {
            jobSuccess = this.options.isBlockOnRun() ? Boolean.valueOf(this.waitForStreamingJobTermination(job, messageHandler)) : Boolean.valueOf(true);
            allAssertionsPassed = Optional.absent();
        } else {
            jobSuccess = this.waitForBatchJobTermination(job, messageHandler);
            allAssertionsPassed = this.checkForPAssertSuccess(job);
        }
        if (!allAssertionsPassed.isPresent()) {
            LOG.warn("Dataflow job {} did not output a success or failure metric.", (Object)job.getJobId());
        } else if (!((Boolean)allAssertionsPassed.get()).booleanValue()) {
            throw new AssertionError((Object)TestDataflowRunner.errorMessage(job, messageHandler));
        }
        if (!jobSuccess.booleanValue()) {
            throw new RuntimeException(TestDataflowRunner.errorMessage(job, messageHandler));
        }
        MatcherAssert.assertThat((Object)job, (Matcher)testPipelineOptions.getOnSuccessMatcher());
        return job;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private @UnknownKeyFor @NonNull @Initialized boolean waitForStreamingJobTermination(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob job, @UnknownKeyFor @NonNull @Initialized ErrorMonitorMessagesHandler messageHandler) {
        PipelineResult.State finalState;
        this.options.getExecutorService().submit(new CancelOnError(job, messageHandler));
        try {
            finalState = job.waitUntilFinish(Duration.standardSeconds((long)this.options.getTestTimeoutSeconds()), messageHandler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return false;
        }
        if (finalState == null || !finalState.isTerminal()) {
            LOG.info("Dataflow job {} took longer than {} seconds to complete, cancelling.", (Object)job.getJobId(), (Object)this.options.getTestTimeoutSeconds());
            try {
                job.cancel();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }
        return finalState == PipelineResult.State.DONE && !messageHandler.hasSeenError();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean waitForBatchJobTermination(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob job, @UnknownKeyFor @NonNull @Initialized ErrorMonitorMessagesHandler messageHandler) {
        try {
            job.waitUntilFinish(Duration.standardSeconds((long)-1L), messageHandler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return false;
        }
        return job.getState() == PipelineResult.State.DONE;
    }

    private static @UnknownKeyFor @NonNull @Initialized String errorMessage(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob job, @UnknownKeyFor @NonNull @Initialized ErrorMonitorMessagesHandler messageHandler) {
        if (!Strings.isNullOrEmpty((String)messageHandler.getErrorMessage())) {
            return messageHandler.getErrorMessage();
        }
        PipelineResult.State state = job.getState();
        return String.format("Dataflow job %s terminated in state %s but did not return a failure reason.", job.getJobId(), state == PipelineResult.State.UNRECOGNIZED ? String.format("UNRECOGNIZED (%s)", job.getLatestStateString()) : state.toString());
    }

    @VisibleForTesting
    void updatePAssertCount(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        this.expectedNumberOfAssertions = PAssert.countAsserts((Pipeline)pipeline);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> checkForPAssertSuccess(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob job) {
        JobMetrics metrics = this.getJobMetrics(job);
        if (metrics == null || metrics.getMetrics() == null) {
            LOG.warn("Metrics not present for Dataflow job {}.", (Object)job.getJobId());
            return Optional.absent();
        }
        int successes = 0;
        int failures = 0;
        for (MetricUpdate metric : metrics.getMetrics()) {
            if (metric.getName() == null || metric.getName().getContext() == null || !metric.getName().getContext().containsKey(TENTATIVE_COUNTER)) continue;
            if ("PAssertSuccess".equals(metric.getName().getName())) {
                successes += ((BigDecimal)metric.getScalar()).intValue();
                continue;
            }
            if (!"PAssertFailure".equals(metric.getName().getName())) continue;
            failures += ((BigDecimal)metric.getScalar()).intValue();
        }
        if (failures > 0) {
            LOG.info("Failure result for Dataflow job {}. Found {} success, {} failures out of {} expected assertions.", new Object[]{job.getJobId(), successes, failures, this.expectedNumberOfAssertions});
            return Optional.of((Object)false);
        }
        if (successes >= this.expectedNumberOfAssertions) {
            LOG.info("Success result for Dataflow job {}. Found {} success, {} failures out of {} expected assertions.", new Object[]{job.getJobId(), successes, failures, this.expectedNumberOfAssertions});
            return Optional.of((Object)true);
        }
        PipelineResult.State state = job.getState();
        if (state == PipelineResult.State.FAILED || state == PipelineResult.State.CANCELLED) {
            LOG.info("Dataflow job {} terminated in failure state {} without reporting a failed assertion", (Object)job.getJobId(), (Object)state);
            return Optional.absent();
        }
        LOG.info("Inconclusive results for Dataflow job {}. Found {} success, {} failures out of {} expected assertions.", new Object[]{job.getJobId(), successes, failures, this.expectedNumberOfAssertions});
        return Optional.absent();
    }

    @VisibleForTesting
    @Nullable @UnknownKeyFor @Initialized JobMetrics getJobMetrics(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob job) {
        JobMetrics metrics = null;
        try {
            metrics = this.dataflowClient.getJobMetrics(job.getJobId());
        }
        catch (IOException e) {
            LOG.warn("Failed to get job metrics: ", (Throwable)e);
        }
        return metrics;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "TestDataflowRunner#" + this.options.getAppName();
    }

    private static class CancelOnError
    implements Callable<Void> {
        private final @UnknownKeyFor @NonNull @Initialized DataflowPipelineJob job;
        private final @UnknownKeyFor @NonNull @Initialized ErrorMonitorMessagesHandler messageHandler;

        public CancelOnError(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob job, @UnknownKeyFor @NonNull @Initialized ErrorMonitorMessagesHandler messageHandler) {
            this.job = job;
            this.messageHandler = messageHandler;
        }

        @Override
        public @UnknownKeyFor @Nullable @Initialized Void call() throws @UnknownKeyFor @NonNull @Initialized Exception {
            while (true) {
                PipelineResult.State jobState = this.job.getState();
                if (this.messageHandler.hasSeenError() && !this.job.getState().isTerminal()) {
                    this.job.cancel();
                    LOG.info("Cancelling Dataflow job {}", (Object)this.job.getJobId());
                    return null;
                }
                if (jobState.isTerminal()) {
                    return null;
                }
                Thread.sleep(3000L);
            }
        }
    }

    private static class ErrorMonitorMessagesHandler
    implements MonitoringUtil.JobMessagesHandler {
        private final @UnknownKeyFor @NonNull @Initialized DataflowPipelineJob job;
        private final  @UnknownKeyFor @NonNull @Initialized MonitoringUtil.JobMessagesHandler messageHandler;
        private final @UnknownKeyFor @NonNull @Initialized StringBuilder errorMessage;
        private volatile @UnknownKeyFor @NonNull @Initialized boolean hasSeenError;

        private ErrorMonitorMessagesHandler(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob job,  @UnknownKeyFor @NonNull @Initialized MonitoringUtil.JobMessagesHandler messageHandler) {
            this.job = job;
            this.messageHandler = messageHandler;
            this.errorMessage = new StringBuilder();
            this.hasSeenError = false;
        }

        @Override
        public void process(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized JobMessage> messages) {
            this.messageHandler.process(messages);
            for (JobMessage message : messages) {
                if (!"JOB_MESSAGE_ERROR".equals(message.getMessageImportance())) continue;
                LOG.info("Dataflow job {} threw exception. Failure message was: {}", (Object)this.job.getJobId(), (Object)message.getMessageText());
                this.errorMessage.append(message.getMessageText());
                this.hasSeenError = true;
            }
        }

        @UnknownKeyFor @NonNull @Initialized boolean hasSeenError() {
            return this.hasSeenError;
        }

        @UnknownKeyFor @NonNull @Initialized String getErrorMessage() {
            return this.errorMessage.toString();
        }
    }
}

