/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.core.InternalExtensionOnly;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalExtensionOnly
public class BigtableTableName {
    private static final Pattern PATTERN = Pattern.compile("projects/([^/]+)/instances/([^/]+)/tables/([^/]+)");
    private final String tableName;
    private final String instanceId;
    private final String tableId;
    private final String projectId;

    public BigtableTableName(String tableName) {
        this.tableName = tableName;
        Matcher matcher = PATTERN.matcher(tableName);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Malformed table name");
        this.projectId = matcher.group(1);
        this.instanceId = matcher.group(2);
        this.tableId = matcher.group(3);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String toString() {
        return this.tableName;
    }
}

