/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dimensionlookup;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookupMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DimensionLookupDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = DimensionLookupMeta.class;
    private CTabFolder wTabFolder;
    private CTabItem wFieldsTab;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private TextVar wTable;
    private Label wlCommit;
    private Text wCommit;
    private Button wUseCache;
    private Label wlPreloadCache;
    private Button wPreloadCache;
    private Label wlCacheSize;
    private Text wCacheSize;
    private Combo wTk;
    private Label wlTkRename;
    private Text wTkRename;
    private Button wAutoIncrement;
    private Button wTableMax;
    private Button wSeqButton;
    private Text wSeq;
    private Label wlVersion;
    private Combo wVersion;
    private Combo wDateField;
    private Combo wFromDate;
    private Button wUseAltStartDate;
    private Combo wAltStartDate;
    private Combo wAltStartDateField;
    private Label wlMinYear;
    private Text wMinYear;
    private Combo wToDate;
    private Label wlMaxYear;
    private Text wMaxYear;
    private Button wUpdate;
    private TableView wKey;
    private TableView wUpIns;
    private final DimensionLookupMeta input;
    private DatabaseMeta databaseMeta;
    private ColumnInfo[] fieldColumns;
    private ColumnInfo[] keyColumns;
    private final List<String> inputFields = new ArrayList<String>();
    private boolean gotPreviousFields = false;
    private boolean gotTableFields = false;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public DimensionLookupDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (DimensionLookupMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        this.shell.setLayout(this.props.createFormLayout());
        this.shell.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Shell mainComposite = this.shell;
        PropsUi.setLook((Widget)mainComposite);
        mainComposite.setLayout(this.props.createFormLayout());
        this.wlTransformName = new Label((Composite)mainComposite, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)mainComposite, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlUpdate = new Label((Composite)mainComposite, 131072);
        wlUpdate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Update.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUpdate);
        FormData fdlUpdate = new FormData();
        fdlUpdate.left = new FormAttachment(0, 0);
        fdlUpdate.right = new FormAttachment(middle, -margin);
        fdlUpdate.top = new FormAttachment((Control)this.wTransformName, margin);
        wlUpdate.setLayoutData((Object)fdlUpdate);
        this.wUpdate = new Button((Composite)mainComposite, 32);
        PropsUi.setLook((Widget)this.wUpdate);
        FormData fdUpdate = new FormData();
        fdUpdate.left = new FormAttachment(middle, 0);
        fdUpdate.top = new FormAttachment((Control)wlUpdate, 0, 0x1000000);
        fdUpdate.right = new FormAttachment(100, 0);
        this.wUpdate.setLayoutData((Object)fdUpdate);
        this.wUpdate.addListener(13, e -> {
            this.input.setUpdate(!this.input.isUpdate());
            this.setFlags();
        });
        this.wConnection = this.addConnectionLine((Composite)mainComposite, (Control)this.wUpdate, this.input.getConnection(), lsMod);
        this.wConnection.addListener(16, e -> this.setTableFieldCombo());
        this.wConnection.addListener(24, e -> {
            this.databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
            this.setFlags();
        });
        Label wlSchema = new Label((Composite)mainComposite, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button((Composite)mainComposite, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        wbSchema.addListener(13, e -> this.getSchemaNames());
        this.wSchema = new TextVar(this.variables, (Composite)mainComposite, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        this.wSchema.addModifyListener(lsTableMod);
        Label wlTable = new Label((Composite)mainComposite, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)mainComposite, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        wbTable.addListener(13, e -> this.getTableName());
        this.wTable = new TextVar(this.variables, (Composite)mainComposite, 18436);
        PropsUi.setLook((Widget)this.wTable);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        this.wTable.addModifyListener(lsTableMod);
        this.wlCommit = new Label((Composite)mainComposite, 131072);
        this.wlCommit.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Commit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.right = new FormAttachment(middle, -margin);
        fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        this.wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new Text((Composite)mainComposite, 18436);
        PropsUi.setLook((Widget)this.wCommit);
        FormData fdCommit = new FormData();
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData((Object)fdCommit);
        Label wlUseCache = new Label((Composite)mainComposite, 131072);
        wlUseCache.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UseCache.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseCache);
        FormData fdlUseCache = new FormData();
        fdlUseCache.left = new FormAttachment(0, 0);
        fdlUseCache.right = new FormAttachment(middle, -margin);
        fdlUseCache.top = new FormAttachment((Control)this.wCommit, margin);
        wlUseCache.setLayoutData((Object)fdlUseCache);
        this.wUseCache = new Button((Composite)mainComposite, 32);
        PropsUi.setLook((Widget)this.wUseCache);
        this.wUseCache.addListener(13, e -> this.setFlags());
        FormData fdUseCache = new FormData();
        fdUseCache.left = new FormAttachment(middle, 0);
        fdUseCache.top = new FormAttachment((Control)wlUseCache, 0, 0x1000000);
        fdUseCache.right = new FormAttachment(100, 0);
        this.wUseCache.setLayoutData((Object)fdUseCache);
        this.wlPreloadCache = new Label((Composite)mainComposite, 131072);
        this.wlPreloadCache.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.PreloadCache.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPreloadCache);
        FormData fdlPreloadCache = new FormData();
        fdlPreloadCache.left = new FormAttachment(0, 0);
        fdlPreloadCache.right = new FormAttachment(middle, -margin);
        fdlPreloadCache.top = new FormAttachment((Control)this.wUseCache, margin);
        this.wlPreloadCache.setLayoutData((Object)fdlPreloadCache);
        this.wPreloadCache = new Button((Composite)mainComposite, 32);
        PropsUi.setLook((Widget)this.wPreloadCache);
        this.wPreloadCache.addListener(13, e -> this.setFlags());
        FormData fdPreloadCache = new FormData();
        fdPreloadCache.left = new FormAttachment(middle, 0);
        fdPreloadCache.top = new FormAttachment((Control)this.wlPreloadCache, 0, 0x1000000);
        fdPreloadCache.right = new FormAttachment(100, 0);
        this.wPreloadCache.setLayoutData((Object)fdPreloadCache);
        this.wlCacheSize = new Label((Composite)mainComposite, 131072);
        this.wlCacheSize.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.CacheSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCacheSize);
        FormData fdlCacheSize = new FormData();
        fdlCacheSize.left = new FormAttachment(0, 0);
        fdlCacheSize.right = new FormAttachment(middle, -margin);
        fdlCacheSize.top = new FormAttachment((Control)this.wPreloadCache, margin);
        this.wlCacheSize.setLayoutData((Object)fdlCacheSize);
        this.wCacheSize = new Text((Composite)mainComposite, 18436);
        PropsUi.setLook((Widget)this.wCacheSize);
        FormData fdCacheSize = new FormData();
        fdCacheSize.left = new FormAttachment(middle, 0);
        fdCacheSize.top = new FormAttachment((Control)this.wPreloadCache, margin);
        fdCacheSize.right = new FormAttachment(100, 0);
        this.wCacheSize.setLayoutData((Object)fdCacheSize);
        this.wOk = new Button((Composite)mainComposite, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        Button wGet = new Button((Composite)mainComposite, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.GetFields.Button", (String[])new String[0]));
        wGet.addListener(13, e -> this.get());
        this.wCreate = new Button((Composite)mainComposite, 8);
        this.wCreate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.SQL.Button", (String[])new String[0]));
        this.wCreate.addListener(13, e -> this.create());
        this.wCancel = new Button((Composite)mainComposite, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, wGet, this.wCreate, this.wCancel}, margin, null);
        this.wTabFolder = new CTabFolder((Composite)mainComposite, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        this.addKeyTab(margin);
        this.addFieldsTab(margin);
        this.addTechnicalKeyTab(margin, middle);
        this.addVersioningTab(margin, middle);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wCacheSize, margin);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        FormData fdComp = new FormData();
        fdComp.left = new FormAttachment(0, 0);
        fdComp.top = new FormAttachment(0, 0);
        fdComp.right = new FormAttachment(100, 0);
        fdComp.bottom = new FormAttachment(100, 0);
        mainComposite.setLayoutData((Object)fdComp);
        mainComposite.pack();
        this.setTableMax();
        this.setSequence();
        this.setAutoIncrementUse();
        this.wTabFolder.setSelection(0);
        this.getData();
        this.setTableFieldCombo();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void addKeyTab(int margin) {
        CTabItem wKeyTab = new CTabItem(this.wTabFolder, 0);
        wKeyTab.setFont(GuiResource.getInstance().getFontDefault());
        wKeyTab.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.KeyTab.CTabItem", (String[])new String[0]));
        Composite wKeyComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wKeyComp);
        wKeyComp.setLayout(this.props.createFormLayout());
        Label wlKey = new Label(wKeyComp, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.KeyFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment(0, margin);
        fdlKey.right = new FormAttachment(100, 0);
        wlKey.setLayoutData((Object)fdlKey);
        int nrKeyRows = this.input.getFields().getKeys().size();
        this.keyColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.DimensionField", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.FieldInStream", (String[])new String[0]), 2, new String[]{""}, false)};
        this.wKey = new TableView(this.variables, wKeyComp, 68354, this.keyColumns, nrKeyRows, null, this.props);
        this.tableFieldColumns.add(this.keyColumns[0]);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment(100, 0);
        fdKey.bottom = new FormAttachment(100, 0);
        this.wKey.setLayoutData((Object)fdKey);
        FormData fdKeyComp = new FormData();
        fdKeyComp.left = new FormAttachment(0, 0);
        fdKeyComp.top = new FormAttachment(0, 0);
        fdKeyComp.right = new FormAttachment(100, 0);
        fdKeyComp.bottom = new FormAttachment(100, 0);
        wKeyComp.setLayoutData((Object)fdKeyComp);
        wKeyComp.layout();
        wKeyTab.setControl((Control)wKeyComp);
    }

    public void addTechnicalKeyTab(int margin, int middle) {
        CTabItem wTechnicalKeyTab = new CTabItem(this.wTabFolder, 0);
        wTechnicalKeyTab.setFont(GuiResource.getInstance().getFontDefault());
        wTechnicalKeyTab.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TechnicalKeyTab.CTabItem", (String[])new String[0]));
        Composite wTechnicalKeyComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wTechnicalKeyComp);
        wTechnicalKeyComp.setLayout(this.props.createFormLayout());
        Label wlTk = new Label(wTechnicalKeyComp, 131072);
        wlTk.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TechnicalKeyField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTk);
        FormData fdlTk = new FormData();
        fdlTk.left = new FormAttachment(0, margin);
        fdlTk.top = new FormAttachment(0, 3 * margin);
        wlTk.setLayoutData((Object)fdlTk);
        this.wTk = new Combo(wTechnicalKeyComp, 18436);
        PropsUi.setLook((Widget)this.wTk);
        FormData fdTk = new FormData();
        fdTk.left = new FormAttachment((Control)wlTk, margin);
        fdTk.top = new FormAttachment((Control)wlTk, 0, 0x1000000);
        fdTk.right = new FormAttachment(30 + middle / 2, 0);
        this.wTk.setLayoutData((Object)fdTk);
        this.wTk.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            this.getFieldsFromTable();
            this.shell.setCursor(null);
            busy.dispose();
        });
        this.wlTkRename = new Label(wTechnicalKeyComp, 131072);
        this.wlTkRename.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.NewName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTkRename);
        FormData fdlTkRename = new FormData();
        fdlTkRename.left = new FormAttachment((Control)this.wTk, margin);
        fdlTkRename.top = new FormAttachment((Control)wlTk, 0, 0x1000000);
        this.wlTkRename.setLayoutData((Object)fdlTkRename);
        this.wTkRename = new Text(wTechnicalKeyComp, 18436);
        PropsUi.setLook((Widget)this.wTkRename);
        FormData fdTkRename = new FormData();
        fdTkRename.left = new FormAttachment((Control)this.wlTkRename, margin);
        fdTkRename.top = new FormAttachment((Control)wlTk, 0, 0x1000000);
        fdTkRename.right = new FormAttachment(100, -margin);
        this.wTkRename.setLayoutData((Object)fdTkRename);
        Group gTechGroup = new Group(wTechnicalKeyComp, 16);
        gTechGroup.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TechGroup.Label", (String[])new String[0]));
        gTechGroup.setLayout(this.props.createFormLayout());
        PropsUi.setLook((Widget)gTechGroup);
        FormData fdTechGroup = new FormData();
        fdTechGroup.top = new FormAttachment((Control)this.wTkRename, margin);
        fdTechGroup.left = new FormAttachment(0, margin);
        fdTechGroup.right = new FormAttachment(100, -margin);
        gTechGroup.setBackground(this.shell.getBackground());
        gTechGroup.setLayoutData((Object)fdTechGroup);
        this.wTableMax = new Button((Composite)gTechGroup, 16);
        PropsUi.setLook((Widget)this.wTableMax);
        this.wTableMax.setSelection(false);
        FormData fdTableMax = new FormData();
        fdTableMax.left = new FormAttachment(0, 0);
        fdTableMax.top = new FormAttachment((Control)this.wTkRename, margin);
        this.wTableMax.setLayoutData((Object)fdTableMax);
        this.wTableMax.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TableMaximum.Label", (String[])new String[0]));
        this.wTableMax.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TableMaximum.Tooltip", (String[])new String[]{Const.CR}));
        this.wSeqButton = new Button((Composite)gTechGroup, 16);
        PropsUi.setLook((Widget)this.wSeqButton);
        this.wSeqButton.setSelection(false);
        FormData fdSeqButton = new FormData();
        fdSeqButton.left = new FormAttachment(0, 0);
        fdSeqButton.top = new FormAttachment((Control)this.wTableMax, margin);
        this.wSeqButton.setLayoutData((Object)fdSeqButton);
        this.wSeqButton.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Sequence.Tooltip", (String[])new String[]{Const.CR}));
        this.wSeqButton.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Sequence.Label", (String[])new String[0]));
        this.wSeq = new Text((Composite)gTechGroup, 18436);
        PropsUi.setLook((Widget)this.wSeq);
        FormData fdSeq = new FormData();
        fdSeq.left = new FormAttachment((Control)this.wSeqButton, margin);
        fdSeq.top = new FormAttachment((Control)this.wSeqButton, 0, 0x1000000);
        fdSeq.right = new FormAttachment(100, 0);
        this.wSeq.setLayoutData((Object)fdSeq);
        this.wSeq.addListener(15, e -> {
            this.input.getFields().getReturns().setCreationMethod(DimensionLookupMeta.TechnicalKeyCreationMethod.SEQUENCE);
            this.wSeqButton.setSelection(true);
            this.wAutoIncrement.setSelection(false);
            this.wTableMax.setSelection(false);
        });
        this.wAutoIncrement = new Button((Composite)gTechGroup, 16);
        PropsUi.setLook((Widget)this.wAutoIncrement);
        this.wAutoIncrement.setSelection(false);
        FormData fdAutoIncrement = new FormData();
        fdAutoIncrement.left = new FormAttachment(0, 0);
        fdAutoIncrement.top = new FormAttachment((Control)this.wSeq, margin);
        this.wAutoIncrement.setLayoutData((Object)fdAutoIncrement);
        this.wAutoIncrement.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AutoIncrementButton.Tooltip", (String[])new String[]{Const.CR}));
        this.wAutoIncrement.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AutoIncrement.Label", (String[])new String[0]));
        FormData fdTechnicalKeyComp = new FormData();
        fdTechnicalKeyComp.left = new FormAttachment(0, 0);
        fdTechnicalKeyComp.top = new FormAttachment(0, 0);
        fdTechnicalKeyComp.right = new FormAttachment(100, 0);
        fdTechnicalKeyComp.bottom = new FormAttachment(100, 0);
        wTechnicalKeyComp.setLayoutData((Object)fdTechnicalKeyComp);
        wTechnicalKeyComp.layout();
        wTechnicalKeyTab.setControl((Control)wTechnicalKeyComp);
    }

    public void addFieldsTab(int margin) {
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FieldsTab.CTabItem.Title", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        wFieldsComp.setLayout(this.props.createFormLayout());
        Label wlUpIns = new Label(wFieldsComp, 0);
        wlUpIns.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUpIns);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(0, margin);
        wlUpIns.setLayoutData((Object)fdlUpIns);
        int upInsCols = 3;
        int upInsRows = this.input.getFields().getFields().size();
        this.fieldColumns = new ColumnInfo[upInsCols];
        this.fieldColumns[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.DimensionField", (String[])new String[0]), 2, new String[]{""}, false);
        this.fieldColumns[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.fieldColumns[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.TypeOfDimensionUpdate", (String[])new String[0]), 2, this.input.isUpdate() ? DimensionLookupMeta.DimensionUpdateType.getDescriptions() : ValueMetaFactory.getValueMetaNames());
        this.tableFieldColumns.add(this.fieldColumns[0]);
        this.wUpIns = new TableView(this.variables, wFieldsComp, 68354, this.fieldColumns, upInsRows, null, this.props);
        FormData fdUpIns = new FormData();
        fdUpIns.left = new FormAttachment(0, 0);
        fdUpIns.top = new FormAttachment((Control)wlUpIns, margin);
        fdUpIns.right = new FormAttachment(100, 0);
        fdUpIns.bottom = new FormAttachment(100, 0);
        this.wUpIns.setLayoutData((Object)fdUpIns);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
    }

    public void addVersioningTab(int margin, int middle) {
        CTabItem wVersioningTab = new CTabItem(this.wTabFolder, 0);
        wVersioningTab.setFont(GuiResource.getInstance().getFontDefault());
        wVersioningTab.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.VersioningTab.CTabItem", (String[])new String[0]));
        Composite wVersioningComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wVersioningComp);
        wVersioningComp.setLayout(this.props.createFormLayout());
        this.wlVersion = new Label(wVersioningComp, 131072);
        this.wlVersion.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Version.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlVersion);
        FormData fdlVersion = new FormData();
        fdlVersion.left = new FormAttachment(0, 0);
        fdlVersion.right = new FormAttachment(middle, 0);
        fdlVersion.top = new FormAttachment(0, 2 * margin);
        this.wlVersion.setLayoutData((Object)fdlVersion);
        this.wVersion = new Combo(wVersioningComp, 18436);
        PropsUi.setLook((Widget)this.wVersion);
        FormData fdVersion = new FormData();
        fdVersion.left = new FormAttachment(middle, 0);
        fdVersion.top = new FormAttachment((Control)this.wlVersion, 0, 0x1000000);
        fdVersion.right = new FormAttachment(100, 0);
        this.wVersion.setLayoutData((Object)fdVersion);
        this.wVersion.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            this.getFieldsFromTable();
            this.shell.setCursor(null);
            busy.dispose();
        });
        Combo lastControl = this.wVersion;
        Label wlDateField = new Label(wVersioningComp, 131072);
        wlDateField.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.DateField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDateField);
        FormData fdlDateField = new FormData();
        fdlDateField.left = new FormAttachment(0, 0);
        fdlDateField.right = new FormAttachment(middle, 0);
        fdlDateField.top = new FormAttachment((Control)lastControl, margin);
        wlDateField.setLayoutData((Object)fdlDateField);
        this.wDateField = new Combo(wVersioningComp, 18436);
        PropsUi.setLook((Widget)this.wDateField);
        FormData fdDateField = new FormData();
        fdDateField.left = new FormAttachment(middle, 0);
        fdDateField.top = new FormAttachment((Control)wlDateField, 0, 0x1000000);
        fdDateField.right = new FormAttachment(100, 0);
        this.wDateField.setLayoutData((Object)fdDateField);
        this.wDateField.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            this.getFields();
            this.shell.setCursor(null);
            busy.dispose();
        });
        lastControl = this.wDateField;
        Label wlFromDate = new Label(wVersioningComp, 131072);
        wlFromDate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FromDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFromDate);
        FormData fdlFromDate = new FormData();
        fdlFromDate.left = new FormAttachment(0, 0);
        fdlFromDate.right = new FormAttachment(middle, 0);
        fdlFromDate.top = new FormAttachment((Control)lastControl, margin);
        wlFromDate.setLayoutData((Object)fdlFromDate);
        this.wFromDate = new Combo(wVersioningComp, 18436);
        PropsUi.setLook((Widget)this.wFromDate);
        FormData fdFromDate = new FormData();
        fdFromDate.left = new FormAttachment(middle, 0);
        fdFromDate.right = new FormAttachment(middle + (100 - middle) / 3, -margin);
        fdFromDate.top = new FormAttachment((Control)wlFromDate, 0, 0x1000000);
        this.wFromDate.setLayoutData((Object)fdFromDate);
        this.wFromDate.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            this.getFieldsFromTable();
            this.shell.setCursor(null);
            busy.dispose();
        });
        this.wlMinYear = new Label(wVersioningComp, 131072);
        this.wlMinYear.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.MinYear.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMinYear);
        FormData fdlMinYear = new FormData();
        fdlMinYear.left = new FormAttachment((Control)this.wFromDate, margin);
        fdlMinYear.right = new FormAttachment(middle + 2 * (100 - middle) / 3, -margin);
        fdlMinYear.top = new FormAttachment((Control)lastControl, margin);
        this.wlMinYear.setLayoutData((Object)fdlMinYear);
        this.wMinYear = new Text(wVersioningComp, 18436);
        PropsUi.setLook((Widget)this.wMinYear);
        FormData fdMinYear = new FormData();
        fdMinYear.left = new FormAttachment((Control)this.wlMinYear, margin);
        fdMinYear.right = new FormAttachment(100, 0);
        fdMinYear.top = new FormAttachment((Control)this.wlMinYear, 0, 0x1000000);
        this.wMinYear.setLayoutData((Object)fdMinYear);
        this.wMinYear.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.MinYear.ToolTip", (String[])new String[0]));
        lastControl = this.wFromDate;
        Label wlUseAltStartDate = new Label(wVersioningComp, 131072);
        wlUseAltStartDate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UseAlternativeStartDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseAltStartDate);
        FormData fdlUseAltStartDate = new FormData();
        fdlUseAltStartDate.left = new FormAttachment(0, 0);
        fdlUseAltStartDate.right = new FormAttachment(middle, -margin);
        fdlUseAltStartDate.top = new FormAttachment((Control)lastControl, margin);
        wlUseAltStartDate.setLayoutData((Object)fdlUseAltStartDate);
        this.wUseAltStartDate = new Button(wVersioningComp, 32);
        this.wUseAltStartDate.setText(" ");
        PropsUi.setLook((Widget)this.wUseAltStartDate);
        this.wUseAltStartDate.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UseAlternativeStartDate.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdUseAltStartDate = new FormData();
        fdUseAltStartDate.left = new FormAttachment(middle, 0);
        fdUseAltStartDate.top = new FormAttachment((Control)wlUseAltStartDate, 0, 0x1000000);
        this.wUseAltStartDate.setLayoutData((Object)fdUseAltStartDate);
        this.wUseAltStartDate.addListener(13, e -> this.setFlags());
        this.wAltStartDate = new Combo(wVersioningComp, 2048);
        PropsUi.setLook((Widget)this.wAltStartDate);
        this.wAltStartDate.setItems(DimensionLookupMeta.StartDateAlternative.getDescriptions());
        this.wAltStartDate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AlternativeStartDate.SelectItemDefault", (String[])new String[0]));
        this.wAltStartDate.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AlternativeStartDate.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdAltStartDate = new FormData();
        fdAltStartDate.left = new FormAttachment((Control)this.wUseAltStartDate, margin);
        fdAltStartDate.right = new FormAttachment((Control)this.wUseAltStartDate, (int)(200.0 * this.props.getZoomFactor()));
        fdAltStartDate.top = new FormAttachment((Control)wlUseAltStartDate, 0, 0x1000000);
        this.wAltStartDate.setLayoutData((Object)fdAltStartDate);
        this.wAltStartDate.addModifyListener(e -> this.setFlags());
        this.wAltStartDateField = new Combo(wVersioningComp, 2052);
        PropsUi.setLook((Widget)this.wAltStartDateField);
        this.wAltStartDateField.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AlternativeStartDateField.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdAltStartDateField = new FormData();
        fdAltStartDateField.left = new FormAttachment((Control)this.wAltStartDate, 2 * margin);
        fdAltStartDateField.right = new FormAttachment(100, 0);
        fdAltStartDateField.top = new FormAttachment((Control)wlUseAltStartDate, 0, 0x1000000);
        this.wAltStartDateField.setLayoutData((Object)fdAltStartDateField);
        this.wAltStartDateField.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            this.getFieldsFromTable();
            this.shell.setCursor(null);
            busy.dispose();
        });
        lastControl = this.wAltStartDate;
        Label wlToDate = new Label(wVersioningComp, 131072);
        wlToDate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ToDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlToDate);
        FormData fdlToDate = new FormData();
        fdlToDate.left = new FormAttachment(0, 0);
        fdlToDate.right = new FormAttachment(middle, 0);
        fdlToDate.top = new FormAttachment((Control)lastControl, margin);
        wlToDate.setLayoutData((Object)fdlToDate);
        this.wToDate = new Combo(wVersioningComp, 18436);
        PropsUi.setLook((Widget)this.wToDate);
        FormData fdToDate = new FormData();
        fdToDate.left = new FormAttachment(middle, 0);
        fdToDate.right = new FormAttachment(middle + (100 - middle) / 3, -margin);
        fdToDate.top = new FormAttachment((Control)wlToDate, 0, 0x1000000);
        this.wToDate.setLayoutData((Object)fdToDate);
        this.wToDate.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            this.getFieldsFromTable();
            this.shell.setCursor(null);
            busy.dispose();
        });
        this.wlMaxYear = new Label(wVersioningComp, 131072);
        this.wlMaxYear.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.MaxYear.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMaxYear);
        FormData fdlMaxYear = new FormData();
        fdlMaxYear.left = new FormAttachment((Control)this.wToDate, margin);
        fdlMaxYear.right = new FormAttachment(middle + 2 * (100 - middle) / 3, -margin);
        fdlMaxYear.top = new FormAttachment((Control)this.wToDate, 0, 0x1000000);
        this.wlMaxYear.setLayoutData((Object)fdlMaxYear);
        this.wMaxYear = new Text(wVersioningComp, 18436);
        PropsUi.setLook((Widget)this.wMaxYear);
        FormData fdMaxYear = new FormData();
        fdMaxYear.left = new FormAttachment((Control)this.wlMaxYear, margin);
        fdMaxYear.right = new FormAttachment(100, 0);
        fdMaxYear.top = new FormAttachment((Control)this.wlMaxYear, 0, 0x1000000);
        this.wMaxYear.setLayoutData((Object)fdMaxYear);
        this.wMaxYear.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.MaxYear.ToolTip", (String[])new String[0]));
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wVersioningComp.setLayoutData((Object)fdFieldsComp);
        wVersioningComp.layout();
        wVersioningTab.setControl((Control)wVersioningComp);
    }

    public void setFlags() {
        ColumnInfo colinf = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.Type", (String[])new String[0]), 2, this.input.isUpdate() ? DimensionLookupMeta.DimensionUpdateType.getDescriptions() : ValueMetaFactory.getValueMetaNames());
        this.wUpIns.setColumnInfo(2, colinf);
        if (this.input.isUpdate()) {
            this.wUpIns.setColumnText(2, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnText.SteamFieldToCompare", (String[])new String[0]));
            this.wUpIns.setColumnText(3, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnTextTypeOfDimensionUpdate", (String[])new String[0]));
            this.wUpIns.setColumnToolTip(2, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnToolTip", (String[])new String[0]) + Const.CR + "Punch Through: Kimball Type I" + Const.CR + "Update: Correct error in last version");
        } else {
            this.wUpIns.setColumnText(2, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnText.NewNameOfOutputField", (String[])new String[0]));
            this.wUpIns.setColumnText(3, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnText.TypeOfReturnField", (String[])new String[0]));
            this.wUpIns.setColumnToolTip(2, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnToolTip2", (String[])new String[0]));
        }
        this.wUpIns.optWidth(true);
        boolean update = this.wUpdate.getSelection();
        this.wlCommit.setEnabled(update);
        this.wCommit.setEnabled(update);
        this.wlMinYear.setEnabled(update);
        this.wMinYear.setEnabled(update);
        this.wlMaxYear.setEnabled(update);
        this.wMaxYear.setEnabled(update);
        this.wlMinYear.setEnabled(update);
        this.wMinYear.setEnabled(update);
        this.wlVersion.setEnabled(update);
        this.wVersion.setEnabled(update);
        this.wlTkRename.setEnabled(!update);
        this.wTkRename.setEnabled(!update);
        this.wCreate.setEnabled(update);
        this.setAutoIncrementUse();
        this.setSequence();
        this.setTableMax();
        if (update) {
            this.setAutoIncrementUse();
            this.setSequence();
            this.setTableMax();
        }
        this.wAltStartDate.setEnabled(this.wUseAltStartDate.getSelection());
        DimensionLookupMeta.StartDateAlternative alternative = DimensionLookupMeta.StartDateAlternative.lookupWithDescription(this.wAltStartDate.getText());
        this.wAltStartDateField.setEnabled(alternative == DimensionLookupMeta.StartDateAlternative.COLUMN_VALUE);
        this.wlPreloadCache.setEnabled(this.wUseCache.getSelection() && !this.wUpdate.getSelection());
        this.wPreloadCache.setEnabled(this.wUseCache.getSelection() && !this.wUpdate.getSelection());
        this.wlCacheSize.setEnabled(this.wUseCache.getSelection() && !this.wPreloadCache.getSelection());
        this.wCacheSize.setEnabled(this.wUseCache.getSelection() && !this.wPreloadCache.getSelection());
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.keyColumns[1].setComboValues(fieldNames);
        this.fieldColumns[1].setComboValues(fieldNames);
    }

    public void setAutoIncrementUse() {
        boolean enable = this.databaseMeta == null || this.databaseMeta.supportsAutoinc() && this.databaseMeta.supportsAutoGeneratedKeys();
        this.wAutoIncrement.setEnabled(enable);
        if (!enable && this.wAutoIncrement.getSelection()) {
            this.wAutoIncrement.setSelection(false);
            this.wSeqButton.setSelection(false);
            this.wTableMax.setSelection(true);
        }
    }

    public void setTableMax() {
        this.wTableMax.setEnabled(true);
    }

    public void setSequence() {
        boolean seq = this.databaseMeta == null || this.databaseMeta.supportsSequences();
        this.wSeq.setEnabled(seq);
        this.wSeqButton.setEnabled(seq);
        if (!seq && this.wSeqButton.getSelection()) {
            this.wAutoIncrement.setSelection(false);
            this.wSeqButton.setSelection(false);
            this.wTableMax.setSelection(true);
        }
    }

    public void getData() {
        TableItem item;
        int i;
        DimensionLookupMeta.DLFields f = this.input.getFields();
        for (i = 0; i < this.input.getFields().getKeys().size(); ++i) {
            DimensionLookupMeta.DLKey key = this.input.getFields().getKeys().get(i);
            item = this.wKey.table.getItem(i);
            item.setText(1, Const.NVL((String)key.getLookup(), (String)""));
            item.setText(2, Const.NVL((String)key.getName(), (String)""));
        }
        for (i = 0; i < this.input.getFields().getFields().size(); ++i) {
            DimensionLookupMeta.DLField field = this.input.getFields().getFields().get(i);
            item = this.wUpIns.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getLookup(), (String)""));
            item.setText(2, Const.NVL((String)field.getName(), (String)""));
            if (this.input.isUpdate()) {
                DimensionLookupMeta.DimensionUpdateType updateType = field.getUpdateType();
                item.setText(3, updateType == null ? "" : updateType.getDescription());
                continue;
            }
            item.setText(3, Const.NVL((String)field.getReturnType(), (String)""));
        }
        this.wUpdate.setSelection(this.input.isUpdate());
        this.wSchema.setText(Const.NVL((String)this.input.getSchemaName(), (String)""));
        this.wTable.setText(Const.NVL((String)this.input.getTableName(), (String)""));
        this.wTk.setText(Const.NVL((String)f.getReturns().getKeyField(), (String)""));
        this.wTkRename.setText(Const.NVL((String)f.getReturns().getKeyRename(), (String)""));
        this.wVersion.setText(Const.NVL((String)f.getReturns().getVersionField(), (String)""));
        this.wSeq.setText(Const.NVL((String)this.input.getSequenceName(), (String)""));
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wDateField.setText(Const.NVL((String)f.getDate().getName(), (String)""));
        this.wFromDate.setText(Const.NVL((String)f.getDate().getFrom(), (String)""));
        this.wToDate.setText(Const.NVL((String)f.getDate().getTo(), (String)""));
        DimensionLookupMeta.TechnicalKeyCreationMethod creationMethod = f.getReturns().getCreationMethod();
        if (creationMethod == DimensionLookupMeta.TechnicalKeyCreationMethod.AUTO_INCREMENT) {
            this.wAutoIncrement.setSelection(true);
            this.wSeqButton.setSelection(false);
            this.wTableMax.setSelection(false);
        } else if (creationMethod == DimensionLookupMeta.TechnicalKeyCreationMethod.SEQUENCE) {
            this.wSeqButton.setSelection(true);
            this.wAutoIncrement.setSelection(false);
            this.wTableMax.setSelection(false);
        } else {
            this.wTableMax.setSelection(true);
            this.wAutoIncrement.setSelection(false);
            this.wSeqButton.setSelection(false);
            f.getReturns().setCreationMethod(DimensionLookupMeta.TechnicalKeyCreationMethod.TABLE_MAXIMUM);
        }
        this.wSeq.setText(Const.NVL((String)this.input.getSequenceName(), (String)""));
        this.wCommit.setText("" + this.input.getCommitSize());
        this.wUseCache.setSelection(this.input.getCacheSize() >= 0);
        this.wPreloadCache.setSelection(this.input.isPreloadingCache());
        this.wCacheSize.setText("" + this.input.getCacheSize());
        this.wMinYear.setText("" + this.input.getMinYear());
        this.wMaxYear.setText("" + this.input.getMaxYear());
        this.wUpIns.optimizeTableView();
        this.wKey.optimizeTableView();
        this.databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        this.wUseAltStartDate.setSelection(this.input.isUsingStartDateAlternative());
        if (this.input.isUsingStartDateAlternative()) {
            DimensionLookupMeta.StartDateAlternative alternative = this.input.getStartDateAlternative();
            String description = alternative == null ? "" : alternative.getDescription();
            this.wAltStartDate.setText(description);
        }
        this.wAltStartDateField.setText(Const.NVL((String)this.input.getStartDateFieldName(), (String)""));
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.transformName = this.wTransformName.getText();
        if (this.input.getConnection() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        this.input.setChanged(true);
        this.dispose();
    }

    private void getInfo(DimensionLookupMeta in) {
        in.setUpdate(this.wUpdate.getSelection());
        DimensionLookupMeta.DLFields f = in.getFields();
        f.getKeys().clear();
        for (TableItem item : this.wKey.getNonEmptyItems()) {
            DimensionLookupMeta.DLKey key = new DimensionLookupMeta.DLKey();
            key.setLookup(item.getText(1));
            key.setName(item.getText(2));
            f.getKeys().add(key);
        }
        this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Log.FoundKeys", (String[])new String[]{String.valueOf(f.getKeys().size())}));
        f.getFields().clear();
        for (TableItem item : this.wUpIns.getNonEmptyItems()) {
            DimensionLookupMeta.DLField field = new DimensionLookupMeta.DLField();
            field.setLookup(item.getText(1));
            field.setName(item.getText(2));
            if (in.isUpdate()) {
                DimensionLookupMeta.DimensionUpdateType updateType = DimensionLookupMeta.DimensionUpdateType.lookupDescription(item.getText(3));
                if (updateType != null) {
                    field.setUpdate(updateType.getCode());
                }
            } else {
                field.setReturnType(item.getText(3));
            }
            f.getFields().add(field);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Log.FoundFields", (Object[])new Object[]{f.getKeys().size()}));
        }
        in.setSchemaName(this.wSchema.getText());
        in.setTableName(this.wTable.getText());
        in.setSequenceName(this.wSeq.getText());
        f.getReturns().setKeyField(this.wTk.getText());
        f.getReturns().setKeyRename(this.wTkRename.getText());
        if (this.wAutoIncrement.getSelection()) {
            f.getReturns().setCreationMethod(DimensionLookupMeta.TechnicalKeyCreationMethod.AUTO_INCREMENT);
        } else if (this.wSeqButton.getSelection()) {
            f.getReturns().setCreationMethod(DimensionLookupMeta.TechnicalKeyCreationMethod.SEQUENCE);
        } else {
            f.getReturns().setCreationMethod(DimensionLookupMeta.TechnicalKeyCreationMethod.TABLE_MAXIMUM);
        }
        f.getReturns().setVersionField(this.wVersion.getText());
        in.setConnection(this.wConnection.getText());
        f.getDate().setName(this.wDateField.getText());
        f.getDate().setFrom(this.wFromDate.getText());
        f.getDate().setTo(this.wToDate.getText());
        in.setCommitSize(Const.toInt((String)this.wCommit.getText(), (int)0));
        if (this.wUseCache.getSelection()) {
            in.setCacheSize(Const.toInt((String)this.wCacheSize.getText(), (int)-1));
        } else {
            in.setCacheSize(-1);
        }
        in.setPreloadingCache(this.wPreloadCache.getSelection());
        if (this.wPreloadCache.getSelection()) {
            in.setCacheSize(0);
        }
        in.setMinYear(Const.toInt((String)this.wMinYear.getText(), (int)1900));
        in.setMaxYear(Const.toInt((String)this.wMaxYear.getText(), (int)2199));
        in.setUsingStartDateAlternative(this.wUseAltStartDate.getSelection());
        in.setStartDateAlternative(DimensionLookupMeta.StartDateAlternative.lookupWithDescription(this.wAltStartDate.getText()));
        in.setStartDateFieldName(this.wAltStartDateField.getText());
    }

    private void getTableName() {
        DatabaseMeta dbMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (dbMeta == null) {
            return;
        }
        this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Log.LookingAtConnection", (String[])new String[0]) + dbMeta.getName());
        DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, dbMeta, this.pipelineMeta.getDatabases());
        std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
        if (std.open()) {
            this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
            this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            this.setTableFieldCombo();
        }
    }

    private void get() {
        if (this.wTabFolder.getSelection() == this.wFieldsTab) {
            if (this.input.isUpdate()) {
                this.getUpdate();
            } else {
                this.getLookup();
            }
        } else {
            this.getKeys();
        }
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wUpIns, (int)2, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (tableItem, v) -> {
                    tableItem.setText(3, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TableItem.Insert.Label", (String[])new String[0]));
                    int idx = this.wKey.indexOfString(v.getName(), 2);
                    return idx < 0 && !v.getName().equalsIgnoreCase(this.wTk.getText()) && !v.getName().equalsIgnoreCase(this.wVersion.getText()) && !v.getName().equalsIgnoreCase(this.wFromDate.getText()) && !v.getName().equalsIgnoreCase(this.wToDate.getText());
                });
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            String tableName = this.variables.resolve(this.wTable.getText());
            String schemaName = this.variables.resolve(this.wSchema.getText());
            DatabaseMeta dbMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
            if (dbMeta == null || StringUtils.isEmpty((String)tableName)) {
                return;
            }
            for (ColumnInfo colInfo : this.tableFieldColumns) {
                colInfo.setComboValues(new String[0]);
            }
            this.gotTableFields = false;
            try (Database db = new Database(loggingObject, this.variables, dbMeta);){
                db.connect();
                IRowMeta rowMeta = db.getTableFieldsMeta(schemaName, tableName);
                if (rowMeta == null) {
                    return;
                }
                String[] fieldNames = Const.sortStrings((String[])rowMeta.getFieldNames());
                for (ColumnInfo colInfo : this.tableFieldColumns) {
                    colInfo.setComboValues(fieldNames);
                }
                String tk = this.wTk.getText();
                this.wTk.setItems(fieldNames);
                this.wTk.setText(Const.NVL((String)tk, (String)""));
            }
            catch (Exception e) {
                for (ColumnInfo colInfo : this.tableFieldColumns) {
                    colInfo.setComboValues(new String[0]);
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    private void getLookup() {
        String tableName = this.variables.resolve(this.wTable.getText());
        String schemaName = this.variables.resolve(this.wSchema.getText());
        DatabaseMeta dbMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (dbMeta != null && StringUtils.isNotEmpty((String)tableName)) {
            try (Database db = new Database(loggingObject, this.variables, dbMeta);){
                db.connect();
                IRowMeta rowMeta = db.getTableFieldsMeta(schemaName, tableName);
                if (rowMeta != null && !rowMeta.isEmpty()) {
                    BaseTransformDialog.getFieldsFromPrevious((IRowMeta)rowMeta, (TableView)this.wUpIns, (int)2, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, (tableItem, v) -> {
                        int idx = this.wKey.indexOfString(v.getName(), 2);
                        return idx < 0 && !v.getName().equalsIgnoreCase(this.wTk.getText()) && !v.getName().equalsIgnoreCase(this.wVersion.getText()) && !v.getName().equalsIgnoreCase(this.wFromDate.getText()) && !v.getName().equalsIgnoreCase(this.wToDate.getText());
                    });
                }
            }
            catch (HopException e) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorOccurred.DialogTitle", (String[])new String[0]));
                mb.setMessage(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorOccurred.DialogMessage", (String[])new String[0]) + Const.CR + e.getMessage());
                mb.open();
            }
        }
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wDateField.getText();
                IRowMeta rowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (rowMeta != null) {
                    String[] fieldNames = Const.sortStrings((String[])rowMeta.getFieldNames());
                    this.wDateField.setItems(fieldNames);
                }
                if (field != null) {
                    this.wDateField.setText(field);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorGettingFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorGettingFields.Message", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    private void getFieldsFromTable() {
        if (this.gotTableFields) {
            return;
        }
        String schemaName = this.variables.resolve(this.wSchema.getText());
        String tableName = this.variables.resolve(this.wTable.getText());
        DatabaseMeta dbMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (dbMeta == null || StringUtils.isEmpty((String)tableName)) {
            return;
        }
        try (Database db = new Database(loggingObject, this.variables, dbMeta);){
            db.connect();
            IRowMeta rowMeta = db.getTableFieldsMeta(schemaName, tableName);
            if (null != rowMeta) {
                String[] fieldNames = Const.sortStrings((String[])rowMeta.getFieldNames());
                String version = this.wVersion.getText();
                this.wVersion.setItems(fieldNames);
                this.wVersion.setText(Const.NVL((String)version, (String)""));
                String fromDate = this.wFromDate.getText();
                this.wFromDate.setItems(fieldNames);
                this.wFromDate.setText(Const.NVL((String)fromDate, (String)""));
                String toDate = this.wToDate.getText();
                this.wToDate.setItems(fieldNames);
                this.wToDate.setText(Const.NVL((String)toDate, (String)""));
                String tk = this.wTk.getText();
                this.wTk.setItems(fieldNames);
                this.wTk.setText(Const.NVL((String)tk, (String)""));
                String sd = this.wAltStartDateField.getText();
                this.wAltStartDateField.setItems(fieldNames);
                this.wAltStartDateField.setText(Const.NVL((String)sd, (String)""));
            }
            this.gotTableFields = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getKeys() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)2, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, (tableItem, v) -> {
                    int idx = this.wKey.indexOfString(v.getName(), 2);
                    return idx < 0 && !v.getName().equalsIgnoreCase(this.wTk.getText()) && !v.getName().equalsIgnoreCase(this.wVersion.getText()) && !v.getName().equalsIgnoreCase(this.wFromDate.getText()) && !v.getName().equalsIgnoreCase(this.wToDate.getText());
                });
                Table table = this.wKey.table;
                for (int i = 0; i < r.size(); ++i) {
                    IValueMeta v2 = r.getValueMeta(i);
                    int idx = this.wKey.indexOfString(v2.getName(), 2);
                    int idy = this.wUpIns.indexOfString(v2.getName(), 2);
                    if (idx >= 0 || idy >= 0 || v2.getName().equalsIgnoreCase(this.wTk.getText()) || v2.getName().equalsIgnoreCase(this.wVersion.getText()) || v2.getName().equalsIgnoreCase(this.wFromDate.getText()) || v2.getName().equalsIgnoreCase(this.wToDate.getText())) continue;
                    TableItem ti = new TableItem(table, 0);
                    ti.setText(1, v2.getName());
                    ti.setText(2, v2.getName());
                    ti.setText(3, v2.getTypeDesc());
                }
                this.wKey.removeEmptyRows();
                this.wKey.setRowNums();
                this.wKey.optWidth(true);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            DimensionLookupMeta info = new DimensionLookupMeta();
            this.getInfo(info);
            String name = this.transformName;
            TransformMeta transforminfo = new TransformMeta(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Transform.Title", (String[])new String[0]), name, (ITransformMeta)info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            String message = null;
            if (StringUtils.isEmpty((String)info.getFields().getReturns().getKeyField())) {
                message = BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Error.NoTechnicalKeySpecified", (String[])new String[0]);
            }
            if (Utils.isEmpty((CharSequence)info.getTableName())) {
                message = BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Error.NoTableNameSpecified", (String[])new String[0]);
            }
            if (message == null) {
                SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transforminfo, prev, this.metadataProvider);
                if (!sql.hasError()) {
                    if (sql.hasSql()) {
                        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
                        SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                        sqledit.open();
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 34);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(sql.getError());
                    mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.SQLError.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(message);
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UnableToBuildSQLError.DialogMessage", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UnableToBuildSQLError.DialogTitle", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] schemas = Const.sortStrings((String[])database.getSchemas());
                if (schemas != null && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
        }
    }
}

