/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableoutput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputField;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TableOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = TableOutputMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private Label wlTable;
    private TextVar wTable;
    private TextVar wCommit;
    private Label wlTruncate;
    private Button wTruncate;
    private Button wOnlyWhenHaveRows;
    private Label wlIgnore;
    private Button wIgnore;
    private Button wSpecifyFields;
    private Label wlBatch;
    private Button wBatch;
    private Button wUsePart;
    private Label wlPartField;
    private ComboVar wPartField;
    private Label wlPartMonthly;
    private Button wPartMonthly;
    private Label wlPartDaily;
    private Button wPartDaily;
    private Button wNameInField;
    private Label wlNameField;
    private ComboVar wNameField;
    private Label wlNameInTable;
    private Button wNameInTable;
    private Button wReturnKeys;
    private Label wlReturnField;
    private TextVar wReturnField;
    private TableView wFields;
    private Button wGetFields;
    private Button wDoMapping;
    private final TableOutputMeta input;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] ciFields;
    private boolean gotPreviousFields = false;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private static final String ERROR_TITLE = "System.Dialog.Error.Title";

    public TableOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (TableOutputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableOutputDialog.this.input.setChanged();
                TableOutputDialog.this.setTableFieldCombo();
                TableOutputDialog.this.validateSelection();
            }
        };
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        TableOutputDialog tableOutputDialog = this;
        int margin = tableOutputDialog.props.getMargin();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.DialogTitle", (String[])new String[0]));
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getConnection(), lsMod);
        this.wConnection.addModifyListener(e -> this.setFlags());
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        this.wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlCommit = new Label((Composite)this.shell, 131072);
        wlCommit.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.CommitSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.right = new FormAttachment(middle, -margin);
        fdlCommit.top = new FormAttachment((Control)wbTable, margin);
        wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wCommit);
        FormData fdCommit = new FormData();
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.top = new FormAttachment((Control)wlCommit, 0, 0x1000000);
        fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData((Object)fdCommit);
        this.wlTruncate = new Label((Composite)this.shell, 131072);
        this.wlTruncate.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.TruncateTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTruncate);
        FormData fdlTruncate = new FormData();
        fdlTruncate.left = new FormAttachment(0, 0);
        fdlTruncate.top = new FormAttachment((Control)this.wCommit, margin);
        fdlTruncate.right = new FormAttachment(middle, -margin);
        this.wlTruncate.setLayoutData((Object)fdlTruncate);
        this.wTruncate = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wTruncate);
        FormData fdTruncate = new FormData();
        fdTruncate.left = new FormAttachment(middle, 0);
        fdTruncate.top = new FormAttachment((Control)this.wlTruncate, 0, 0x1000000);
        fdTruncate.right = new FormAttachment(100, 0);
        this.wTruncate.setLayoutData((Object)fdTruncate);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.input.setChanged();
            }
        };
        this.wTruncate.addSelectionListener((SelectionListener)lsSelMod);
        this.wTruncate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableOutputDialog.this.setFlags();
            }
        });
        Label wlOnlyWhenHaveRows = new Label((Composite)this.shell, 131072);
        wlOnlyWhenHaveRows.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.OnlyWhenHaveRows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOnlyWhenHaveRows);
        FormData fdlOnlyWhenHaveRows = new FormData();
        fdlOnlyWhenHaveRows.left = new FormAttachment(0, 0);
        fdlOnlyWhenHaveRows.top = new FormAttachment((Control)this.wlTruncate, margin);
        fdlOnlyWhenHaveRows.right = new FormAttachment(middle, -margin);
        wlOnlyWhenHaveRows.setLayoutData((Object)fdlOnlyWhenHaveRows);
        this.wOnlyWhenHaveRows = new Button((Composite)this.shell, 32);
        this.wOnlyWhenHaveRows.setToolTipText(BaseMessages.getString(PKG, (String)"TableOutputDialog.OnlyWhenHaveRows.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOnlyWhenHaveRows);
        FormData fdTruncateWhenHaveRows = new FormData();
        fdTruncateWhenHaveRows.left = new FormAttachment(middle, 0);
        fdTruncateWhenHaveRows.top = new FormAttachment((Control)wlOnlyWhenHaveRows, 0, 0x1000000);
        fdTruncateWhenHaveRows.right = new FormAttachment(100, 0);
        this.wOnlyWhenHaveRows.setLayoutData((Object)fdTruncateWhenHaveRows);
        this.wOnlyWhenHaveRows.addSelectionListener((SelectionListener)lsSelMod);
        this.wlIgnore = new Label((Composite)this.shell, 131072);
        this.wlIgnore.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.IgnoreInsertErrors.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlIgnore);
        FormData fdlIgnore = new FormData();
        fdlIgnore.left = new FormAttachment(0, 0);
        fdlIgnore.top = new FormAttachment((Control)this.wOnlyWhenHaveRows, margin);
        fdlIgnore.right = new FormAttachment(middle, -margin);
        this.wlIgnore.setLayoutData((Object)fdlIgnore);
        this.wIgnore = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wIgnore);
        FormData fdIgnore = new FormData();
        fdIgnore.left = new FormAttachment(middle, 0);
        fdIgnore.top = new FormAttachment((Control)this.wlIgnore, 0, 0x1000000);
        fdIgnore.right = new FormAttachment(100, 0);
        this.wIgnore.setLayoutData((Object)fdIgnore);
        this.wIgnore.addSelectionListener((SelectionListener)lsSelMod);
        Label wlSpecifyFields = new Label((Composite)this.shell, 131072);
        wlSpecifyFields.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.SpecifyFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSpecifyFields);
        FormData fdlSpecifyFields = new FormData();
        fdlSpecifyFields.left = new FormAttachment(0, 0);
        fdlSpecifyFields.top = new FormAttachment((Control)this.wIgnore, margin);
        fdlSpecifyFields.right = new FormAttachment(middle, -margin);
        wlSpecifyFields.setLayoutData((Object)fdlSpecifyFields);
        this.wSpecifyFields = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSpecifyFields);
        FormData fdSpecifyFields = new FormData();
        fdSpecifyFields.left = new FormAttachment(middle, 0);
        fdSpecifyFields.top = new FormAttachment((Control)wlSpecifyFields, 0, 0x1000000);
        fdSpecifyFields.right = new FormAttachment(100, 0);
        this.wSpecifyFields.setLayoutData((Object)fdSpecifyFields);
        this.wSpecifyFields.addSelectionListener((SelectionListener)lsSelMod);
        this.wSpecifyFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.setFlags();
            }
        });
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wMainTab = new CTabItem(wTabFolder, 0);
        wMainTab.setFont(GuiResource.getInstance().getFontDefault());
        wMainTab.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.MainTab.CTabItem", (String[])new String[0]));
        FormLayout mainLayout = new FormLayout();
        mainLayout.marginWidth = 3;
        mainLayout.marginHeight = 3;
        Composite wMainComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wMainComp);
        wMainComp.setLayout((Layout)mainLayout);
        Label wlUsePart = new Label(wMainComp, 131072);
        wlUsePart.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.UsePart.Label", (String[])new String[0]));
        wlUsePart.setToolTipText(BaseMessages.getString(PKG, (String)"TableOutputDialog.UsePart.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUsePart);
        FormData fdlUsePart = new FormData();
        fdlUsePart.left = new FormAttachment(0, 0);
        fdlUsePart.top = new FormAttachment(0, margin);
        fdlUsePart.right = new FormAttachment(middle, -margin);
        wlUsePart.setLayoutData((Object)fdlUsePart);
        this.wUsePart = new Button(wMainComp, 32);
        PropsUi.setLook((Widget)this.wUsePart);
        FormData fdUsePart = new FormData();
        fdUsePart.left = new FormAttachment(middle, 0);
        fdUsePart.top = new FormAttachment((Control)wlUsePart, 0, 0x1000000);
        fdUsePart.right = new FormAttachment(100, 0);
        this.wUsePart.setLayoutData((Object)fdUsePart);
        this.wUsePart.addSelectionListener((SelectionListener)lsSelMod);
        this.wUsePart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (TableOutputDialog.this.wUsePart.getSelection()) {
                    TableOutputDialog.this.wNameInField.setSelection(false);
                }
                TableOutputDialog.this.setFlags();
            }
        });
        this.wlPartField = new Label(wMainComp, 131072);
        this.wlPartField.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPartField);
        FormData fdlPartField = new FormData();
        fdlPartField.top = new FormAttachment((Control)this.wUsePart, margin);
        fdlPartField.left = new FormAttachment(0, 0);
        fdlPartField.right = new FormAttachment(middle, -margin);
        this.wlPartField.setLayoutData((Object)fdlPartField);
        this.wPartField = new ComboVar(this.variables, wMainComp, 18436);
        PropsUi.setLook((Widget)this.wPartField);
        FormData fdPartField = new FormData();
        fdPartField.top = new FormAttachment((Control)this.wlPartField, 0, 0x1000000);
        fdPartField.left = new FormAttachment(middle, 0);
        fdPartField.right = new FormAttachment(100, 0);
        this.wPartField.setLayoutData((Object)fdPartField);
        this.wPartField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)TableOutputDialog.this.shell.getDisplay(), 1);
                TableOutputDialog.this.shell.setCursor(busy);
                TableOutputDialog.this.getFields();
                TableOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlPartMonthly = new Label(wMainComp, 131072);
        this.wlPartMonthly.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartMonthly.Label", (String[])new String[0]));
        this.wlPartMonthly.setToolTipText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartMonthly.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPartMonthly);
        FormData fdlPartMonthly = new FormData();
        fdlPartMonthly.left = new FormAttachment(0, 0);
        fdlPartMonthly.top = new FormAttachment((Control)this.wPartField, margin);
        fdlPartMonthly.right = new FormAttachment(middle, -margin);
        this.wlPartMonthly.setLayoutData((Object)fdlPartMonthly);
        this.wPartMonthly = new Button(wMainComp, 16);
        PropsUi.setLook((Widget)this.wPartMonthly);
        FormData fdPartMonthly = new FormData();
        fdPartMonthly.left = new FormAttachment(middle, 0);
        fdPartMonthly.top = new FormAttachment((Control)this.wlPartMonthly, 0, 0x1000000);
        fdPartMonthly.right = new FormAttachment(100, 0);
        this.wPartMonthly.setLayoutData((Object)fdPartMonthly);
        this.wPartMonthly.addSelectionListener((SelectionListener)lsSelMod);
        this.wPartMonthly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.wPartMonthly.setSelection(true);
                TableOutputDialog.this.wPartDaily.setSelection(false);
            }
        });
        this.wlPartDaily = new Label(wMainComp, 131072);
        this.wlPartDaily.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartDaily.Label", (String[])new String[0]));
        this.wlPartDaily.setToolTipText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartDaily.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPartDaily);
        FormData fdlPartDaily = new FormData();
        fdlPartDaily.left = new FormAttachment(0, 0);
        fdlPartDaily.top = new FormAttachment((Control)this.wPartMonthly, margin);
        fdlPartDaily.right = new FormAttachment(middle, -margin);
        this.wlPartDaily.setLayoutData((Object)fdlPartDaily);
        this.wPartDaily = new Button(wMainComp, 16);
        PropsUi.setLook((Widget)this.wPartDaily);
        FormData fdPartDaily = new FormData();
        fdPartDaily.left = new FormAttachment(middle, 0);
        fdPartDaily.top = new FormAttachment((Control)this.wlPartDaily, 0, 0x1000000);
        fdPartDaily.right = new FormAttachment(100, 0);
        this.wPartDaily.setLayoutData((Object)fdPartDaily);
        this.wPartDaily.addSelectionListener((SelectionListener)lsSelMod);
        this.wPartDaily.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.wPartDaily.setSelection(true);
                TableOutputDialog.this.wPartMonthly.setSelection(false);
            }
        });
        this.wlBatch = new Label(wMainComp, 131072);
        this.wlBatch.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.Batch.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlBatch);
        FormData fdlBatch = new FormData();
        fdlBatch.left = new FormAttachment(0, 0);
        fdlBatch.top = new FormAttachment((Control)this.wPartDaily, 5 * margin);
        fdlBatch.right = new FormAttachment(middle, -margin);
        this.wlBatch.setLayoutData((Object)fdlBatch);
        this.wBatch = new Button(wMainComp, 32);
        PropsUi.setLook((Widget)this.wBatch);
        FormData fdBatch = new FormData();
        fdBatch.left = new FormAttachment(middle, 0);
        fdBatch.top = new FormAttachment((Control)this.wlBatch, 0, 0x1000000);
        fdBatch.right = new FormAttachment(100, 0);
        this.wBatch.setLayoutData((Object)fdBatch);
        this.wBatch.addSelectionListener((SelectionListener)lsSelMod);
        this.wBatch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.setFlags();
            }
        });
        Label wlNameInField = new Label(wMainComp, 131072);
        wlNameInField.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.NameInField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNameInField);
        FormData fdlNameInField = new FormData();
        fdlNameInField.left = new FormAttachment(0, 0);
        fdlNameInField.top = new FormAttachment((Control)this.wBatch, margin * 5);
        fdlNameInField.right = new FormAttachment(middle, -margin);
        wlNameInField.setLayoutData((Object)fdlNameInField);
        this.wNameInField = new Button(wMainComp, 32);
        PropsUi.setLook((Widget)this.wNameInField);
        FormData fdNameInField = new FormData();
        fdNameInField.left = new FormAttachment(middle, 0);
        fdNameInField.top = new FormAttachment((Control)wlNameInField, 0, 0x1000000);
        fdNameInField.right = new FormAttachment(100, 0);
        this.wNameInField.setLayoutData((Object)fdNameInField);
        this.wNameInField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (TableOutputDialog.this.wNameInField.getSelection()) {
                    TableOutputDialog.this.wUsePart.setSelection(false);
                }
                TableOutputDialog.this.setFlags();
            }
        });
        this.wNameInField.addSelectionListener((SelectionListener)lsSelMod);
        this.wlNameField = new Label(wMainComp, 131072);
        this.wlNameField.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.NameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlNameField);
        FormData fdlNameField = new FormData();
        fdlNameField.left = new FormAttachment(0, 0);
        fdlNameField.top = new FormAttachment((Control)this.wNameInField, margin);
        fdlNameField.right = new FormAttachment(middle, -margin);
        this.wlNameField.setLayoutData((Object)fdlNameField);
        this.wNameField = new ComboVar(this.variables, wMainComp, 18436);
        PropsUi.setLook((Widget)this.wNameField);
        FormData fdNameField = new FormData();
        fdNameField.left = new FormAttachment(middle, 0);
        fdNameField.top = new FormAttachment((Control)this.wlNameField, 0, 0x1000000);
        fdNameField.right = new FormAttachment(100, 0);
        this.wNameField.setLayoutData((Object)fdNameField);
        this.wNameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)TableOutputDialog.this.shell.getDisplay(), 1);
                TableOutputDialog.this.shell.setCursor(busy);
                TableOutputDialog.this.getFields();
                TableOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlNameInTable = new Label(wMainComp, 131072);
        this.wlNameInTable.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.NameInTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlNameInTable);
        FormData fdlNameInTable = new FormData();
        fdlNameInTable.left = new FormAttachment(0, 0);
        fdlNameInTable.top = new FormAttachment((Control)this.wNameField, margin);
        fdlNameInTable.right = new FormAttachment(middle, -margin);
        this.wlNameInTable.setLayoutData((Object)fdlNameInTable);
        this.wNameInTable = new Button(wMainComp, 32);
        PropsUi.setLook((Widget)this.wNameInTable);
        FormData fdNameInTable = new FormData();
        fdNameInTable.left = new FormAttachment(middle, 0);
        fdNameInTable.top = new FormAttachment((Control)this.wlNameInTable, 0, 0x1000000);
        fdNameInTable.right = new FormAttachment(100, 0);
        this.wNameInTable.setLayoutData((Object)fdNameInTable);
        this.wNameInTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.setFlags();
            }
        });
        this.wNameInTable.addSelectionListener((SelectionListener)lsSelMod);
        Label wlReturnKeys = new Label(wMainComp, 131072);
        wlReturnKeys.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.ReturnKeys.Label", (String[])new String[0]));
        wlReturnKeys.setToolTipText(BaseMessages.getString(PKG, (String)"TableOutputDialog.ReturnKeys.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReturnKeys);
        FormData fdlReturnKeys = new FormData();
        fdlReturnKeys.left = new FormAttachment(0, 0);
        fdlReturnKeys.top = new FormAttachment((Control)this.wNameInTable, margin * 5);
        fdlReturnKeys.right = new FormAttachment(middle, -margin);
        wlReturnKeys.setLayoutData((Object)fdlReturnKeys);
        this.wReturnKeys = new Button(wMainComp, 32);
        PropsUi.setLook((Widget)this.wReturnKeys);
        FormData fdReturnKeys = new FormData();
        fdReturnKeys.left = new FormAttachment(middle, 0);
        fdReturnKeys.top = new FormAttachment((Control)wlReturnKeys, 0, 0x1000000);
        fdReturnKeys.right = new FormAttachment(100, 0);
        this.wReturnKeys.setLayoutData((Object)fdReturnKeys);
        this.wReturnKeys.addSelectionListener((SelectionListener)lsSelMod);
        this.wReturnKeys.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.setFlags();
            }
        });
        this.wlReturnField = new Label(wMainComp, 131072);
        this.wlReturnField.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.ReturnField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlReturnField);
        FormData fdlReturnField = new FormData();
        fdlReturnField.left = new FormAttachment(0, 0);
        fdlReturnField.right = new FormAttachment(middle, -margin);
        fdlReturnField.top = new FormAttachment((Control)this.wReturnKeys, margin);
        this.wlReturnField.setLayoutData((Object)fdlReturnField);
        this.wReturnField = new TextVar(this.variables, wMainComp, 18436);
        PropsUi.setLook((Widget)this.wReturnField);
        FormData fdReturnField = new FormData();
        fdReturnField.left = new FormAttachment(middle, 0);
        fdReturnField.top = new FormAttachment((Control)this.wlReturnField, 0, 0x1000000);
        fdReturnField.right = new FormAttachment(100, 0);
        this.wReturnField.setLayoutData((Object)fdReturnField);
        FormData fdMainComp = new FormData();
        fdMainComp.left = new FormAttachment(0, 0);
        fdMainComp.top = new FormAttachment(0, 0);
        fdMainComp.right = new FormAttachment(100, 0);
        fdMainComp.bottom = new FormAttachment(100, 0);
        wMainComp.setLayoutData((Object)fdMainComp);
        wMainComp.layout();
        wMainTab.setControl((Control)wMainComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.FieldsTab.CTabItem.Title", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        FormLayout fieldsCompLayout = new FormLayout();
        fieldsCompLayout.marginWidth = PropsUi.getFormMargin();
        fieldsCompLayout.marginHeight = PropsUi.getFormMargin();
        wFieldsComp.setLayout((Layout)fieldsCompLayout);
        Label wlFields = new Label(wFieldsComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.InsertFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(0, margin);
        wlFields.setLayoutData((Object)fdlUpIns);
        int tableCols = 2;
        int upInsRows = this.input.getFields() != null && !this.input.getFields().equals(Collections.emptyList()) ? this.input.getFields().size() : 1;
        this.ciFields = new ColumnInfo[tableCols];
        this.ciFields[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TableOutputDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciFields[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TableOutputDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciFields[0]);
        this.wFields = new TableView(this.variables, wFieldsComp, 68354, this.ciFields, upInsRows, lsMod, this.props);
        this.wGetFields = new Button(wFieldsComp, 8);
        this.wGetFields.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGetFields = new FormData();
        fdGetFields.top = new FormAttachment((Control)wlFields, margin);
        fdGetFields.right = new FormAttachment(100, 0);
        this.wGetFields.setLayoutData((Object)fdGetFields);
        this.wDoMapping = new Button(wFieldsComp, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.Button", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)this.wGetFields, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)fdDoMapping);
        this.wDoMapping.addListener(13, arg0 -> this.generateMappings());
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wDoMapping, -margin);
        fdFields.bottom = new FormAttachment(100, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString(PKG, (String)"System.Button.SQL", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel, this.wCreate}, margin, null);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wSpecifyFields, 3 * margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wOk.addListener(13, e -> this.ok());
        this.wCreate.addListener(13, e -> this.sql());
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGetFields.addListener(13, e -> this.get());
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableOutputDialog.this.getTableName();
            }
        });
        wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableOutputDialog.this.getSchemaNames();
            }
        });
        wTabFolder.setSelection(0);
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wNameField.getText();
                String partfield = this.wPartField.getText();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wNameField.setItems(r.getFieldNames());
                    this.wPartField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wNameField.setText(field);
                }
                if (partfield != null) {
                    this.wPartField.setText(partfield);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setTableName(this.variables.resolve(this.wTable.getText()));
        try {
            DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
            targetFields = this.input.getTableFields(databaseMeta, this.variables.resolve(this.wTable.getText()), this.variables.resolve(this.wSchema.getText()), this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wFields.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)196);
            boolean bl = goOn = (answer & 0x40) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wFields.table.removeAll();
            this.wFields.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"TableOutputDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"TableOutputDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"TableOutputDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)ERROR_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }

    private void validateSelection() {
        Runnable fieldLoader = this::isConnectionSupported;
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void isConnectionSupported() {
        DatabaseMeta dbmeta;
        String tableName = this.wTable.getText();
        String connectionName = this.variables.resolve(this.wConnection.getText());
        if (!Utils.isEmpty((CharSequence)tableName) && (dbmeta = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null && !dbmeta.getIDatabase().supportsStandardTableOutput()) {
            this.showUnsupportedConnectionMessageBox(dbmeta.getIDatabase());
        }
    }

    protected void showUnsupportedConnectionMessageBox(IDatabase dbi) {
        String title = BaseMessages.getString(PKG, (String)"TableOutput.UnsupportedConnection.DialogTitle", (String[])new String[0]);
        String message = dbi.getUnsupportedTableOutputMessage();
        BaseDialog.openMessageBox((Shell)this.shell, (String)title, (String)message, (int)40);
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                DatabaseMeta databaseMeta;
                String tableName = this.wTable.getText();
                String connectionName = this.variables.resolve(this.wConnection.getText());
                String schemaName = this.wSchema.getText();
                for (ColumnInfo colInfo : this.tableFieldColumns) {
                    colInfo.setComboValues(new String[0]);
                }
                if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null) {
                    Database db = new Database(loggingObject, this.variables, databaseMeta);
                    try {
                        String[] fieldNames;
                        db.connect();
                        IRowMeta r = db.getTableFieldsMeta(this.variables.resolve(schemaName), this.variables.resolve(tableName));
                        if (null != r && null != (fieldNames = r.getFieldNames())) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                    }
                    catch (Exception e) {
                        for (ColumnInfo colInfo : this.tableFieldColumns) {
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                    finally {
                        try {
                            if (db != null) {
                                db.disconnect();
                            }
                        }
                        catch (Exception ignored) {
                            db = null;
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciFields[1].setComboValues(fieldNames);
    }

    public void setFlags() {
        boolean returnKeys = this.wReturnKeys.getSelection();
        boolean useBatch = this.wBatch.getSelection() && !returnKeys;
        boolean enableBatch = !returnKeys;
        boolean useIgnore = !useBatch;
        boolean usePartitioning = this.wUsePart.getSelection();
        boolean isTableNameInField = this.wNameInField.getSelection();
        boolean enableTruncate = !usePartitioning && !isTableNameInField;
        boolean useTruncate = this.wTruncate.getSelection() && enableTruncate;
        boolean useTablename = !isTableNameInField;
        this.wUsePart.setSelection(usePartitioning);
        this.wNameInField.setSelection(isTableNameInField);
        this.wBatch.setSelection(useBatch);
        this.wReturnKeys.setSelection(returnKeys);
        this.wTruncate.setSelection(useTruncate);
        this.wIgnore.setEnabled(useIgnore);
        this.wlIgnore.setEnabled(useIgnore);
        this.wlPartMonthly.setEnabled(usePartitioning);
        this.wPartMonthly.setEnabled(usePartitioning);
        this.wlPartDaily.setEnabled(usePartitioning);
        this.wPartDaily.setEnabled(usePartitioning);
        this.wlPartField.setEnabled(usePartitioning);
        this.wPartField.setEnabled(usePartitioning);
        this.wlNameField.setEnabled(isTableNameInField);
        this.wNameField.setEnabled(isTableNameInField);
        this.wlNameInTable.setEnabled(isTableNameInField);
        this.wNameInTable.setEnabled(isTableNameInField);
        this.wlTable.setEnabled(useTablename);
        this.wTable.setEnabled(useTablename);
        this.wlTruncate.setEnabled(enableTruncate);
        this.wTruncate.setEnabled(enableTruncate);
        this.wOnlyWhenHaveRows.setEnabled(useTruncate);
        this.wlReturnField.setEnabled(returnKeys);
        this.wReturnField.setEnabled(returnKeys);
        this.wlBatch.setEnabled(enableBatch);
        this.wBatch.setEnabled(enableBatch);
        boolean specifyFields = this.wSpecifyFields.getSelection();
        this.wFields.setEnabled(specifyFields);
        this.wGetFields.setEnabled(specifyFields);
        this.wDoMapping.setEnabled(specifyFields);
        this.wlNameInTable.setEnabled(isTableNameInField && !specifyFields);
        this.wNameInTable.setEnabled(isTableNameInField && !specifyFields);
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            if (!databaseMeta.supportsAutoGeneratedKeys()) {
                this.wReturnKeys.setEnabled(false);
                this.wReturnKeys.setSelection(false);
                this.wReturnField.setEnabled(false);
                this.wReturnField.setText("");
            } else {
                this.wReturnKeys.setEnabled(true);
                this.wReturnField.setEnabled(true);
            }
        } else {
            this.wReturnKeys.setEnabled(true);
            this.wReturnField.setEnabled(true);
        }
    }

    public void getData() {
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wTruncate.setSelection(this.input.isTruncateTable());
        this.wOnlyWhenHaveRows.setSelection(this.input.isOnlyWhenHaveRows());
        this.wIgnore.setSelection(this.input.isIgnoreErrors());
        this.wBatch.setSelection(this.input.isUseBatchUpdate());
        this.wCommit.setText(this.input.getCommitSize());
        this.wUsePart.setSelection(this.input.isPartitioningEnabled());
        this.wPartDaily.setSelection(this.input.isPartitioningDaily());
        this.wPartMonthly.setSelection(this.input.isPartitioningMonthly());
        if (this.input.getPartitioningField() != null) {
            this.wPartField.setText(this.input.getPartitioningField());
        }
        this.wNameInField.setSelection(this.input.isTableNameInField());
        if (this.input.getTableNameField() != null) {
            this.wNameField.setText(this.input.getTableNameField());
        }
        this.wNameInTable.setSelection(this.input.isTableNameInTable());
        this.wReturnKeys.setSelection(this.input.isReturningGeneratedKeys());
        if (this.input.getGeneratedKeyField() != null) {
            this.wReturnField.setText(this.input.getGeneratedKeyField());
        }
        this.wSpecifyFields.setSelection(this.input.isSpecifyFields());
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            TableOutputField tf = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            if (tf.getFieldDatabase() != null) {
                item.setText(1, tf.getFieldDatabase());
            }
            if (tf.getFieldStream() == null) continue;
            item.setText(2, tf.getFieldStream());
        }
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(TableOutputMeta info) {
        info.setSchemaName(this.wSchema.getText());
        info.setTableName(this.wTable.getText());
        info.setConnection(this.wConnection.getText());
        info.setCommitSize(this.wCommit.getText());
        info.setTruncateTable(this.wTruncate.getSelection());
        info.setOnlyWhenHaveRows(this.wOnlyWhenHaveRows.getSelection());
        info.setIgnoreErrors(this.wIgnore.getSelection());
        info.setUseBatchUpdate(this.wBatch.getSelection());
        info.setPartitioningEnabled(this.wUsePart.getSelection());
        info.setPartitioningField(this.wPartField.getText());
        info.setPartitioningDaily(this.wPartDaily.getSelection());
        info.setPartitioningMonthly(this.wPartMonthly.getSelection());
        info.setTableNameInField(this.wNameInField.getSelection());
        info.setTableNameField(this.wNameField.getText());
        info.setTableNameInTable(this.wNameInTable.getSelection());
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null && !databaseMeta.supportsAutoGeneratedKeys() && this.wReturnKeys.getSelection()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToSetGenKeyFlag.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)ERROR_TITLE, (String[])new String[0]));
            mb.open();
            return;
        }
        info.setReturningGeneratedKeys(this.wReturnKeys.getSelection());
        info.setGeneratedKeyField(this.wReturnField.getText());
        info.setSpecifyFields(this.wSpecifyFields.getSelection());
        int nrRows = this.wFields.nrNonEmpty();
        info.getFields().clear();
        for (int i = 0; i < nrRows; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            TableOutputField tf = new TableOutputField(Const.NVL((String)item.getText(1), (String)""), Const.NVL((String)item.getText(2), (String)""));
            info.getFields().add(tf);
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        if (Utils.isEmpty((CharSequence)this.input.getConnection())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableOutputDialog.ConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)ERROR_TITLE, (String[])new String[0]));
            mb.open();
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        boolean supportsBatchErrorHandling = databaseMeta != null && databaseMeta.supportsErrorHandlingOnBatchUpdates();
        boolean hasErrorHandling = this.transformMeta.isDoingErrorHandling();
        if (!supportsBatchErrorHandling && hasErrorHandling) {
            MessageBox mb = new MessageBox(this.shell, 40);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableOutput.Warning.ErrorHandlingIsNotFullySupportedWithBatchProcessing", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TableOutput.Warning", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        String connectionName = this.variables.resolve(this.wConnection.getText());
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"TableOutputDialog.Log.LookingAtConnection", (String[])new String[]{databaseMeta.toString()}));
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableOutputDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)ERROR_TITLE, (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void sql() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        try {
            String text;
            int idx;
            TableOutputMeta info = new TableOutputMeta();
            this.getInfo(info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (info.isTableNameInField() && !info.isTableNameInTable() && info.getTableNameField().length() > 0 && (idx = prev.indexOfValue(info.getTableNameField())) >= 0) {
                prev.removeValueMeta(idx);
            }
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (info.isSpecifyFields()) {
                RowMeta prevNew = new RowMeta();
                for (int i = 0; i < info.getFields().size(); ++i) {
                    TableOutputField tf = info.getFields().get(i);
                    IValueMeta insValue = prev.searchValueMeta(tf.getFieldStream());
                    if (insValue == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToFindField.Message", (String[])new String[]{tf.getFieldStream()}));
                    }
                    IValueMeta insertValue = insValue.clone();
                    insertValue.setName(tf.getFieldDatabase());
                    prevNew.addValueMeta(insertValue);
                }
                prev = prevNew;
            }
            boolean autoInc = false;
            String pk = null;
            if (info.isReturningGeneratedKeys() && !Utils.isEmpty((CharSequence)info.getGeneratedKeyField())) {
                ValueMetaInteger valueMeta = new ValueMetaInteger(info.getGeneratedKeyField());
                valueMeta.setLength(15);
                prev.addValueMeta(0, (IValueMeta)valueMeta);
                autoInc = true;
                pk = info.getGeneratedKeyField();
            }
            if (TableOutputDialog.isValidRowMeta(prev)) {
                SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, pk, autoInc, pk);
                if (!sql.hasError()) {
                    if (sql.hasSql()) {
                        SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                        sqledit.open();
                    } else {
                        String message = BaseMessages.getString(PKG, (String)"TableOutputDialog.NoSQL.DialogMessage", (String[])new String[0]);
                        String text2 = BaseMessages.getString(PKG, (String)"TableOutputDialog.NoSQL.DialogTitle", (String[])new String[0]);
                        this.showMessage(this.shell, 34, message, text2);
                    }
                } else {
                    text = BaseMessages.getString(PKG, (String)ERROR_TITLE, (String[])new String[0]);
                    this.showMessage(this.shell, 33, sql.getError(), text);
                }
            } else {
                String message = BaseMessages.getString(PKG, (String)"TableOutputDialog.NoSQL.EmptyCSVFields", (String[])new String[0]);
                text = BaseMessages.getString(PKG, (String)"TableOutputDialog.NoSQL.DialogTitle", (String[])new String[0]);
                this.showMessage(this.shell, 33, message, text);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void showMessage(Shell shell, int style, String message, String text) {
        MessageBox mb = new MessageBox(shell, style);
        mb.setMessage(message);
        mb.setText(text);
        mb.open();
    }

    private static boolean isValidRowMeta(IRowMeta rowMeta) {
        for (IValueMeta value : rowMeta.getValueMetaList()) {
            String name = value.getName();
            if (name != null && !name.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

