/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseDataUpdater;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

final class DelegatedInputStream
extends ClickHouseInputStream {
    private final ClickHouseInputStream input;

    @Override
    protected ClickHouseByteBuffer getBuffer() {
        return this.input.getBuffer();
    }

    @Override
    protected ClickHouseByteBuffer nextBuffer() throws IOException {
        return this.input.nextBuffer();
    }

    DelegatedInputStream(ClickHousePassThruStream stream, ClickHouseInputStream input, OutputStream copyTo, Runnable postCloseAction) {
        super(stream, copyTo, postCloseAction);
        this.input = ClickHouseChecker.nonNull(input, "InputStream");
    }

    DelegatedInputStream(ClickHouseDataConfig config, ClickHouseWriter writer) {
        super(null, null, null);
        if (writer == null) {
            throw new IllegalArgumentException("Non-null writer is required");
        }
        ClickHousePipedOutputStream stream = config != null ? ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config, writer) : ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(8192, 0, 30000, writer);
        this.input = stream.getInputStream();
    }

    DelegatedInputStream(ClickHouseWriter writer) {
        this(null, writer);
    }

    @Override
    public int peek() throws IOException {
        return this.input.peek();
    }

    @Override
    public long pipe(ClickHouseOutputStream output) throws IOException {
        return this.input.pipe(output);
    }

    @Override
    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    @Override
    public ClickHouseByteBuffer readBufferUntil(byte[] separator) throws IOException {
        return this.input.readBufferUntil(separator);
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        return this.input.readCustom(reader);
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.input.close();
        }
        finally {
            super.close();
        }
    }

    @Override
    public ClickHouseFile getUnderlyingFile() {
        return this.input.getUnderlyingFile();
    }

    @Override
    public ClickHousePassThruStream getUnderlyingStream() {
        return this.input.getUnderlyingStream();
    }

    @Override
    public boolean isClosed() {
        return this.input.isClosed();
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.input.skip(n);
    }

    @Override
    public Iterator<ClickHouseByteBuffer> iterator() {
        return this.input.iterator();
    }
}

