/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.implcore.stats;

import com.clickhouse.client.internal.google.common.annotations.VisibleForTesting;
import com.clickhouse.client.internal.google.common.collect.ImmutableMap;
import com.clickhouse.client.internal.google.common.collect.Maps;
import com.clickhouse.client.internal.opencensus.common.Function;
import com.clickhouse.client.internal.opencensus.common.Functions;
import com.clickhouse.client.internal.opencensus.implcore.stats.MutableAggregation;
import com.clickhouse.client.internal.opencensus.implcore.tags.TagMapImpl;
import com.clickhouse.client.internal.opencensus.implcore.tags.TagValueWithMetadata;
import com.clickhouse.client.internal.opencensus.stats.Aggregation;
import com.clickhouse.client.internal.opencensus.stats.AggregationData;
import com.clickhouse.client.internal.opencensus.stats.Measure;
import com.clickhouse.client.internal.opencensus.stats.Measurement;
import com.clickhouse.client.internal.opencensus.tags.InternalUtils;
import com.clickhouse.client.internal.opencensus.tags.Tag;
import com.clickhouse.client.internal.opencensus.tags.TagContext;
import com.clickhouse.client.internal.opencensus.tags.TagKey;
import com.clickhouse.client.internal.opencensus.tags.TagValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class RecordUtils {
    @Nullable
    @VisibleForTesting
    static final TagValue UNKNOWN_TAG_VALUE = null;
    @VisibleForTesting
    static final TagKey RPC_STATUS = TagKey.create("canonical_status");
    @VisibleForTesting
    static final TagKey RPC_METHOD = TagKey.create("method");
    @VisibleForTesting
    static final TagKey GRPC_CLIENT_STATUS = TagKey.create("grpc_client_status");
    @VisibleForTesting
    static final TagKey GRPC_CLIENT_METHOD = TagKey.create("grpc_client_method");
    @VisibleForTesting
    static final TagKey GRPC_SERVER_STATUS = TagKey.create("grpc_server_status");
    @VisibleForTesting
    static final TagKey GRPC_SERVER_METHOD = TagKey.create("grpc_server_method");
    private static final Map<TagKey, TagKey[]> RPC_TAG_MAPPINGS = ImmutableMap.builder().put(RPC_STATUS, new TagKey[]{GRPC_CLIENT_STATUS, GRPC_SERVER_STATUS}).put(RPC_METHOD, new TagKey[]{GRPC_CLIENT_METHOD, GRPC_SERVER_METHOD}).build();
    private static final Function<Measurement.MeasurementDouble, Double> GET_VALUE_FROM_MEASUREMENT_DOUBLE = new Function<Measurement.MeasurementDouble, Double>(){

        @Override
        public Double apply(Measurement.MeasurementDouble arg) {
            return arg.getValue();
        }
    };
    private static final Function<Measurement.MeasurementLong, Double> GET_VALUE_FROM_MEASUREMENT_LONG = new Function<Measurement.MeasurementLong, Double>(){

        @Override
        public Double apply(Measurement.MeasurementLong arg) {
            return arg.getValue();
        }
    };

    static Map<TagKey, TagValueWithMetadata> getTagMap(TagContext ctx) {
        if (ctx instanceof TagMapImpl) {
            return ((TagMapImpl)ctx).getTags();
        }
        HashMap<TagKey, TagValueWithMetadata> tags = Maps.newHashMap();
        Iterator<Tag> i = InternalUtils.getTags(ctx);
        while (i.hasNext()) {
            Tag tag = i.next();
            tags.put(tag.getKey(), TagValueWithMetadata.create(tag.getValue(), tag.getTagMetadata()));
        }
        return tags;
    }

    @VisibleForTesting
    static List<TagValue> getTagValues(Map<? extends TagKey, TagValueWithMetadata> tags, List<? extends TagKey> columns) {
        ArrayList<TagValue> tagValues = new ArrayList<TagValue>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            TagKey tagKey = columns.get(i);
            if (!tags.containsKey(tagKey)) {
                TagValue tagValue = UNKNOWN_TAG_VALUE;
                TagKey[] newKeys = RPC_TAG_MAPPINGS.get(tagKey);
                if (newKeys != null) {
                    tagValue = RecordUtils.getTagValueForDeprecatedRpcTag(tags, newKeys);
                }
                tagValues.add(tagValue);
                continue;
            }
            tagValues.add(tags.get(tagKey).getTagValue());
        }
        return tagValues;
    }

    @Nullable
    private static TagValue getTagValueForDeprecatedRpcTag(Map<? extends TagKey, TagValueWithMetadata> tags, TagKey[] newKeys) {
        for (TagKey newKey : newKeys) {
            TagValueWithMetadata valueWithMetadata = tags.get(newKey);
            if (valueWithMetadata == null) continue;
            return valueWithMetadata.getTagValue();
        }
        return UNKNOWN_TAG_VALUE;
    }

    @VisibleForTesting
    static MutableAggregation createMutableAggregation(Aggregation aggregation, final Measure measure) {
        return aggregation.match(new Function<Aggregation.Sum, MutableAggregation>(){

            @Override
            public MutableAggregation apply(Aggregation.Sum arg) {
                return measure.match(CreateMutableSumDouble.INSTANCE, CreateMutableSumLong.INSTANCE, Functions.throwAssertionError());
            }
        }, CreateMutableCount.INSTANCE, CreateMutableDistribution.INSTANCE, new Function<Aggregation.LastValue, MutableAggregation>(){

            @Override
            public MutableAggregation apply(Aggregation.LastValue arg) {
                return measure.match(CreateMutableLastValueDouble.INSTANCE, CreateMutableLastValueLong.INSTANCE, Functions.throwAssertionError());
            }
        }, AggregationDefaultFunction.INSTANCE);
    }

    static <T> Map<T, AggregationData> createAggregationMap(Map<T, MutableAggregation> tagValueAggregationMap, Measure measure) {
        HashMap<T, AggregationData> map = Maps.newHashMap();
        for (Map.Entry<T, MutableAggregation> entry : tagValueAggregationMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().toAggregationData());
        }
        return map;
    }

    static double getDoubleValueFromMeasurement(Measurement measurement) {
        return measurement.match(GET_VALUE_FROM_MEASUREMENT_DOUBLE, GET_VALUE_FROM_MEASUREMENT_LONG, Functions.throwAssertionError());
    }

    private RecordUtils() {
    }

    private static final class CreateMutableLastValueLong
    implements Function<Measure.MeasureLong, MutableAggregation> {
        private static final CreateMutableLastValueLong INSTANCE = new CreateMutableLastValueLong();

        private CreateMutableLastValueLong() {
        }

        @Override
        public MutableAggregation apply(Measure.MeasureLong arg) {
            return MutableAggregation.MutableLastValueLong.create();
        }
    }

    private static final class CreateMutableLastValueDouble
    implements Function<Measure.MeasureDouble, MutableAggregation> {
        private static final CreateMutableLastValueDouble INSTANCE = new CreateMutableLastValueDouble();

        private CreateMutableLastValueDouble() {
        }

        @Override
        public MutableAggregation apply(Measure.MeasureDouble arg) {
            return MutableAggregation.MutableLastValueDouble.create();
        }
    }

    private static final class CreateMutableDistribution
    implements Function<Aggregation.Distribution, MutableAggregation> {
        private static final CreateMutableDistribution INSTANCE = new CreateMutableDistribution();

        private CreateMutableDistribution() {
        }

        @Override
        public MutableAggregation apply(Aggregation.Distribution arg) {
            return MutableAggregation.MutableDistribution.create(arg.getBucketBoundaries());
        }
    }

    private static final class AggregationDefaultFunction
    implements Function<Aggregation, MutableAggregation> {
        private static final AggregationDefaultFunction INSTANCE = new AggregationDefaultFunction();

        private AggregationDefaultFunction() {
        }

        @Override
        public MutableAggregation apply(Aggregation arg) {
            if (arg instanceof Aggregation.Mean) {
                return MutableAggregation.MutableMean.create();
            }
            throw new IllegalArgumentException("Unknown Aggregation.");
        }
    }

    private static final class CreateMutableCount
    implements Function<Aggregation.Count, MutableAggregation> {
        private static final CreateMutableCount INSTANCE = new CreateMutableCount();

        private CreateMutableCount() {
        }

        @Override
        public MutableAggregation apply(Aggregation.Count arg) {
            return MutableAggregation.MutableCount.create();
        }
    }

    private static final class CreateMutableSumLong
    implements Function<Measure.MeasureLong, MutableAggregation> {
        private static final CreateMutableSumLong INSTANCE = new CreateMutableSumLong();

        private CreateMutableSumLong() {
        }

        @Override
        public MutableAggregation apply(Measure.MeasureLong arg) {
            return MutableAggregation.MutableSumLong.create();
        }
    }

    private static final class CreateMutableSumDouble
    implements Function<Measure.MeasureDouble, MutableAggregation> {
        private static final CreateMutableSumDouble INSTANCE = new CreateMutableSumDouble();

        private CreateMutableSumDouble() {
        }

        @Override
        public MutableAggregation apply(Measure.MeasureDouble arg) {
            return MutableAggregation.MutableSumDouble.create();
        }
    }
}

