/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.net.InetSocketAddress;

public class Address {
    private final String host;
    private final int port;

    public static Address from(String hostAndPort) {
        int port;
        String host;
        int colon = hostAndPort.indexOf(58);
        if (colon >= 0) {
            host = hostAndPort.substring(0, colon);
            port = Integer.parseInt(hostAndPort.substring(colon + 1));
        } else {
            host = hostAndPort;
            port = 0;
        }
        return new Address(host, port);
    }

    public Address(String host, int port) {
        this.host = host.trim();
        this.port = port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)obj;
        if (!this.host.equals(that.host)) {
            return false;
        }
        return this.port == that.port;
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress toSocketAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

