/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.columnexists;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.columnexists.ColumnExistsMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ColumnExistsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ColumnExistsDialog.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private Label wlTableName;
    private CCombo wTableName;
    private Text wResult;
    private Label wlTablenameText;
    private TextVar wTablenameText;
    private CCombo wColumnName;
    private Button wTablenameInField;
    private TextVar wSchemaname;
    private final ColumnExistsMeta input;

    public ColumnExistsDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ColumnExistsMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        ColumnExistsDialog columnExistsDialog = this;
        int margin = columnExistsDialog.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getDatabaseName(), this.variables);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, databaseMeta, lsMod);
        Label wlSchemaname = new Label((Composite)this.shell, 131072);
        wlSchemaname.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.Schemaname.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchemaname);
        FormData fdlSchemaname = new FormData();
        fdlSchemaname.left = new FormAttachment(0, 0);
        fdlSchemaname.right = new FormAttachment(middle, -margin);
        fdlSchemaname.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchemaname.setLayoutData((Object)fdlSchemaname);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnExistsDialog.this.getSchemaNames();
            }
        });
        this.wSchemaname = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchemaname);
        this.wSchemaname.setToolTipText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.Schemaname.Tooltip", (String[])new String[0]));
        this.wSchemaname.addModifyListener(lsMod);
        FormData fdSchemaname = new FormData();
        fdSchemaname.left = new FormAttachment(middle, 0);
        fdSchemaname.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchemaname.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchemaname.setLayoutData((Object)fdSchemaname);
        this.wlTablenameText = new Label((Composite)this.shell, 131072);
        this.wlTablenameText.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TablenameTextField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTablenameText);
        FormData fdlTablenameText = new FormData();
        fdlTablenameText.left = new FormAttachment(0, 0);
        fdlTablenameText.right = new FormAttachment(middle, -margin);
        fdlTablenameText.top = new FormAttachment((Control)wbSchema, margin);
        this.wlTablenameText.setLayoutData((Object)fdlTablenameText);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnExistsDialog.this.getTableName();
            }
        });
        this.wTablenameText = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wTablenameText.setToolTipText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TablenameTextField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTablenameText);
        this.wTablenameText.addModifyListener(lsMod);
        FormData fdTablenameText = new FormData();
        fdTablenameText.left = new FormAttachment(middle, 0);
        fdTablenameText.top = new FormAttachment((Control)wbSchema, margin);
        fdTablenameText.right = new FormAttachment((Control)wbTable, -margin);
        this.wTablenameText.setLayoutData((Object)fdTablenameText);
        Label wlTablenameInField = new Label((Composite)this.shell, 131072);
        wlTablenameInField.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TablenameInfield.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTablenameInField);
        FormData fdlTablenameInField = new FormData();
        fdlTablenameInField.left = new FormAttachment(0, 0);
        fdlTablenameInField.top = new FormAttachment((Control)this.wTablenameText, margin);
        fdlTablenameInField.right = new FormAttachment(middle, -margin);
        wlTablenameInField.setLayoutData((Object)fdlTablenameInField);
        this.wTablenameInField = new Button((Composite)this.shell, 32);
        this.wTablenameInField.setToolTipText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TablenameInfield.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTablenameInField);
        FormData fdTablenameInField = new FormData();
        fdTablenameInField.left = new FormAttachment(middle, 0);
        fdTablenameInField.top = new FormAttachment((Control)wlTablenameInField, 0, 0x1000000);
        fdTablenameInField.right = new FormAttachment(100, 0);
        this.wTablenameInField.setLayoutData((Object)fdTablenameInField);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ColumnExistsDialog.this.input.setChanged();
                ColumnExistsDialog.this.activeTablenameInField();
            }
        };
        this.wTablenameInField.addSelectionListener((SelectionListener)lsSelR);
        this.wlTableName = new Label((Composite)this.shell, 131072);
        this.wlTableName.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TableName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTableName);
        FormData fdlTableName = new FormData();
        fdlTableName.left = new FormAttachment(0, 0);
        fdlTableName.right = new FormAttachment(middle, -margin);
        fdlTableName.top = new FormAttachment((Control)this.wTablenameInField, margin * 2);
        this.wlTableName.setLayoutData((Object)fdlTableName);
        this.wTableName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wTableName);
        this.wTableName.addModifyListener(lsMod);
        FormData fdTableName = new FormData();
        fdTableName.left = new FormAttachment(middle, 0);
        fdTableName.top = new FormAttachment((Control)this.wTablenameInField, margin * 2);
        fdTableName.right = new FormAttachment(100, -margin);
        this.wTableName.setLayoutData((Object)fdTableName);
        this.wTableName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ColumnExistsDialog.this.shell.getDisplay(), 1);
                ColumnExistsDialog.this.shell.setCursor(busy);
                ColumnExistsDialog.this.get();
                ColumnExistsDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlColumnName = new Label((Composite)this.shell, 131072);
        wlColumnName.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.ColumnName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlColumnName);
        FormData fdlColumnName = new FormData();
        fdlColumnName.left = new FormAttachment(0, 0);
        fdlColumnName.right = new FormAttachment(middle, -margin);
        fdlColumnName.top = new FormAttachment((Control)this.wTableName, margin);
        wlColumnName.setLayoutData((Object)fdlColumnName);
        this.wColumnName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wColumnName);
        this.wColumnName.addModifyListener(lsMod);
        FormData fdColumnName = new FormData();
        fdColumnName.left = new FormAttachment(middle, 0);
        fdColumnName.top = new FormAttachment((Control)this.wTableName, margin);
        fdColumnName.right = new FormAttachment(100, -margin);
        this.wColumnName.setLayoutData((Object)fdColumnName);
        this.wColumnName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ColumnExistsDialog.this.shell.getDisplay(), 1);
                ColumnExistsDialog.this.shell.setCursor(busy);
                ColumnExistsDialog.this.get();
                ColumnExistsDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlResult = new Label((Composite)this.shell, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.ResultField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wColumnName, margin * 2);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new Text((Composite)this.shell, 18436);
        this.wResult.setToolTipText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.ResultField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wColumnName, margin * 2);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wResult);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.activeTablenameInField();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void activeTablenameInField() {
        this.wlTableName.setEnabled(this.wTablenameInField.getSelection());
        this.wTableName.setEnabled(this.wTablenameInField.getSelection());
        this.wTablenameText.setEnabled(!this.wTablenameInField.getSelection());
        this.wlTablenameText.setEnabled(!this.wTablenameInField.getSelection());
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getDatabaseName() != null) {
            this.wConnection.setText(this.input.getDatabaseName());
        }
        if (this.input.getSchemaname() != null) {
            this.wSchemaname.setText(this.input.getSchemaname());
        }
        if (this.input.getTableName() != null) {
            this.wTablenameText.setText(this.input.getTableName());
        }
        this.wTablenameInField.setSelection(this.input.isTablenameInfield());
        if (this.input.getTablenamefield() != null) {
            this.wTableName.setText(this.input.getTablenamefield());
        }
        if (this.input.getColumnnamefield() != null) {
            this.wColumnName.setText(this.input.getColumnnamefield());
        }
        if (this.input.getResultfieldname() != null) {
            this.wResult.setText(this.input.getResultfieldname());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setDatabaseName(this.wConnection.getText());
        this.input.setSchemaname(this.wSchemaname.getText());
        this.input.setTableName(this.wTablenameText.getText());
        this.input.setTablenameInfield(this.wTablenameInField.getSelection());
        this.input.setTablenamefield(this.wTableName.getText());
        this.input.setColumnnamefield(this.wColumnName.getText());
        this.input.setResultfieldname(this.wResult.getText());
        this.transformName = this.wTransformName.getText();
        if (this.input.getDatabaseName() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        try {
            String columnName = this.wColumnName.getText();
            String tableName = this.wTableName.getText();
            this.wColumnName.removeAll();
            this.wTableName.removeAll();
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                r.getFieldNames();
                for (int i = 0; i < r.getFieldNames().length; ++i) {
                    this.wTableName.add(r.getFieldNames()[i]);
                    this.wColumnName.add(r.getFieldNames()[i]);
                }
            }
            this.wColumnName.setText(columnName);
            this.wTableName.setText(tableName);
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ColumnExistsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ColumnExistsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchemaname.getText(), this.wTablenameText.getText());
            if (std.open()) {
                this.wSchemaname.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTablenameText.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void getSchemaNames() {
        if (this.wSchemaname.isDisposed()) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Message", (String[])new String[0]));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchemaname.setText(Const.NVL((String)d, (String)""));
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.ConnectionError", (String[])new String[0]), e);
            }
        }
    }
}

