/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public class BackwardsCompatibleSerializerSnapshot<T>
implements TypeSerializerSnapshot<T> {
    @Nonnull
    private TypeSerializer<T> serializerInstance;

    public BackwardsCompatibleSerializerSnapshot(TypeSerializer<T> serializerInstance) {
        this.serializerInstance = Preconditions.checkNotNull(serializerInstance);
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
        throw new UnsupportedOperationException("This is a dummy config snapshot used only for backwards compatibility.");
    }

    @Override
    public void readSnapshot(int version, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        throw new UnsupportedOperationException("This is a dummy config snapshot used only for backwards compatibility.");
    }

    @Override
    public int getCurrentVersion() {
        throw new UnsupportedOperationException("This is a dummy config snapshot used only for backwards compatibility.");
    }

    @Override
    public TypeSerializer<T> restoreSerializer() {
        return this.serializerInstance;
    }

    @Override
    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
        return TypeSerializerSchemaCompatibility.compatibleAsIs();
    }

    public int hashCode() {
        return this.serializerInstance.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackwardsCompatibleSerializerSnapshot that = (BackwardsCompatibleSerializerSnapshot)o;
        return that.serializerInstance.equals(this.serializerInstance);
    }
}

