/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.switchcase;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.switchcase.SwitchCase;
import org.apache.hop.pipeline.transforms.switchcase.SwitchCaseData;
import org.apache.hop.pipeline.transforms.switchcase.SwitchCaseTarget;

@Transform(id="SwitchCase", image="switchcase.svg", name="i18n::SwitchCase.Name", description="i18n::SwitchCase.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", keywords={"i18n::SwitchCaseMeta.keyword"}, documentationUrl="/pipeline/transforms/switchcase.html")
public class SwitchCaseMeta
extends BaseTransformMeta<SwitchCase, SwitchCaseData> {
    private static final Class<?> PKG = SwitchCaseMeta.class;
    @HopMetadataProperty(key="fieldname", injectionKey="FIELD_NAME", injectionKeyDescription="SwitchCaseMeta.Injection.FIELD_NAME")
    private String fieldName;
    @HopMetadataProperty(key="case_value_type", injectionKey="VALUE_TYPE", injectionKeyDescription="SwitchCaseMeta.Injection.VALUE_TYPE")
    private String caseValueType;
    @HopMetadataProperty(key="case_value_format", injectionKey="VALUE_FORMAT", injectionKeyDescription="SwitchCaseMeta.Injection.VALUE_FORMAT")
    private String caseValueFormat;
    @HopMetadataProperty(key="case_value_decimal", injectionKey="VALUE_DECIMAL", injectionKeyDescription="SwitchCaseMeta.Injection.VALUE_DECIMAL")
    private String caseValueDecimal;
    @HopMetadataProperty(key="case_value_group", injectionKey="VALUE_GROUP", injectionKeyDescription="SwitchCaseMeta.Injection.VALUE_GROUP")
    private String caseValueGroup;
    @HopMetadataProperty(groupKey="cases", key="case")
    private List<SwitchCaseTarget> caseTargets = new ArrayList<SwitchCaseTarget>();
    @HopMetadataProperty(key="default_target_transform", injectionKey="DEFAULT_TARGET_TRANSFORM_NAME", injectionKeyDescription="SwitchCaseMeta.Injection.DEFAULT_TARGET_TRANSFORM_NAME")
    private String defaultTargetTransformName;
    @HopMetadataProperty(key="use_contains", injectionKey="CONTAINS", injectionKeyDescription="SwitchCaseMeta.Injection.CONTAINS")
    private boolean usingContains;
    private static IStream newDefaultStream = new Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.Default.Description", (String[])new String[0]), StreamIcon.TARGET, null);
    private static IStream newCaseTargetStream = new Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.NewCaseTarget.Description", (String[])new String[0]), StreamIcon.TARGET, null);

    public SwitchCaseMeta() {
    }

    public SwitchCaseMeta(SwitchCaseMeta m) {
        this();
        this.fieldName = m.fieldName;
        this.caseValueType = m.caseValueType;
        this.caseValueFormat = m.caseValueFormat;
        this.caseValueDecimal = m.caseValueDecimal;
        this.caseValueGroup = m.caseValueGroup;
        this.defaultTargetTransformName = m.defaultTargetTransformName;
        this.usingContains = m.usingContains;
        for (SwitchCaseTarget target : m.caseTargets) {
            this.caseTargets.add(new SwitchCaseTarget(target));
        }
    }

    public SwitchCaseMeta clone() {
        return new SwitchCaseMeta(this);
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        for (SwitchCaseTarget target : this.caseTargets) {
            TransformMeta check = pipelineMeta.findTransform(target.getCaseTargetTransformName());
            if (check != null) continue;
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.TargetTransformInvalid", (String[])new String[]{"false", target.getCaseTargetTransformName()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = Utils.isEmpty((CharSequence)this.fieldName) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.NoFieldSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.FieldSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getCaseValueFormat() {
        return this.caseValueFormat;
    }

    public void setCaseValueFormat(String caseValueFormat) {
        this.caseValueFormat = caseValueFormat;
    }

    public String getCaseValueDecimal() {
        return this.caseValueDecimal;
    }

    public void setCaseValueDecimal(String caseValueDecimal) {
        this.caseValueDecimal = caseValueDecimal;
    }

    public String getCaseValueGroup() {
        return this.caseValueGroup;
    }

    public void setCaseValueGroup(String caseValueGroup) {
        this.caseValueGroup = caseValueGroup;
    }

    public String getCaseValueType() {
        return this.caseValueType;
    }

    public void setCaseValueType(String caseValueType) {
        this.caseValueType = caseValueType;
    }

    public String getDefaultTargetTransformName() {
        return this.defaultTargetTransformName;
    }

    public void setDefaultTargetTransformName(String defaultTargetTransformName) {
        this.defaultTargetTransformName = defaultTargetTransformName;
    }

    public boolean isUsingContains() {
        return this.usingContains;
    }

    public void setUsingContains(boolean isContains) {
        this.usingContains = isContains;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, false, false, false, false, true);
            for (SwitchCaseTarget target : this.caseTargets) {
                Stream stream = new Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.CaseTarget.Description", (String[])new String[]{Const.NVL((String)target.getCaseValue(), (String)"")}), StreamIcon.TARGET, target.getCaseTargetTransformName());
                ioMeta.addStream((IStream)stream);
            }
            if (StringUtils.isNotEmpty((String)this.defaultTargetTransformName)) {
                ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.Default.Description", (String[])new String[0]), StreamIcon.TARGET, this.defaultTargetTransformName));
            }
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List targetStreams = this.getTransformIOMeta().getTargetStreams();
        int index = 0;
        for (SwitchCaseTarget target : this.caseTargets) {
            IStream stream = (IStream)targetStreams.get(index++);
            TransformMeta transformMeta = TransformMeta.findTransform(transforms, (String)target.getCaseTargetTransformName());
            stream.setTransformMeta(transformMeta);
        }
        if (StringUtils.isNotEmpty((String)this.defaultTargetTransformName)) {
            IStream stream = (IStream)targetStreams.get(index);
            TransformMeta transformMeta = TransformMeta.findTransform(transforms, (String)this.defaultTargetTransformName);
            stream.setTransformMeta(transformMeta);
        }
    }

    public void convertIOMetaToTransformNames() {
    }

    public List<IStream> getOptionalStreams() {
        ArrayList<IStream> list = new ArrayList<IStream>();
        if (StringUtils.isEmpty((String)this.defaultTargetTransformName)) {
            list.add(newDefaultStream);
        }
        list.add(newCaseTargetStream);
        return list;
    }

    public void handleStreamSelection(IStream stream) {
        if (stream == newDefaultStream) {
            this.defaultTargetTransformName = stream.getTransformMeta().getName();
            Stream newStream = new Stream(IStream.StreamType.TARGET, stream.getTransformMeta(), BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.Default.Description", (String[])new String[0]), StreamIcon.TARGET, stream.getTransformMeta().getName());
            this.getTransformIOMeta().addStream((IStream)newStream);
        } else if (stream == newCaseTargetStream) {
            SwitchCaseTarget target = new SwitchCaseTarget();
            target.setCaseTargetTransformName(stream.getTransformMeta().getName());
            target.setCaseValue(stream.getTransformMeta().getName());
            this.caseTargets.add(target);
            Stream newStream = new Stream(IStream.StreamType.TARGET, stream.getTransformMeta(), BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.CaseTarget.Description", (String[])new String[]{Const.NVL((String)target.getCaseValue(), (String)"")}), StreamIcon.TARGET, stream.getTransformMeta().getName());
            this.getTransformIOMeta().addStream((IStream)newStream);
        } else {
            List targetStreams = this.getTransformIOMeta().getTargetStreams();
            for (int i = 0; i < targetStreams.size(); ++i) {
                if (stream != targetStreams.get(i)) continue;
                if (i < this.caseTargets.size()) {
                    this.caseTargets.get(i).setCaseTargetTransformName(stream.getTransformMeta().getName());
                    continue;
                }
                this.defaultTargetTransformName = stream.getTransformMeta().getName();
            }
        }
    }

    public List<SwitchCaseTarget> getCaseTargets() {
        return this.caseTargets;
    }

    public void setCaseTargets(List<SwitchCaseTarget> caseTargets) {
        this.caseTargets = caseTargets;
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }
}

