/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.checksum;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.checksum.CheckSumMeta;
import org.apache.hop.pipeline.transforms.checksum.Field;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CheckSumDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = CheckSumDialog.class;
    private final CheckSumMeta input;
    private CCombo wType;
    private TableView wFields;
    private Text wResult;
    private ColumnInfo[] colinf;
    private final List<String> inputFields = new ArrayList<String>();
    private Label wlResultType;
    private CCombo wResultType;

    public CheckSumDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (CheckSumMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        CheckSumDialog checkSumDialog = this;
        int margin = checkSumDialog.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlType = new Label((Composite)this.shell, 131072);
        wlType.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.Type.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlType);
        FormData fdlType = new FormData();
        fdlType.left = new FormAttachment(0, 0);
        fdlType.right = new FormAttachment(middle, -margin);
        fdlType.top = new FormAttachment((Control)this.wTransformName, margin);
        wlType.setLayoutData((Object)fdlType);
        this.wType = new CCombo((Composite)this.shell, 2060);
        this.wType.setItems(CheckSumMeta.CheckSumType.getDescriptions());
        this.wType.select(0);
        PropsUi.setLook((Widget)this.wType);
        FormData fdType = new FormData();
        fdType.left = new FormAttachment(middle, 0);
        fdType.top = new FormAttachment((Control)this.wTransformName, margin);
        fdType.right = new FormAttachment(100, 0);
        this.wType.setLayoutData((Object)fdType);
        this.wType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckSumDialog.this.input.setChanged();
                CheckSumDialog.this.activeResultType();
            }
        });
        this.wlResultType = new Label((Composite)this.shell, 131072);
        this.wlResultType.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.ResultType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlResultType);
        FormData fdlResultType = new FormData();
        fdlResultType.left = new FormAttachment(0, 0);
        fdlResultType.right = new FormAttachment(middle, -margin);
        fdlResultType.top = new FormAttachment((Control)this.wType, 2 * margin);
        this.wlResultType.setLayoutData((Object)fdlResultType);
        this.wResultType = new CCombo((Composite)this.shell, 2060);
        this.wResultType.setItems(CheckSumMeta.ResultType.getDescriptions());
        this.wResultType.select(0);
        PropsUi.setLook((Widget)this.wResultType);
        FormData fdResultType = new FormData();
        fdResultType.left = new FormAttachment(middle, 0);
        fdResultType.top = new FormAttachment((Control)this.wType, 2 * margin);
        fdResultType.right = new FormAttachment(100, 0);
        this.wResultType.setLayoutData((Object)fdResultType);
        this.wResultType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckSumDialog.this.input.setChanged();
            }
        });
        Label wlResult = new Label((Composite)this.shell, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.Result.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wResultType, margin * 2);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wResultType, margin * 2);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wResult, margin);
        wlFields.setLayoutData((Object)fdlFields);
        boolean nrCols = true;
        int nrFields = this.input.getFields().size();
        this.colinf = new ColumnInfo[1];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CheckSumDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, nrFields, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.wGet.addListener(13, e -> this.get());
        this.getData();
        this.activeResultType();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void activeResultType() {
        int currentType = this.wType.getSelectionIndex();
        boolean active = currentType == 2 || currentType == 3 || currentType == 4 || currentType == 5 || currentType == 6;
        this.wlResultType.setEnabled(active);
        this.wResultType.setEnabled(active);
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener insertListener = (tableItem, v) -> {
                    tableItem.setText(2, BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]));
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)insertListener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData() {
        this.wType.setText(this.input.getCheckSumType().getDescription());
        this.wResult.setText(Const.NVL((String)this.input.getResultFieldName(), (String)""));
        this.wResultType.setText(this.input.getResultType().getDescription());
        Table table = this.wFields.table;
        if (!this.input.getFields().isEmpty()) {
            table.removeAll();
        }
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            Field field = this.input.getFields().get(i);
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, Const.NVL((String)field.getName(), (String)""));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setCheckSumType(CheckSumMeta.CheckSumType.getTypeFromDescription(this.wType.getText()));
        this.input.setResultFieldName(this.wResult.getText());
        this.input.setResultType(CheckSumMeta.ResultType.getTypeFromDescription(this.wResultType.getText()));
        this.input.getFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            this.input.getFields().add(new Field(item.getText(1)));
        }
        this.dispose();
    }
}

