/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sql;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="SQL", name="i18n::ActionSQL.Name", description="i18n::ActionSQL.Description", image="sql.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Scripting", keywords={"i18n::ActionSql.keyword"}, documentationUrl="/workflow/actions/sql.html")
public class ActionSql
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSql.class;
    @HopMetadataProperty(key="sql")
    private String sql = null;
    @HopMetadataProperty(key="connection")
    private String connection = null;
    @HopMetadataProperty(key="useVariableSubstitution")
    private boolean useVariableSubstitution = false;
    @HopMetadataProperty(key="sqlfromfile")
    private boolean sqlFromFile = false;
    @HopMetadataProperty(key="sqlfilename")
    private String sqlFilename;
    @HopMetadataProperty(key="sendOneStatement")
    private boolean sendOneStatement = false;

    public ActionSql(String n) {
        super(n, "");
    }

    public ActionSql() {
        this("");
    }

    public Object clone() {
        ActionSql je = (ActionSql)super.clone();
        return je;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public String getSqlFilename() {
        return this.sqlFilename;
    }

    public void setSqlFilename(String sqlfilename) {
        this.sqlFilename = sqlfilename;
    }

    public boolean isUseVariableSubstitution() {
        return this.useVariableSubstitution;
    }

    public void setUseVariableSubstitution(boolean subs) {
        this.useVariableSubstitution = subs;
    }

    public void setSqlFromFile(boolean sqlfromfilein) {
        this.sqlFromFile = sqlfromfilein;
    }

    public boolean isSqlFromFile() {
        return this.sqlFromFile;
    }

    public boolean isSendOneStatement() {
        return this.sendOneStatement;
    }

    public void setSendOneStatement(boolean sendOneStatementin) {
        this.sendOneStatement = sendOneStatementin;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Result execute(Result previousResult, int nr) {
        result = previousResult;
        databaseMeta = this.parentWorkflowMeta.findDatabase(this.connection, this.getVariables());
        if (databaseMeta != null) {
            sqlFile = null;
            try {
                db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
                try {
                    block35: {
                        theSql = null;
                        db.connect();
                        if (this.sqlFromFile) {
                            if (this.sqlFilename == null) {
                                throw new HopDatabaseException(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.NoSQLFileSpecified", (String[])new String[0]));
                            }
                            try {
                                realfilename = this.resolve(this.sqlFilename);
                                sqlFile = HopVfs.getFileObject((String)realfilename);
                                if (!sqlFile.exists()) {
                                    this.logError(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.SQLFileNotExist", (String[])new String[]{realfilename}));
                                    throw new HopDatabaseException(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.SQLFileNotExist", (String[])new String[]{realfilename}));
                                }
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.SQLFileExists", (String[])new String[]{realfilename}));
                                }
                                inputStream = HopVfs.getInputStream((FileObject)sqlFile);
                                try {
                                    inputStreamReader = new InputStreamReader(new BufferedInputStream(inputStream, 500));
                                    lineSB = new StringBuilder(256);
                                    lineSB.setLength(0);
                                    buff = new BufferedReader(inputStreamReader);
                                    sLine = null;
                                    theSql = Const.CR;
                                    while ((sLine = buff.readLine()) != null) {
                                        if (Utils.isEmpty((CharSequence)sLine)) {
                                            theSql = (String)theSql + Const.CR;
                                            continue;
                                        }
                                        theSql = (String)theSql + Const.CR + sLine;
                                    }
                                    break block35;
                                }
                                finally {
                                    inputStream.close();
                                }
                            }
                            catch (Exception e) {
                                throw new HopDatabaseException(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.ErrorRunningSQLfromFile", (String[])new String[0]), (Throwable)e);
                            }
                        }
                        theSql = this.sql;
                    }
                    if (Utils.isEmpty((CharSequence)theSql)) ** GOTO lbl71
                    if (this.useVariableSubstitution) {
                        theSql = this.resolve((String)theSql);
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.Log.SQlStatement", (String[])new String[]{theSql}));
                    }
                    if (this.sendOneStatement) {
                        db.execStatement((String)theSql);
                    }
                    db.execStatements((String)theSql);
                }
                finally {
                    db.close();
                }
            }
            catch (HopDatabaseException je) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.ErrorRunAction", (String[])new String[]{je.getMessage()}));
            }
            finally {
                if (sqlFile != null) {
                    try {
                        sqlFile.close();
                    }
                    catch (Exception var6_9) {}
                }
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.NoDatabaseConnection", (String[])new String[0]));
        }
lbl71:
        // 5 sources

        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[0];
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        DatabaseMeta databaseMeta = this.parentWorkflowMeta.findDatabase(this.connection, this.getVariables());
        if (databaseMeta != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(databaseMeta.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(databaseMeta.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "SQL", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

