/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforce;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class SalesforceTransformDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SalesforceTransformMeta.class;
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'.000'Z";
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private final Class<? extends SalesforceTransformMeta> META_CLASS;

    public SalesforceTransformDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.META_CLASS = ((Object)((Object)((SalesforceTransformMeta)((Object)in)))).getClass();
    }

    protected abstract void getInfo(SalesforceTransformMeta var1) throws HopException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() {
        boolean successConnection = true;
        String msgError = null;
        SalesforceConnection connection = null;
        String realUsername = null;
        try {
            SalesforceTransformMeta meta = this.META_CLASS.newInstance();
            this.getInfo(meta);
            String realURL = this.variables.resolve(meta.getTargetUrl());
            realUsername = this.variables.resolve(meta.getUsername());
            String realPassword = Utils.resolvePassword((IVariables)this.variables, (String)meta.getPassword());
            int realTimeOut = Const.toInt((String)this.variables.resolve(meta.getTimeout()), (int)0);
            connection = new SalesforceConnection((ILogChannel)this.log, realURL, realUsername, realPassword);
            connection.setTimeOut(realTimeOut);
            connection.connect();
        }
        catch (Exception e) {
            successConnection = false;
            msgError = e.getMessage();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        if (successConnection) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SalesforceTransformDialog.Connected.OK", (String[])new String[]{realUsername}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"SalesforceTransformDialog.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceTransformDialog.Connected.Title.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceTransformDialog.Connected.NOK", (String[])new String[]{realUsername}), new Exception(msgError));
        }
    }
}

