/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3Q\u0001C\u0005\u0001\u0017MA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006M\u0001!\ta\n\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0011\u0019y\u0004\u0001)A\u0005[!)\u0001\t\u0001C\u0001\u0003\")\u0011\n\u0001C\u0001\u0015\")q\u000b\u0001C\u00011\n\u0001\u0012J\u001c9vi&sgm\u001c+sC\u000e\\WM\u001d\u0006\u0003\u0015-\t\u0011b]2iK\u0012,H.\u001a:\u000b\u00051i\u0011!C:ue\u0016\fW.\u001b8h\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7c\u0001\u0001\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"a\u0007\u0010\u000e\u0003qQ!!H\u0007\u0002\u0011%tG/\u001a:oC2L!a\b\u000f\u0003\u000f1{wmZ5oO\u0006\u00191o]2\u0004\u0001A\u00111\u0005J\u0007\u0002\u0017%\u0011Qe\u0003\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqR\fa\u0001P5oSRtDC\u0001\u0015+!\tI\u0003!D\u0001\n\u0011\u0015\u0001#\u00011\u0001#\u0003U\u0011\u0017\r^2i)&lW\rV8J]B,H/\u00138g_N,\u0012!\f\t\u0005]M*\u0004(D\u00010\u0015\t\u0001\u0014'A\u0004nkR\f'\r\\3\u000b\u0005I2\u0012AC2pY2,7\r^5p]&\u0011Ag\f\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0019c'\u0003\u00028\u0017\t!A+[7f!\u0011q3'\u000f\u001f\u0011\u0005UQ\u0014BA\u001e\u0017\u0005\rIe\u000e\u001e\t\u0003SuJ!AP\u0005\u0003\u001fM#(/Z1n\u0013:\u0004X\u000f^%oM>\faCY1uG\"$\u0016.\\3U_&s\u0007/\u001e;J]\u001a|7\u000fI\u0001\u000be\u0016\u0004xN\u001d;J]\u001a|Gc\u0001\"F\u000fB\u0011QcQ\u0005\u0003\tZ\u0011A!\u00168ji\")a)\u0002a\u0001k\u0005I!-\u0019;dQRKW.\u001a\u0005\u0006\u0011\u0016\u0001\r\u0001P\u0001\nS:\u0004X\u000f^%oM>\fqaZ3u\u0013:4w\u000e\u0006\u0002L-B!AjU\u001d=\u001d\ti\u0015\u000b\u0005\u0002O-5\tqJ\u0003\u0002QC\u00051AH]8pizJ!A\u0015\f\u0002\rA\u0013X\rZ3g\u0013\t!VKA\u0002NCBT!A\u0015\f\t\u000b\u00193\u0001\u0019A\u001b\u0002\u000f\rdW-\u00198vaR\u0011!)\u0017\u0005\u00065\u001e\u0001\r!N\u0001\u0010E\u0006$8\r\u001b+ie\u0016\u001c\b\u000eV5nK\u0002")
public class InputInfoTracker
implements Logging {
    private final HashMap<Time, HashMap<Object, StreamInputInfo>> batchTimeToInputInfos;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashMap<Time, HashMap<Object, StreamInputInfo>> batchTimeToInputInfos() {
        return this.batchTimeToInputInfos;
    }

    public void reportInfo(Time batchTime, StreamInputInfo inputInfo) {
        InputInfoTracker inputInfoTracker = this;
        synchronized (inputInfoTracker) {
            HashMap inputInfos = (HashMap)this.batchTimeToInputInfos().getOrElseUpdate((Object)batchTime, (Function0 & Serializable & scala.Serializable)() -> new HashMap());
            if (inputInfos.contains((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId()))) {
                throw new IllegalStateException(new StringBuilder(89).append("Input stream ").append(inputInfo.inputStreamId()).append(" for batch ").append(batchTime).append(" is already added into InputInfoTracker, this is an illegal state").toString());
            }
            inputInfos.$plus$eq(new Tuple2((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId()), (Object)inputInfo));
        }
    }

    public synchronized Map<Object, StreamInputInfo> getInfo(Time batchTime) {
        Option inputInfos = this.batchTimeToInputInfos().get((Object)batchTime);
        return (Map)inputInfos.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
    }

    public void cleanup(Time batchThreshTime) {
        InputInfoTracker inputInfoTracker = this;
        synchronized (inputInfoTracker) {
            Iterable timesToCleanup = (Iterable)this.batchTimeToInputInfos().keys().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.$less(batchThreshTime)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("remove old batch metadata: ").append(timesToCleanup.mkString(" ")).toString());
            HashMap cfr_ignored_0 = (HashMap)this.batchTimeToInputInfos().$minus$minus$eq((TraversableOnce)timesToCleanup);
        }
    }

    public InputInfoTracker(StreamingContext ssc) {
        Logging.$init$((Logging)this);
        this.batchTimeToInputInfos = new HashMap();
    }
}

