/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.lang.reflect.Method;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class InferableFunction<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements ProcessFunction<InputT, OutputT>,
HasDisplayData {
    private final @Nullable @UnknownKeyFor @Initialized ProcessFunction<InputT, OutputT> fn;

    protected InferableFunction() {
        this.fn = null;
        try {
            Method methodThatMustBeOverridden = InferableFunction.class.getDeclaredMethod("apply", Object.class);
            Method methodOnSubclass = this.getClass().getMethod("apply", Object.class);
            if (methodOnSubclass.equals(methodThatMustBeOverridden)) {
                throw new IllegalStateException("Subclass of InferableFunction must override 'apply' method or pass a ProcessFunction to the constructor, usually via a lambda or method reference.");
            }
        }
        catch (NoSuchMethodException exc) {
            throw new RuntimeException("Impossible state: missing 'apply' method entirely", exc);
        }
    }

    protected InferableFunction(@UnknownKeyFor @NonNull @Initialized ProcessFunction<InputT, OutputT> fn) {
        this.fn = fn;
    }

    @Override
    public OutputT apply(InputT input) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.fn.apply(input);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized InferableFunction<InputT, OutputT> fromProcessFunctionWithOutputType(@UnknownKeyFor @NonNull @Initialized ProcessFunction<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
        return new InferableFunctionWithOutputType<InputT, OutputT>(fn, outputType);
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> getInputTypeDescriptor() {
        return new TypeDescriptor<InputT>(this){};
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> getOutputTypeDescriptor() {
        return new TypeDescriptor<OutputT>(this){};
    }

    @Override
    public void populateDisplayData( @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
    }

    private static class InferableFunctionWithOutputType<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends InferableFunction<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType;

        public InferableFunctionWithOutputType(@UnknownKeyFor @NonNull @Initialized ProcessFunction<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
            super(fn);
            this.outputType = outputType;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> getOutputTypeDescriptor() {
            return this.outputType;
        }
    }
}

