/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class RowCoder
extends SchemaCoder<Row> {
    public static @UnknownKeyFor @NonNull @Initialized RowCoder of(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new RowCoder(schema);
    }

    public static void overrideEncodingPositions(@UnknownKeyFor @NonNull @Initialized UUID uuid, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> encodingPositions) {
        SchemaCoder.overrideEncodingPositions(uuid, encodingPositions);
    }

    private RowCoder(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        super(schema, TypeDescriptors.rows(), SerializableFunctions.identity(), SerializableFunctions.identity());
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowCoder rowCoder = (RowCoder)o;
        return this.schema.equals(rowCoder.schema);
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.schema);
    }
}

