/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.replacestring;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.replacestring.ReplaceStringMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ReplaceStringDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ReplaceStringMeta.class;
    private TableView wFields;
    private final ReplaceStringMeta input;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] ciKey;

    public ReplaceStringDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)((ReplaceStringMeta)((Object)in)), tr, sname);
        this.input = (ReplaceStringMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.GetFields.Button", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlKey = new Label((Composite)this.shell, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        wlKey.setLayoutData((Object)fdlKey);
        int nrFieldCols = 10;
        int nrFieldRows = this.input.getFields().size();
        this.ciKey = new ColumnInfo[nrFieldCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.InStreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.OutStreamField", (String[])new String[0]), 1, false);
        this.ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.useRegEx", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])});
        this.ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.Replace", (String[])new String[0]), 1, false);
        this.ciKey[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.By", (String[])new String[0]), 1, false);
        this.ciKey[5] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.SetEmptyString", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])});
        this.ciKey[6] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.FieldReplaceBy", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[7] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.WholeWord", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])});
        this.ciKey[8] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.CaseSensitive", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])});
        this.ciKey[9] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.IsUnicode", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])});
        this.ciKey[1].setToolTip(BaseMessages.getString(PKG, (String)"ReplaceStringDialog.ColumnInfo.OutStreamField.Tooltip", (String[])new String[0]));
        this.ciKey[1].setUsingVariables(true);
        this.ciKey[3].setUsingVariables(true);
        this.ciKey[4].setUsingVariables(true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrFieldRows, lsMod, this.props);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment(100, -margin);
        fdKey.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdKey);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ReplaceString.Error.CanNotGetFields", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciKey[0].setComboValues(fieldNames);
        this.ciKey[6].setComboValues(fieldNames);
    }

    public String toBooleanDescription(boolean b) {
        if (b) {
            return BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]);
        }
        return BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
    }

    public boolean toBoolean(String description) {
        return BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(description);
    }

    public void getData() {
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            ReplaceStringMeta.RSField field = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getFieldInStream(), (String)""));
            item.setText(2, Const.NVL((String)field.getFieldOutStream(), (String)""));
            item.setText(3, this.toBooleanDescription(field.isUsingRegEx()));
            item.setText(4, Const.NVL((String)field.getReplaceString(), (String)""));
            item.setText(5, Const.NVL((String)field.getReplaceByString(), (String)""));
            item.setText(6, this.toBooleanDescription(field.isSettingEmptyString()));
            item.setText(7, Const.NVL((String)field.getReplaceFieldByString(), (String)""));
            item.setText(8, this.toBooleanDescription(field.isReplacingWholeWord()));
            item.setText(9, this.toBooleanDescription(field.isCaseSensitive()));
            item.setText(10, this.toBooleanDescription(field.isUnicode()));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(ReplaceStringMeta m) {
        m.getFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            ReplaceStringMeta.RSField field = new ReplaceStringMeta.RSField();
            m.getFields().add(field);
            field.setFieldInStream(item.getText(1));
            field.setFieldOutStream(item.getText(2));
            field.setUsingRegEx(this.toBoolean(item.getText(3)));
            field.setReplaceString(item.getText(4));
            field.setReplaceByString(item.getText(5));
            field.setSettingEmptyString(this.toBoolean(item.getText(6)));
            field.setReplaceFieldByString(item.getText(7));
            field.setReplacingWholeWord(this.toBoolean(item.getText(8)));
            field.setCaseSensitive(this.toBoolean(item.getText(9)));
            field.setUnicode(this.toBoolean(item.getText(10)));
        }
        this.transformName = this.wTransformName.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    if (v.getType() == 2) {
                        tableItem.setText(3, BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                        tableItem.setText(6, BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                        tableItem.setText(8, BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                        tableItem.setText(9, BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                        tableItem.setText(10, BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                        return true;
                    }
                    return false;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ReplaceStringDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ReplaceStringDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

