/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.execution.builder;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hop.neo4j.execution.builder.ICypherBuilder;

public abstract class BaseCypherBuilder
implements ICypherBuilder {
    protected StringBuilder cypher = new StringBuilder();
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected boolean firstParameter = true;
    protected boolean firstReturn = true;

    protected BaseCypherBuilder() {
    }

    protected void addParameter(String property, Object value) {
        if (value != null) {
            if (value instanceof Date) {
                this.parameters.put(property, LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()));
            } else {
                this.parameters.put(property, value);
            }
        } else {
            this.parameters.put(property, null);
        }
    }

    @Override
    public String cypher() {
        return this.cypher.toString();
    }

    @Override
    public Map<String, Object> parameters() {
        return this.parameters;
    }
}

