/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.InternalUtil;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hive.hcatalog.mapreduce.RecordWriterContainer;

class DefaultRecordWriterContainer
extends RecordWriterContainer {
    private final HiveStorageHandler storageHandler;
    private final AbstractSerDe serDe;
    private final OutputJobInfo jobInfo;
    private final ObjectInspector hcatRecordOI;

    public DefaultRecordWriterContainer(TaskAttemptContext context, RecordWriter<? super WritableComparable<?>, ? super Writable> baseRecordWriter) throws IOException, InterruptedException {
        super(context, baseRecordWriter);
        this.jobInfo = HCatOutputFormat.getJobInfo(context.getConfiguration());
        this.storageHandler = HCatUtil.getStorageHandler(context.getConfiguration(), this.jobInfo.getTableInfo().getStorerInfo());
        HCatOutputFormat.configureOutputStorageHandler((JobContext)context);
        this.serDe = (AbstractSerDe)ReflectionUtils.newInstance((Class)this.storageHandler.getSerDeClass(), (Configuration)context.getConfiguration());
        this.hcatRecordOI = InternalUtil.createStructObjectInspector(this.jobInfo.getOutputSchema());
        try {
            InternalUtil.initializeOutputSerDe(this.serDe, context.getConfiguration(), this.jobInfo);
        }
        catch (SerDeException e) {
            throw new IOException("Failed to initialize SerDe", e);
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.getBaseRecordWriter().close(InternalUtil.createReporter(context));
    }

    public void write(WritableComparable<?> key, HCatRecord value) throws IOException, InterruptedException {
        try {
            this.getBaseRecordWriter().write(null, (Object)this.serDe.serialize(value.getAll(), this.hcatRecordOI));
        }
        catch (SerDeException e) {
            throw new IOException("Failed to serialize object", e);
        }
    }
}

