/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cratedbbulkloader.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpResponse;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.http.CrateDBHttpResponse;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.http.RowMetrics;

public class HttpBulkImportResponse {
    private final long outputRows;
    private final int statusCode;
    private final long rejectedRows;

    private HttpBulkImportResponse(int statusCode, Long outputRows, Long rejectedRows) {
        this.statusCode = statusCode;
        this.outputRows = outputRows;
        this.rejectedRows = rejectedRows;
    }

    public static HttpBulkImportResponse fromHttpResponse(HttpResponse<String> response) throws HopException {
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            CrateDBHttpResponse crateDBHttpResponse = (CrateDBHttpResponse)mapper.readValue(response.body(), CrateDBHttpResponse.class);
            long outputRows = crateDBHttpResponse.results.parallelStream().filter(r -> r.getRowCount() > 0).mapToInt(RowMetrics::getRowCount).sum();
            long rejectedRows = crateDBHttpResponse.results.parallelStream().filter(r -> r.getRowCount() < 0).mapToInt(RowMetrics::getRowCount).count();
            return new HttpBulkImportResponse(response.statusCode(), outputRows, rejectedRows);
        }
        catch (JsonProcessingException e) {
            throw new HopException("Unable to parse body of response", (Throwable)e);
        }
    }

    public long outputRows() {
        return this.outputRows;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public long rejectedRows() {
        return this.rejectedRows;
    }
}

