/*
 * Decompiled with CFR 0.152.
 */
package akka.protobuf;

import akka.protobuf.ByteString;
import akka.protobuf.LiteralByteString;
import java.util.NoSuchElementException;

class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedByteString(byte[] byArray, int n, int n2) {
        super(byArray);
        if (n < 0) {
            throw new IllegalArgumentException("Offset too small: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Length too small: " + n);
        }
        if ((long)n + (long)n2 > (long)byArray.length) {
            throw new IllegalArgumentException("Offset+Length too large: " + n + "+" + n2);
        }
        this.bytesOffset = n;
        this.bytesLength = n2;
    }

    @Override
    public byte byteAt(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index too small: " + n);
        }
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index too large: " + n + ", " + this.size());
        }
        return this.bytes[this.bytesOffset + n];
    }

    @Override
    public int size() {
        return this.bytesLength;
    }

    @Override
    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + n, byArray, n2, n3);
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new BoundedByteIterator();
    }

    private class BoundedByteIterator
    implements ByteString.ByteIterator {
        private int position;
        private final int limit;

        private BoundedByteIterator() {
            this.position = BoundedByteString.this.getOffsetIntoBytes();
            this.limit = this.position + BoundedByteString.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.position < this.limit;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        @Override
        public byte nextByte() {
            if (this.position >= this.limit) {
                throw new NoSuchElementException();
            }
            return BoundedByteString.this.bytes[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

