/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import com.esotericsoftware.kryo.Serializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.api.java.ExecutionPlanUtil;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.RemoteEnvironment;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.api.java.io.CsvReader;
import org.apache.flink.api.java.io.IteratorInputFormat;
import org.apache.flink.api.java.io.ParallelIteratorInputFormat;
import org.apache.flink.api.java.io.PrimitiveInputFormat;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.api.java.io.TextValueInputFormat;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.utils.PlanGenerator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.execution.DefaultExecutorServiceLoader;
import org.apache.flink.core.execution.DetachedJobExecutionResult;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.JobListener;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.NumberSequenceIterator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SplittableIterator;
import org.apache.flink.util.WrappingRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class ExecutionEnvironment {
    protected static final Logger LOG = LoggerFactory.getLogger(ExecutionEnvironment.class);
    private static ExecutionEnvironmentFactory contextEnvironmentFactory = null;
    private static final ThreadLocal<ExecutionEnvironmentFactory> threadLocalContextEnvironmentFactory = new ThreadLocal();
    private static int defaultLocalDop = Runtime.getRuntime().availableProcessors();
    private final List<DataSink<?>> sinks = new ArrayList();
    private final List<Tuple2<String, DistributedCache.DistributedCacheEntry>> cacheFile = new ArrayList<Tuple2<String, DistributedCache.DistributedCacheEntry>>();
    private final ExecutionConfig config = new ExecutionConfig();
    protected JobExecutionResult lastJobExecutionResult;
    private boolean wasExecuted = false;
    private final PipelineExecutorServiceLoader executorServiceLoader;
    private final Configuration configuration;
    private final ClassLoader userClassloader;
    private final List<JobListener> jobListeners = new ArrayList<JobListener>();

    @PublicEvolving
    public ExecutionEnvironment(Configuration configuration) {
        this(configuration, null);
    }

    @PublicEvolving
    public ExecutionEnvironment(Configuration configuration, ClassLoader userClassloader) {
        this((PipelineExecutorServiceLoader)new DefaultExecutorServiceLoader(), configuration, userClassloader);
    }

    @PublicEvolving
    public ExecutionEnvironment(PipelineExecutorServiceLoader executorServiceLoader, Configuration configuration, ClassLoader userClassloader) {
        this.executorServiceLoader = (PipelineExecutorServiceLoader)Preconditions.checkNotNull((Object)executorServiceLoader);
        this.configuration = new Configuration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.userClassloader = userClassloader == null ? this.getClass().getClassLoader() : userClassloader;
        this.configure((ReadableConfig)this.configuration, this.userClassloader);
    }

    protected ExecutionEnvironment() {
        this(new Configuration());
    }

    @Internal
    public ClassLoader getUserCodeClassLoader() {
        return this.userClassloader;
    }

    @Internal
    public PipelineExecutorServiceLoader getExecutorServiceLoader() {
        return this.executorServiceLoader;
    }

    @Internal
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ExecutionConfig getConfig() {
        return this.config;
    }

    protected List<JobListener> getJobListeners() {
        return this.jobListeners;
    }

    public int getParallelism() {
        return this.config.getParallelism();
    }

    public void setParallelism(int parallelism) {
        this.config.setParallelism(parallelism);
    }

    @PublicEvolving
    public void setRestartStrategy(RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration) {
        this.config.setRestartStrategy(restartStrategyConfiguration);
    }

    @PublicEvolving
    public RestartStrategies.RestartStrategyConfiguration getRestartStrategy() {
        return this.config.getRestartStrategy();
    }

    @Deprecated
    @PublicEvolving
    public void setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        this.config.setNumberOfExecutionRetries(numberOfExecutionRetries);
    }

    @Deprecated
    @PublicEvolving
    public int getNumberOfExecutionRetries() {
        return this.config.getNumberOfExecutionRetries();
    }

    public JobExecutionResult getLastJobExecutionResult() {
        return this.lastJobExecutionResult;
    }

    public <T extends Serializer<?>> void addDefaultKryoSerializer(Class<?> type, T serializer) {
        this.config.addDefaultKryoSerializer(type, serializer);
    }

    public void addDefaultKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        this.config.addDefaultKryoSerializer(type, serializerClass);
    }

    public <T extends Serializer<?>> void registerTypeWithKryoSerializer(Class<?> type, T serializer) {
        this.config.registerTypeWithKryoSerializer(type, serializer);
    }

    public void registerTypeWithKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        this.config.registerTypeWithKryoSerializer(type, serializerClass);
    }

    public void registerType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        TypeInformation typeInfo = TypeExtractor.createTypeInfo(type);
        if (typeInfo instanceof PojoTypeInfo) {
            this.config.registerPojoType(type);
        } else {
            this.config.registerKryoType(type);
        }
    }

    @PublicEvolving
    public void configure(ReadableConfig configuration, ClassLoader classLoader) {
        configuration.getOptional(DeploymentOptions.JOB_LISTENERS).ifPresent(listeners -> this.registerCustomListeners(classLoader, (List<String>)listeners));
        configuration.getOptional(PipelineOptions.CACHED_FILES).ifPresent(f -> {
            this.cacheFile.clear();
            this.cacheFile.addAll(DistributedCache.parseCachedFilesFromString((List)f));
        });
        configuration.getOptional(PipelineOptions.NAME).ifPresent(jobName -> this.getConfiguration().set(PipelineOptions.NAME, jobName));
        this.config.configure(configuration, classLoader);
    }

    private void registerCustomListeners(ClassLoader classLoader, List<String> listeners) {
        for (String listener : listeners) {
            try {
                JobListener jobListener = (JobListener)InstantiationUtil.instantiate((String)listener, JobListener.class, (ClassLoader)classLoader);
                this.jobListeners.add(jobListener);
            }
            catch (FlinkException e) {
                throw new WrappingRuntimeException("Could not load JobListener : " + listener, (Throwable)e);
            }
        }
    }

    public DataSource<String> readTextFile(String filePath) {
        Preconditions.checkNotNull((Object)filePath, (String)"The file path may not be null.");
        return new DataSource<String>(this, (InputFormat<String, ?>)new TextInputFormat(new Path(filePath)), (TypeInformation<String>)BasicTypeInfo.STRING_TYPE_INFO, Utils.getCallLocationName());
    }

    public DataSource<String> readTextFile(String filePath, String charsetName) {
        Preconditions.checkNotNull((Object)filePath, (String)"The file path may not be null.");
        TextInputFormat format = new TextInputFormat(new Path(filePath));
        format.setCharsetName(charsetName);
        return new DataSource<String>(this, (InputFormat<String, ?>)format, (TypeInformation<String>)BasicTypeInfo.STRING_TYPE_INFO, Utils.getCallLocationName());
    }

    public DataSource<StringValue> readTextFileWithValue(String filePath) {
        Preconditions.checkNotNull((Object)filePath, (String)"The file path may not be null.");
        return new DataSource<StringValue>(this, (InputFormat<StringValue, ?>)new TextValueInputFormat(new Path(filePath)), (TypeInformation<StringValue>)new ValueTypeInfo(StringValue.class), Utils.getCallLocationName());
    }

    public DataSource<StringValue> readTextFileWithValue(String filePath, String charsetName, boolean skipInvalidLines) {
        Preconditions.checkNotNull((Object)filePath, (String)"The file path may not be null.");
        TextValueInputFormat format = new TextValueInputFormat(new Path(filePath));
        format.setCharsetName(charsetName);
        format.setSkipInvalidLines(skipInvalidLines);
        return new DataSource<StringValue>(this, (InputFormat<StringValue, ?>)format, (TypeInformation<StringValue>)new ValueTypeInfo(StringValue.class), Utils.getCallLocationName());
    }

    public <X> DataSource<X> readFileOfPrimitives(String filePath, Class<X> typeClass) {
        Preconditions.checkNotNull((Object)filePath, (String)"The file path may not be null.");
        return new DataSource(this, new PrimitiveInputFormat<X>(new Path(filePath), typeClass), TypeExtractor.getForClass(typeClass), Utils.getCallLocationName());
    }

    public <X> DataSource<X> readFileOfPrimitives(String filePath, String delimiter, Class<X> typeClass) {
        Preconditions.checkNotNull((Object)filePath, (String)"The file path may not be null.");
        return new DataSource(this, new PrimitiveInputFormat<X>(new Path(filePath), delimiter, typeClass), TypeExtractor.getForClass(typeClass), Utils.getCallLocationName());
    }

    public CsvReader readCsvFile(String filePath) {
        return new CsvReader(filePath, this);
    }

    public <X> DataSource<X> readFile(FileInputFormat<X> inputFormat, String filePath) {
        if (inputFormat == null) {
            throw new IllegalArgumentException("InputFormat must not be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("The file path must not be null.");
        }
        inputFormat.setFilePath(new Path(filePath));
        try {
            return this.createInput((InputFormat<X, ?>)inputFormat, (TypeInformation<X>)TypeExtractor.getInputFormatTypes(inputFormat));
        }
        catch (Exception e) {
            throw new InvalidProgramException("The type returned by the input format could not be automatically determined. Please specify the TypeInformation of the produced type explicitly by using the 'createInput(InputFormat, TypeInformation)' method instead.");
        }
    }

    public <X> DataSource<X> createInput(InputFormat<X, ?> inputFormat) {
        if (inputFormat == null) {
            throw new IllegalArgumentException("InputFormat must not be null.");
        }
        try {
            return this.createInput(inputFormat, TypeExtractor.getInputFormatTypes(inputFormat));
        }
        catch (Exception e) {
            throw new InvalidProgramException("The type returned by the input format could not be automatically determined. Please specify the TypeInformation of the produced type explicitly by using the 'createInput(InputFormat, TypeInformation)' method instead.", (Throwable)e);
        }
    }

    public <X> DataSource<X> createInput(InputFormat<X, ?> inputFormat, TypeInformation<X> producedType) {
        if (inputFormat == null) {
            throw new IllegalArgumentException("InputFormat must not be null.");
        }
        if (producedType == null) {
            throw new IllegalArgumentException("Produced type information must not be null.");
        }
        return new DataSource<X>(this, inputFormat, producedType, Utils.getCallLocationName());
    }

    public <X> DataSource<X> fromCollection(Collection<X> data) {
        if (data == null) {
            throw new IllegalArgumentException("The data must not be null.");
        }
        if (data.size() == 0) {
            throw new IllegalArgumentException("The size of the collection must not be empty.");
        }
        X firstValue = data.iterator().next();
        TypeInformation type = TypeExtractor.getForObject(firstValue);
        CollectionInputFormat.checkCollection(data, type.getTypeClass());
        return new DataSource(this, new CollectionInputFormat<X>(data, type.createSerializer(this.config)), type, Utils.getCallLocationName());
    }

    public <X> DataSource<X> fromCollection(Collection<X> data, TypeInformation<X> type) {
        return this.fromCollection(data, type, Utils.getCallLocationName());
    }

    private <X> DataSource<X> fromCollection(Collection<X> data, TypeInformation<X> type, String callLocationName) {
        CollectionInputFormat.checkCollection(data, type.getTypeClass());
        return new DataSource<X>(this, new CollectionInputFormat<X>(data, type.createSerializer(this.config)), type, callLocationName);
    }

    public <X> DataSource<X> fromCollection(Iterator<X> data, Class<X> type) {
        return this.fromCollection(data, TypeExtractor.getForClass(type));
    }

    public <X> DataSource<X> fromCollection(Iterator<X> data, TypeInformation<X> type) {
        return new DataSource<X>(this, new IteratorInputFormat<X>(data), type, Utils.getCallLocationName());
    }

    @SafeVarargs
    public final <X> DataSource<X> fromElements(X ... data) {
        TypeInformation typeInfo;
        if (data == null) {
            throw new IllegalArgumentException("The data must not be null.");
        }
        if (data.length == 0) {
            throw new IllegalArgumentException("The number of elements must not be zero.");
        }
        try {
            typeInfo = TypeExtractor.getForObject(data[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create TypeInformation for type " + data[0].getClass().getName() + "; please specify the TypeInformation manually via ExecutionEnvironment#fromElements(Collection, TypeInformation)", e);
        }
        return this.fromCollection(Arrays.asList(data), typeInfo, Utils.getCallLocationName());
    }

    @SafeVarargs
    public final <X> DataSource<X> fromElements(Class<X> type, X ... data) {
        TypeInformation typeInfo;
        if (data == null) {
            throw new IllegalArgumentException("The data must not be null.");
        }
        if (data.length == 0) {
            throw new IllegalArgumentException("The number of elements must not be zero.");
        }
        try {
            typeInfo = TypeExtractor.getForClass(type);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create TypeInformation for type " + type.getName() + "; please specify the TypeInformation manually via ExecutionEnvironment#fromElements(Collection, TypeInformation)", e);
        }
        return this.fromCollection(Arrays.asList(data), typeInfo, Utils.getCallLocationName());
    }

    public <X> DataSource<X> fromParallelCollection(SplittableIterator<X> iterator, Class<X> type) {
        return this.fromParallelCollection(iterator, TypeExtractor.getForClass(type));
    }

    public <X> DataSource<X> fromParallelCollection(SplittableIterator<X> iterator, TypeInformation<X> type) {
        return this.fromParallelCollection(iterator, type, Utils.getCallLocationName());
    }

    private <X> DataSource<X> fromParallelCollection(SplittableIterator<X> iterator, TypeInformation<X> type, String callLocationName) {
        return new DataSource<X>(this, new ParallelIteratorInputFormat<X>(iterator), type, callLocationName);
    }

    public DataSource<Long> generateSequence(long from, long to) {
        return this.fromParallelCollection((SplittableIterator)new NumberSequenceIterator(from, to), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, Utils.getCallLocationName());
    }

    public JobExecutionResult execute() throws Exception {
        return this.execute(this.getJobName());
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        JobClient jobClient = this.executeAsync(jobName);
        try {
            this.lastJobExecutionResult = this.configuration.getBoolean(DeploymentOptions.ATTACHED) ? (JobExecutionResult)jobClient.getJobExecutionResult().get() : new DetachedJobExecutionResult(jobClient.getJobID());
            this.jobListeners.forEach(jobListener -> jobListener.onJobExecuted(this.lastJobExecutionResult, null));
        }
        catch (Throwable t) {
            Throwable strippedException = ExceptionUtils.stripExecutionException((Throwable)t);
            this.jobListeners.forEach(jobListener -> jobListener.onJobExecuted(null, strippedException));
            ExceptionUtils.rethrowException((Throwable)strippedException);
        }
        return this.lastJobExecutionResult;
    }

    @PublicEvolving
    public void registerJobListener(JobListener jobListener) {
        Preconditions.checkNotNull((Object)jobListener, (String)"JobListener cannot be null");
        this.jobListeners.add(jobListener);
    }

    @PublicEvolving
    public void clearJobListeners() {
        this.jobListeners.clear();
    }

    @PublicEvolving
    public final JobClient executeAsync() throws Exception {
        return this.executeAsync(this.getJobName());
    }

    @PublicEvolving
    public JobClient executeAsync(String jobName) throws Exception {
        Preconditions.checkNotNull((Object)this.configuration.get(DeploymentOptions.TARGET), (String)"No execution.target specified in your configuration file.");
        Plan plan = this.createProgramPlan(jobName);
        PipelineExecutorFactory executorFactory = this.executorServiceLoader.getExecutorFactory(this.configuration);
        Preconditions.checkNotNull((Object)executorFactory, (String)"Cannot find compatible factory for specified execution.target (=%s)", (Object[])new Object[]{this.configuration.get(DeploymentOptions.TARGET)});
        CompletableFuture jobClientFuture = executorFactory.getExecutor(this.configuration).execute((Pipeline)plan, this.configuration, this.userClassloader);
        try {
            JobClient jobClient = (JobClient)jobClientFuture.get();
            this.jobListeners.forEach(jobListener -> jobListener.onJobSubmitted(jobClient, null));
            return jobClient;
        }
        catch (Throwable t) {
            this.jobListeners.forEach(jobListener -> jobListener.onJobSubmitted(null, t));
            ExceptionUtils.rethrow((Throwable)t);
            return null;
        }
    }

    public String getExecutionPlan() throws Exception {
        Plan p = this.createProgramPlan(this.getJobName(), false);
        return ExecutionPlanUtil.getExecutionPlanAsJSON(p);
    }

    public void registerCachedFile(String filePath, String name) {
        this.registerCachedFile(filePath, name, false);
    }

    public void registerCachedFile(String filePath, String name, boolean executable) {
        this.cacheFile.add((Tuple2<String, DistributedCache.DistributedCacheEntry>)new Tuple2((Object)name, (Object)new DistributedCache.DistributedCacheEntry(filePath, Boolean.valueOf(executable))));
    }

    @Internal
    public Plan createProgramPlan() {
        return this.createProgramPlan(this.getJobName());
    }

    @Internal
    public Plan createProgramPlan(String jobName) {
        return this.createProgramPlan(jobName, true);
    }

    @Internal
    public Plan createProgramPlan(String jobName, boolean clearSinks) {
        Preconditions.checkNotNull((Object)jobName);
        if (this.sinks.isEmpty()) {
            if (this.wasExecuted) {
                throw new RuntimeException("No new data sinks have been defined since the last execution. The last execution refers to the latest call to 'execute()', 'count()', 'collect()', or 'print()'.");
            }
            throw new RuntimeException("No data sinks have been created yet. A program needs at least one sink that consumes data. Examples are writing the data set or printing it.");
        }
        PlanGenerator generator = new PlanGenerator(this.sinks, this.config, this.getParallelism(), this.cacheFile, jobName);
        Plan plan = generator.generate();
        if (clearSinks) {
            this.sinks.clear();
            this.wasExecuted = true;
        }
        return plan;
    }

    @Internal
    void registerDataSink(DataSink<?> sink) {
        this.sinks.add(sink);
    }

    private String getJobName() {
        return this.configuration.getString(PipelineOptions.NAME, "Flink Java Job at " + Calendar.getInstance().getTime());
    }

    public static ExecutionEnvironment getExecutionEnvironment() {
        return Utils.resolveFactory(threadLocalContextEnvironmentFactory, contextEnvironmentFactory).map(ExecutionEnvironmentFactory::createExecutionEnvironment).orElseGet(ExecutionEnvironment::createLocalEnvironment);
    }

    @PublicEvolving
    public static CollectionEnvironment createCollectionsEnvironment() {
        CollectionEnvironment ce = new CollectionEnvironment();
        ce.setParallelism(1);
        return ce;
    }

    public static LocalEnvironment createLocalEnvironment() {
        return ExecutionEnvironment.createLocalEnvironment(defaultLocalDop);
    }

    public static LocalEnvironment createLocalEnvironment(int parallelism) {
        return ExecutionEnvironment.createLocalEnvironment(new Configuration(), parallelism);
    }

    public static LocalEnvironment createLocalEnvironment(Configuration customConfiguration) {
        return ExecutionEnvironment.createLocalEnvironment(customConfiguration, -1);
    }

    @PublicEvolving
    public static ExecutionEnvironment createLocalEnvironmentWithWebUI(Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (String)"conf");
        if (!conf.contains(RestOptions.PORT)) {
            conf.setInteger(RestOptions.PORT, ((Integer)RestOptions.PORT.defaultValue()).intValue());
        }
        return ExecutionEnvironment.createLocalEnvironment(conf, -1);
    }

    private static LocalEnvironment createLocalEnvironment(Configuration configuration, int defaultParallelism) {
        LocalEnvironment localEnvironment = new LocalEnvironment(configuration);
        if (defaultParallelism > 0) {
            localEnvironment.setParallelism(defaultParallelism);
        }
        return localEnvironment;
    }

    public static ExecutionEnvironment createRemoteEnvironment(String host, int port, String ... jarFiles) {
        return new RemoteEnvironment(host, port, jarFiles);
    }

    public static ExecutionEnvironment createRemoteEnvironment(String host, int port, Configuration clientConfiguration, String ... jarFiles) {
        return new RemoteEnvironment(host, port, clientConfiguration, jarFiles, null);
    }

    public static ExecutionEnvironment createRemoteEnvironment(String host, int port, int parallelism, String ... jarFiles) {
        RemoteEnvironment rec = new RemoteEnvironment(host, port, jarFiles);
        rec.setParallelism(parallelism);
        return rec;
    }

    public static int getDefaultLocalParallelism() {
        return defaultLocalDop;
    }

    public static void setDefaultLocalParallelism(int parallelism) {
        defaultLocalDop = parallelism;
    }

    protected static void initializeContextEnvironment(ExecutionEnvironmentFactory ctx) {
        contextEnvironmentFactory = (ExecutionEnvironmentFactory)Preconditions.checkNotNull((Object)ctx);
        threadLocalContextEnvironmentFactory.set(ctx);
    }

    protected static void resetContextEnvironment() {
        contextEnvironmentFactory = null;
        threadLocalContextEnvironmentFactory.remove();
    }

    @Internal
    public static boolean areExplicitEnvironmentsAllowed() {
        return contextEnvironmentFactory == null && threadLocalContextEnvironmentFactory.get() == null;
    }
}

