/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.HelpUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class EnterSelectionDialog
extends Dialog {
    private static final Class<?> PKG = EnterSelectionDialog.class;
    private Label wlSelection;
    private org.eclipse.swt.widgets.List wSelection;
    private FormData fdlSelection;
    private FormData fdSelection;
    private TextVar wConstantValue;
    private Button wbUseConstant;
    private Button wOk;
    private Shell shell;
    private String[] choices;
    private String selection;
    private int selectionNr;
    private String shellText;
    private String lineText;
    private String constant;
    private IVariables variables;
    private String currentValue;
    private boolean viewOnly;
    private boolean modal;
    private int[] selectedNrs;
    private boolean multi;
    private int[] indices;
    private boolean fixed;
    private boolean quickSearch;
    private ToolItem wbRegex;
    private String filterString = null;
    private Pattern pattern = null;
    private Text searchText = null;
    private boolean addNoneOption;
    private boolean noneClicked;

    public Shell getShell() {
        return this.shell;
    }

    public EnterSelectionDialog(Shell parent, String[] choices, String shellText, String message) {
        super(parent, 0);
        this.choices = choices;
        this.shellText = shellText;
        this.lineText = message;
        this.selection = null;
        this.viewOnly = false;
        this.modal = true;
        this.selectedNrs = new int[0];
        this.multi = false;
        this.fixed = false;
        this.quickSearch = true;
    }

    public EnterSelectionDialog(Shell parent, String[] choices, String shellText, String message, String constant, IVariables variables) {
        this(parent, choices, shellText, message);
        this.constant = constant;
        this.variables = variables;
    }

    public void setViewOnly() {
        this.viewOnly = true;
    }

    public void setAvoidQuickSearch() {
        this.quickSearch = false;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public void clearModal() {
        this.modal = false;
    }

    public String open(int nr) {
        this.selectedNrs = new int[]{nr};
        return this.open();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 0x860 | (this.modal ? 0x10010000 : 0) | 0x10 | 0x80 | 0x400);
        PropsUi.setLook((Widget)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.shellText);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        if (this.quickSearch) {
            ToolBar treeTb = new ToolBar((Composite)this.shell, 0x800100);
            PropsUi.setLook((Widget)treeTb);
            ToolItem wfilter = new ToolItem(treeTb, 2);
            this.searchText = new Text((Composite)treeTb, 384);
            PropsUi.setLook((Widget)this.searchText);
            this.searchText.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.FilterString.ToolTip", (String[])new String[0]));
            this.searchText.setData("NoDefaultHandler", (Object)true);
            this.searchText.addListener(24, e -> this.updateFilter());
            wfilter.setControl((Control)this.searchText);
            wfilter.setWidth(120);
            this.wbRegex = new ToolItem(treeTb, 32);
            this.wbRegex.setImage(GuiResource.getInstance().getImageRegex());
            this.wbRegex.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.useRegEx.Tooltip", (String[])new String[0]));
            ToolItem goSearch = new ToolItem(treeTb, 8);
            goSearch.setImage(GuiResource.getInstance().getImageRefresh());
            goSearch.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.refresh.Label", (String[])new String[0]));
            goSearch.addListener(13, e -> this.updateFilter());
            FormData fd = new FormData();
            fd.right = new FormAttachment(100);
            fd.top = new FormAttachment(0, 0);
            treeTb.setLayoutData((Object)fd);
            Label wlFilter = new Label((Composite)this.shell, 131072);
            PropsUi.setLook((Widget)wlFilter);
            wlFilter.setText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.FilterString.Label", (String[])new String[0]));
            FormData fdlFilter = new FormData();
            fdlFilter.top = new FormAttachment(0, 5);
            fdlFilter.right = new FormAttachment((Control)treeTb, -5);
            wlFilter.setLayoutData((Object)fdlFilter);
            this.wlSelection = new Label((Composite)this.shell, 0);
            this.wlSelection.setText(this.lineText);
            PropsUi.setLook((Widget)this.wlSelection);
            this.fdlSelection = new FormData();
            this.fdlSelection.left = new FormAttachment(0, 0);
            this.fdlSelection.top = new FormAttachment((Control)treeTb, 10);
        } else {
            this.wlSelection = new Label((Composite)this.shell, 0);
            this.wlSelection.setText(this.lineText);
            PropsUi.setLook((Widget)this.wlSelection);
            this.fdlSelection = new FormData();
            this.fdlSelection.left = new FormAttachment(0, 0);
        }
        this.wlSelection.setLayoutData((Object)this.fdlSelection);
        int options = 19200;
        options = this.multi ? (options |= 2) : (options |= 4);
        this.wSelection = new org.eclipse.swt.widgets.List((Composite)this.shell, options);
        for (int i = 0; i < this.choices.length; ++i) {
            this.wSelection.add(this.choices[i]);
        }
        if (this.selectedNrs != null) {
            this.wSelection.select(this.selectedNrs);
        }
        if (this.fixed) {
            PropsUi.setLook((Widget)this.wSelection, 1);
        } else {
            PropsUi.setLook((Widget)this.wSelection);
        }
        ArrayList<Button> buttons = new ArrayList<Button>();
        this.wOk = new Button((Composite)this.shell, 8);
        if (this.viewOnly) {
            this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        } else {
            this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        }
        this.wOk.addListener(13, e -> this.ok());
        buttons.add(this.wOk);
        if (this.addNoneOption) {
            Button wNone = new Button((Composite)this.shell, 8);
            wNone.setText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.Button.None.Label", (String[])new String[0]));
            wNone.addListener(13, e -> {
                this.noneClicked = true;
                this.cancel();
            });
            buttons.add(wNone);
        }
        if (!this.viewOnly) {
            Button wCancel = new Button((Composite)this.shell, 8);
            wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            wCancel.addListener(13, e -> this.cancel());
            buttons.add(wCancel);
        }
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons.toArray(new Button[0]), PropsUi.getMargin(), null);
        Button nextControl = this.wOk;
        if (this.constant != null) {
            this.wConstantValue = new TextVar(this.variables, (Composite)this.shell, 18436);
            if (!Utils.isEmpty((CharSequence)this.constant)) {
                this.wConstantValue.setText(this.constant);
            }
            PropsUi.setLook((Widget)this.wConstantValue);
            FormData fdConstantValue = new FormData();
            fdConstantValue.left = new FormAttachment(0, 0);
            fdConstantValue.bottom = new FormAttachment((Control)this.wOk, -10);
            fdConstantValue.right = new FormAttachment(100, 0);
            this.wConstantValue.setLayoutData(fdConstantValue);
            this.wbUseConstant = new Button((Composite)this.shell, 32);
            PropsUi.setLook((Widget)this.wbUseConstant);
            this.wbUseConstant.setText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.UseConstant.Label", (String[])new String[0]));
            this.wbUseConstant.setSelection(!Utils.isEmpty((CharSequence)this.constant));
            nextControl = this.wbUseConstant;
            FormData fdUseConstant = new FormData();
            fdUseConstant.left = new FormAttachment(0, 0);
            fdUseConstant.bottom = new FormAttachment((Control)this.wConstantValue, -5);
            this.wbUseConstant.setLayoutData((Object)fdUseConstant);
            this.wbUseConstant.addListener(13, e -> this.setActive());
            this.setActive();
        }
        this.fdSelection = new FormData();
        this.fdSelection.left = new FormAttachment(0, 0);
        this.fdSelection.right = new FormAttachment(100, 0);
        this.fdSelection.top = new FormAttachment((Control)this.wlSelection, 5);
        this.fdSelection.bottom = new FormAttachment((Control)nextControl, -10);
        this.wSelection.setLayoutData((Object)this.fdSelection);
        this.wSelection.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    EnterSelectionDialog.this.ok();
                }
            }
        });
        this.getData();
        this.wSelection.setFocus();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.selection;
    }

    private void setActive() {
        this.wSelection.setEnabled(!this.wbUseConstant.getSelection());
        this.wConstantValue.setEnabled(this.wbUseConstant.getSelection());
    }

    public String openRepoDialog() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 0x860 | (this.modal ? 0x10010000 : 0) | 0x80 | 0x400);
        PropsUi.setLook((Widget)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.shellText);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.wlSelection = new Label((Composite)this.shell, 0);
        this.wlSelection.setText(this.lineText);
        PropsUi.setLook((Widget)this.wlSelection);
        this.fdlSelection = new FormData();
        this.fdlSelection.left = new FormAttachment(0, 10);
        this.fdlSelection.top = new FormAttachment(0, 10);
        this.wlSelection.setLayoutData((Object)this.fdlSelection);
        int options = 19200;
        this.wSelection = new org.eclipse.swt.widgets.List((Composite)this.shell, options);
        for (int i = 0; i < this.choices.length; ++i) {
            this.wSelection.add(this.choices[i]);
        }
        Label separator = new Label((Composite)this.shell, 258);
        FormData fdSeparator = new FormData();
        fdSeparator.top = new FormAttachment((Control)this.wSelection, 35);
        fdSeparator.right = new FormAttachment(100, -10);
        fdSeparator.left = new FormAttachment(0, 10);
        separator.setLayoutData((Object)fdSeparator);
        Button btnHelp = HelpUtils.createHelpButton((Composite)this.shell, Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"EnterSelectionDialog.Help", (String[])new String[0])));
        FormData fdBtnHelp = new FormData();
        fdBtnHelp.top = new FormAttachment((Control)separator, 12);
        fdBtnHelp.left = new FormAttachment(0, 10);
        fdBtnHelp.bottom = new FormAttachment(100, -10);
        fdBtnHelp.width = Const.isOSX() ? 85 : 75;
        btnHelp.setLayoutData((Object)fdBtnHelp);
        this.fdSelection = new FormData();
        this.fdSelection.left = new FormAttachment(0, 10);
        this.fdSelection.right = new FormAttachment(100, -10);
        this.fdSelection.top = new FormAttachment((Control)this.wlSelection, 10);
        this.fdSelection.bottom = new FormAttachment((Control)separator, -12);
        this.wSelection.setLayoutData((Object)this.fdSelection);
        this.wSelection.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    EnterSelectionDialog.this.ok();
                }
            }
        });
        this.getData();
        this.wOk.setFocus();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.selection;
    }

    public void dispose() {
        PropsUi.getInstance().setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
    }

    private void cancel() {
        this.selection = null;
        this.dispose();
    }

    private void ok() {
        if (this.constant != null && this.wbUseConstant.getSelection()) {
            this.selection = this.wConstantValue.getText();
        } else if (this.wSelection.getSelectionCount() > 0) {
            this.selection = this.wSelection.getSelection()[0];
            this.selectionNr = this.wSelection.getSelectionIndices()[0];
            if (this.quickSearch) {
                for (int i = 0; i < this.choices.length; ++i) {
                    if (!this.choices[i].equals(this.selection)) continue;
                    this.selectionNr = i;
                }
            }
            String[] selections = this.wSelection.getSelection();
            boolean found = false;
            this.indices = new int[selections.length];
            block1: for (int i = 0; i < selections.length; ++i) {
                found = false;
                for (int j = 0; j < this.choices.length; ++j) {
                    if (!selections[i].equals(this.choices[j])) continue;
                    this.indices[i] = j;
                    found = true;
                    continue block1;
                }
            }
            if (!found) {
                this.indices = this.wSelection.getSelectionIndices();
            }
        } else {
            this.selection = null;
            this.selectionNr = -1;
            this.indices = new int[0];
        }
        this.dispose();
    }

    public int getSelectionNr(String str) {
        for (int i = 0; i < this.choices.length; ++i) {
            if (!this.choices[i].equalsIgnoreCase(str)) continue;
            return i;
        }
        return -1;
    }

    public int getSelectionNr() {
        return this.selectionNr;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public int[] getSelectionIndeces() {
        return this.indices;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public int[] getSelectedNrs() {
        return this.selectedNrs;
    }

    public void setSelectedNrs(int[] selectedNrs) {
        this.selectedNrs = selectedNrs;
    }

    public void setSelectedNrs(List<Integer> selectedNrs) {
        this.selectedNrs = new int[selectedNrs.size()];
        for (int i = 0; i < selectedNrs.size(); ++i) {
            this.selectedNrs[i] = selectedNrs.get(i);
        }
    }

    protected void updateFilter() {
        this.pattern = null;
        this.filterString = null;
        if (this.searchText != null && !this.searchText.isDisposed() && !Utils.isEmpty((CharSequence)this.searchText.getText())) {
            if (this.wbRegex.getSelection()) {
                this.pattern = Pattern.compile(this.searchText.getText());
            } else {
                this.filterString = this.searchText.getText().toUpperCase();
            }
        }
        this.refresh();
    }

    private void refresh() {
        this.wSelection.removeAll();
        for (int i = 0; i < this.choices.length; ++i) {
            if (this.quickSearch) {
                if (this.wbRegex.getSelection()) {
                    if (this.pattern != null) {
                        Matcher matcher = this.pattern.matcher(this.choices[i]);
                        if (!matcher.matches()) continue;
                        this.wSelection.add(this.choices[i]);
                        continue;
                    }
                    this.wSelection.add(this.choices[i]);
                    continue;
                }
                if (this.filterString != null) {
                    if (!this.choices[i].toUpperCase().contains(this.filterString)) continue;
                    this.wSelection.add(this.choices[i]);
                    continue;
                }
                this.wSelection.add(this.choices[i]);
                continue;
            }
            this.wSelection.add(this.choices[i]);
        }
        this.wSelection.redraw();
    }

    public boolean isAddNoneOption() {
        return this.addNoneOption;
    }

    public void setAddNoneOption(boolean addNoneOption) {
        this.addNoneOption = addNoneOption;
    }

    public boolean isNoneClicked() {
        return this.noneClicked;
    }

    public void setNoneClicked(boolean noneClicked) {
        this.noneClicked = noneClicked;
    }
}

