/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.apacheimpl;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.avro.AvroParser;
import com.fasterxml.jackson.dataformat.avro.apacheimpl.ApacheCodecRecycler;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.avro.io.BinaryDecoder;

public class ApacheAvroParserImpl
extends AvroParserImpl {
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected BinaryDecoder _decoder;
    protected String _textValue;

    public ApacheAvroParserImpl(IOContext ctxt, int parserFeatures, int avroFeatures, ObjectCodec codec, InputStream in) {
        super(ctxt, parserFeatures, avroFeatures, codec);
        this._inputStream = in;
        this._inputBuffer = ctxt.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._bufferRecyclable = true;
        this._decoder = ApacheCodecRecycler.decoder(in, AvroParser.Feature.AVRO_BUFFERING.enabledIn(avroFeatures));
    }

    public ApacheAvroParserImpl(IOContext ctxt, int parserFeatures, int avroFeatures, ObjectCodec codec, byte[] data, int offset, int len) {
        super(ctxt, parserFeatures, avroFeatures, codec);
        this._inputStream = null;
        this._decoder = ApacheCodecRecycler.decoder(data, offset, len);
    }

    protected void _releaseBuffers() throws IOException {
        BinaryDecoder d;
        byte[] buf;
        super._releaseBuffers();
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(buf);
        }
        if ((d = this._decoder) != null) {
            this._decoder = null;
            ApacheCodecRecycler.release(d);
        }
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            this._inputStream.close();
        }
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public String nextTextValue() throws IOException {
        return this.nextToken() == JsonToken.VALUE_STRING ? this._textValue : null;
    }

    @Override
    public String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textValue;
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._avroContext.getCurrentName();
        }
        if (this._currToken != null) {
            if (this._currToken.isScalarValue()) {
                return this._textValue;
            }
            return this._currToken.asString();
        }
        return null;
    }

    @Override
    public int getText(Writer writer) throws IOException {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_STRING) {
            writer.write(this._textValue);
            return this._textValue.length();
        }
        if (t == JsonToken.FIELD_NAME) {
            String n = this._parsingContext.getCurrentName();
            writer.write(n);
            return n.length();
        }
        if (t != null) {
            if (t.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] ch = t.asCharArray();
            writer.write(ch);
            return ch.length;
        }
        return 0;
    }

    @Override
    public boolean checkInputEnd() throws IOException {
        return this._decoder.isEnd();
    }

    @Override
    public JsonToken decodeBoolean() throws IOException {
        return this._decoder.readBoolean() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
    }

    @Override
    public void skipBoolean() throws IOException {
        this._decoder.skipFixed(1);
    }

    @Override
    public int decodeInt() throws IOException {
        return this._decoder.readInt();
    }

    @Override
    public JsonToken decodeIntToken() throws IOException {
        this._numberInt = this._decoder.readInt();
        this._numTypesValid = 1;
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public void skipInt() throws IOException {
        this._decoder.readInt();
    }

    @Override
    public long decodeLong() throws IOException {
        return this._decoder.readLong();
    }

    @Override
    public JsonToken decodeLongToken() throws IOException {
        this._numberLong = this._decoder.readLong();
        this._numTypesValid = 2;
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public void skipLong() throws IOException {
        this._decoder.readLong();
    }

    @Override
    public JsonToken decodeFloat() throws IOException {
        this._numberFloat = this._decoder.readFloat();
        this._numTypesValid = 32;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public void skipFloat() throws IOException {
        this._decoder.skipFixed(4);
    }

    @Override
    public JsonToken decodeDouble() throws IOException {
        this._numberDouble = this._decoder.readDouble();
        this._numTypesValid = 8;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public void skipDouble() throws IOException {
        this._decoder.skipFixed(8);
    }

    @Override
    public void decodeString() throws IOException {
        this._textValue = this._decoder.readString();
    }

    @Override
    public JsonToken decodeStringToken() throws IOException {
        this.decodeString();
        return JsonToken.VALUE_STRING;
    }

    @Override
    public void skipString() throws IOException {
        this._decoder.skipString();
    }

    @Override
    public JsonToken decodeBytes() throws IOException {
        int len = this._decoder.readInt();
        if (len <= 0) {
            this._binaryValue = NO_BYTES;
        } else {
            byte[] b = new byte[len];
            this._decoder.readFixed(b, 0, len);
            this._binaryValue = b;
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public void skipBytes() throws IOException {
        this._decoder.skipBytes();
    }

    @Override
    public JsonToken decodeFixed(int size) throws IOException {
        byte[] data = new byte[size];
        this._decoder.readFixed(data);
        this._binaryValue = data;
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public void skipFixed(int size) throws IOException {
        this._decoder.skipFixed(size);
    }

    @Override
    public long decodeArrayStart() throws IOException {
        return this._decoder.readArrayStart();
    }

    @Override
    public long decodeArrayNext() throws IOException {
        return this._decoder.arrayNext();
    }

    @Override
    public long skipArray() throws IOException {
        return this._decoder.skipArray();
    }

    @Override
    public String decodeMapKey() throws IOException {
        return this._decoder.readString();
    }

    @Override
    public long decodeMapStart() throws IOException {
        return this._decoder.readMapStart();
    }

    @Override
    public long decodeMapNext() throws IOException {
        return this._decoder.mapNext();
    }

    @Override
    public long skipMap() throws IOException {
        return this._decoder.skipMap();
    }

    @Override
    public int decodeIndex() throws IOException {
        this._branchIndex = this._decoder.readIndex();
        return this._branchIndex;
    }

    @Override
    public int decodeEnum() throws IOException {
        this._enumIndex = this._decoder.readEnum();
        return this._enumIndex;
    }

    @Override
    protected JsonToken setString(String str) {
        this._textValue = str;
        return JsonToken.VALUE_STRING;
    }
}

