/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.implementation.http.rest.Substitution;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RangeReplaceSubstitution
extends Substitution {
    private final List<Range> ranges = new ArrayList<Range>();

    public RangeReplaceSubstitution(String urlParameterName, int methodParameterIndex, boolean shouldEncode, String substitutionBase) {
        super(urlParameterName, methodParameterIndex, shouldEncode);
        String placeholder = "{" + urlParameterName + "}";
        int indexOf = 0;
        while ((indexOf = substitutionBase.indexOf(placeholder, indexOf)) != -1) {
            this.ranges.add(new Range(indexOf, indexOf + placeholder.length()));
            indexOf += placeholder.length();
        }
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    static final class Range
    implements Comparable<Range> {
        private final int start;
        private final int end;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getSize() {
            return this.end - this.start;
        }

        @Override
        public int compareTo(Range o) {
            if (this.start < o.start) {
                return -1;
            }
            if (this.start > o.start) {
                return 1;
            }
            return Integer.compare(this.end, o.end);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Range)) {
                return false;
            }
            Range other = (Range)obj;
            return this.start == other.start && this.end == other.end;
        }
    }
}

