/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsonoutput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputField;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class JsonOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = JsonOutputMeta.class;
    private Label wlEncoding;
    private ComboVar wEncoding;
    private Label wlOutputValue;
    private TextVar wOutputValue;
    private Button wCompatibilityMode;
    private TextVar wBlocName;
    private TextVar wNrRowsInBloc;
    private TableView wFields;
    private final JsonOutputMeta input;
    private boolean gotEncodings = false;
    private ColumnInfo[] colinf;
    private Label wlAddToResult;
    private Button wAddToResult;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;
    private Label wlExtension;
    private TextVar wExtension;
    private Label wlCreateParentFolder;
    private Button wCreateParentFolder;
    private Label wlDoNotOpenNewFileInit;
    private Button wDoNotOpenNewFileInit;
    private Label wlAddDate;
    private Button wAddDate;
    private Label wlAddTime;
    private Button wAddTime;
    private Button wbShowFiles;
    private Label wlAppend;
    private Button wAppend;
    private CCombo wOperation;
    private final List<String> inputFields = new ArrayList<String>();

    public JsonOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (JsonOutputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.GeneralTab.TabTitle", (String[])new String[0]));
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        wGeneralComp.setLayout((Layout)generalLayout);
        Label wlOperation = new Label(wGeneralComp, 131072);
        wlOperation.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Operation.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOperation);
        FormData fdlOperation = new FormData();
        fdlOperation.left = new FormAttachment(0, 0);
        fdlOperation.right = new FormAttachment(middle, -margin);
        fdlOperation.top = new FormAttachment((Control)this.wNrRowsInBloc, margin);
        wlOperation.setLayoutData((Object)fdlOperation);
        this.wOperation = new CCombo(wGeneralComp, 2056);
        PropsUi.setLook((Widget)this.wOperation);
        this.wOperation.addModifyListener(lsMod);
        FormData fdOperation = new FormData();
        fdOperation.left = new FormAttachment(middle, 0);
        fdOperation.top = new FormAttachment((Control)this.wNrRowsInBloc, margin);
        fdOperation.right = new FormAttachment(100, -margin);
        this.wOperation.setLayoutData((Object)fdOperation);
        String[] operationTypeDescArray = JsonOutputMeta.operationDescType.keySet().toArray(new String[JsonOutputMeta.operationDescType.size()]);
        this.wOperation.setItems(operationTypeDescArray);
        this.wOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.updateOperation();
            }
        });
        Group wSettings = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Group.Settings.Label", (String[])new String[0]));
        FormLayout groupFileLayout = new FormLayout();
        groupFileLayout.marginWidth = 10;
        groupFileLayout.marginHeight = 10;
        wSettings.setLayout((Layout)groupFileLayout);
        Label wlBlocName = new Label((Composite)wSettings, 131072);
        wlBlocName.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.BlocName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBlocName);
        FormData fdlBlocName = new FormData();
        fdlBlocName.left = new FormAttachment(0, 0);
        fdlBlocName.top = new FormAttachment((Control)this.wOperation, margin);
        fdlBlocName.right = new FormAttachment(middle, -margin);
        wlBlocName.setLayoutData((Object)fdlBlocName);
        this.wBlocName = new TextVar(this.variables, (Composite)wSettings, 2056);
        this.wBlocName.setEditable(true);
        PropsUi.setLook((Widget)this.wBlocName);
        this.wBlocName.addModifyListener(lsMod);
        FormData fdBlocName = new FormData();
        fdBlocName.left = new FormAttachment(middle, 0);
        fdBlocName.top = new FormAttachment((Control)this.wOperation, margin);
        fdBlocName.right = new FormAttachment(100, 0);
        this.wBlocName.setLayoutData((Object)fdBlocName);
        Label wlNrRowsInBloc = new Label((Composite)wSettings, 131072);
        wlNrRowsInBloc.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.NrRowsInBloc.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNrRowsInBloc);
        FormData fdlNrRowsInBloc = new FormData();
        fdlNrRowsInBloc.left = new FormAttachment(0, 0);
        fdlNrRowsInBloc.top = new FormAttachment((Control)this.wBlocName, margin);
        fdlNrRowsInBloc.right = new FormAttachment(middle, -margin);
        wlNrRowsInBloc.setLayoutData((Object)fdlNrRowsInBloc);
        this.wNrRowsInBloc = new TextVar(this.variables, (Composite)wSettings, 2056);
        this.wNrRowsInBloc.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.NrRowsInBloc.ToolTip", (String[])new String[0]));
        this.wNrRowsInBloc.setEditable(true);
        PropsUi.setLook((Widget)this.wNrRowsInBloc);
        this.wNrRowsInBloc.addModifyListener(lsMod);
        FormData fdNrRowsInBloc = new FormData();
        fdNrRowsInBloc.left = new FormAttachment(middle, 0);
        fdNrRowsInBloc.top = new FormAttachment((Control)this.wBlocName, margin);
        fdNrRowsInBloc.right = new FormAttachment(100, 0);
        this.wNrRowsInBloc.setLayoutData((Object)fdNrRowsInBloc);
        this.wlOutputValue = new Label((Composite)wSettings, 131072);
        this.wlOutputValue.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.OutputValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlOutputValue);
        FormData fdlOutputValue = new FormData();
        fdlOutputValue.left = new FormAttachment(0, 0);
        fdlOutputValue.top = new FormAttachment((Control)this.wNrRowsInBloc, margin);
        fdlOutputValue.right = new FormAttachment(middle, -margin);
        this.wlOutputValue.setLayoutData((Object)fdlOutputValue);
        this.wOutputValue = new TextVar(this.variables, (Composite)wSettings, 2056);
        this.wOutputValue.setEditable(true);
        PropsUi.setLook((Widget)this.wOutputValue);
        this.wOutputValue.addModifyListener(lsMod);
        FormData fdOutputValue = new FormData();
        fdOutputValue.left = new FormAttachment(middle, 0);
        fdOutputValue.top = new FormAttachment((Control)this.wNrRowsInBloc, margin);
        fdOutputValue.right = new FormAttachment(100, 0);
        this.wOutputValue.setLayoutData((Object)fdOutputValue);
        Label wlCompatibilityMode = new Label((Composite)wSettings, 131072);
        wlCompatibilityMode.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.CompatibilityMode.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCompatibilityMode);
        FormData fdlCompatibilityMode = new FormData();
        fdlCompatibilityMode.left = new FormAttachment(0, 0);
        fdlCompatibilityMode.top = new FormAttachment((Control)this.wOutputValue, margin);
        fdlCompatibilityMode.right = new FormAttachment(middle, -margin);
        wlCompatibilityMode.setLayoutData((Object)fdlCompatibilityMode);
        this.wCompatibilityMode = new Button((Composite)wSettings, 32);
        this.wCompatibilityMode.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.CompatibilityMode.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCompatibilityMode);
        FormData fdCompatibilityMode = new FormData();
        fdCompatibilityMode.left = new FormAttachment(middle, 0);
        fdCompatibilityMode.top = new FormAttachment((Control)wlCompatibilityMode, 0, 0x1000000);
        fdCompatibilityMode.right = new FormAttachment(100, 0);
        this.wCompatibilityMode.setLayoutData((Object)fdCompatibilityMode);
        this.wCompatibilityMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)this.wOperation, 2 * margin);
        fdSettings.right = new FormAttachment(100, -margin);
        wSettings.setLayoutData((Object)fdSettings);
        Group wFileName = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wFileName);
        wFileName.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Group.File.Label", (String[])new String[0]));
        FormLayout groupfilenameayout = new FormLayout();
        groupfilenameayout.marginWidth = 10;
        groupfilenameayout.marginHeight = 10;
        wFileName.setLayout((Layout)groupfilenameayout);
        this.wlFilename = new Label((Composite)wFileName, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)wSettings, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbFilename = new Button((Composite)wFileName, 0x1000008);
        PropsUi.setLook((Widget)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)wSettings, 0);
        this.wbFilename.setLayoutData((Object)fdbFilename);
        this.wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((boolean)true, (Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.js", "*.json", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.JsonFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        this.wFilename = new TextVar(this.variables, (Composite)wFileName, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wOutputValue, margin);
        fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wlAppend = new Label((Composite)wFileName, 131072);
        this.wlAppend.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Append.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAppend);
        FormData fdlAppend = new FormData();
        fdlAppend.left = new FormAttachment(0, 0);
        fdlAppend.top = new FormAttachment((Control)this.wFilename, margin);
        fdlAppend.right = new FormAttachment(middle, -margin);
        this.wlAppend.setLayoutData((Object)fdlAppend);
        this.wAppend = new Button((Composite)wFileName, 32);
        this.wAppend.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Append.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAppend);
        FormData fdAppend = new FormData();
        fdAppend.left = new FormAttachment(middle, 0);
        fdAppend.top = new FormAttachment((Control)this.wlAppend, 0, 0x1000000);
        fdAppend.right = new FormAttachment(100, 0);
        this.wAppend.setLayoutData((Object)fdAppend);
        this.wAppend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wlCreateParentFolder = new Label((Composite)wFileName, 131072);
        this.wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.CreateParentFolder.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCreateParentFolder);
        FormData fdlCreateParentFolder = new FormData();
        fdlCreateParentFolder.left = new FormAttachment(0, 0);
        fdlCreateParentFolder.top = new FormAttachment((Control)this.wAppend, margin);
        fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        this.wlCreateParentFolder.setLayoutData((Object)fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)wFileName, 32);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCreateParentFolder);
        FormData fdCreateParentFolder = new FormData();
        fdCreateParentFolder.left = new FormAttachment(middle, 0);
        fdCreateParentFolder.top = new FormAttachment((Control)this.wlCreateParentFolder, 0, 0x1000000);
        fdCreateParentFolder.right = new FormAttachment(100, 0);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wlDoNotOpenNewFileInit = new Label((Composite)wFileName, 131072);
        this.wlDoNotOpenNewFileInit.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.DoNotOpenNewFileInit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDoNotOpenNewFileInit);
        FormData fdlDoNotOpenNewFileInit = new FormData();
        fdlDoNotOpenNewFileInit.left = new FormAttachment(0, 0);
        fdlDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        fdlDoNotOpenNewFileInit.right = new FormAttachment(middle, -margin);
        this.wlDoNotOpenNewFileInit.setLayoutData((Object)fdlDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit = new Button((Composite)wFileName, 32);
        this.wDoNotOpenNewFileInit.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.DoNotOpenNewFileInit.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wDoNotOpenNewFileInit);
        FormData fdDoNotOpenNewFileInit = new FormData();
        fdDoNotOpenNewFileInit.left = new FormAttachment(middle, 0);
        fdDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wlDoNotOpenNewFileInit, 0, 0x1000000);
        fdDoNotOpenNewFileInit.right = new FormAttachment(100, 0);
        this.wDoNotOpenNewFileInit.setLayoutData((Object)fdDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wlExtension = new Label((Composite)wFileName, 131072);
        this.wlExtension.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlExtension);
        FormData fdlExtension = new FormData();
        fdlExtension.left = new FormAttachment(0, 0);
        fdlExtension.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        fdlExtension.right = new FormAttachment(middle, -margin);
        this.wlExtension.setLayoutData((Object)fdlExtension);
        this.wExtension = new TextVar(this.variables, (Composite)wFileName, 18436);
        PropsUi.setLook((Widget)this.wExtension);
        this.wExtension.addModifyListener(lsMod);
        FormData fdExtension = new FormData();
        fdExtension.left = new FormAttachment(middle, 0);
        fdExtension.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        fdExtension.right = new FormAttachment(100, -margin);
        this.wExtension.setLayoutData((Object)fdExtension);
        this.wlEncoding = new Label((Composite)wFileName, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)this.wExtension, margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        this.wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new ComboVar(this.variables, (Composite)wFileName, 2056);
        this.wEncoding.setEditable(true);
        PropsUi.setLook((Widget)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wExtension, margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)JsonOutputDialog.this.shell.getDisplay(), 1);
                JsonOutputDialog.this.shell.setCursor(busy);
                JsonOutputDialog.this.setEncodings();
                JsonOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlAddDate = new Label((Composite)wFileName, 131072);
        this.wlAddDate.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.AddDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddDate);
        FormData fdlAddDate = new FormData();
        fdlAddDate.left = new FormAttachment(0, 0);
        fdlAddDate.top = new FormAttachment((Control)this.wEncoding, margin);
        fdlAddDate.right = new FormAttachment(middle, -margin);
        this.wlAddDate.setLayoutData((Object)fdlAddDate);
        this.wAddDate = new Button((Composite)wFileName, 32);
        PropsUi.setLook((Widget)this.wAddDate);
        FormData fdAddDate = new FormData();
        fdAddDate.left = new FormAttachment(middle, 0);
        fdAddDate.top = new FormAttachment((Control)this.wlAddDate, 0, 0x1000000);
        fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddTime = new Label((Composite)wFileName, 131072);
        this.wlAddTime.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.AddTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddTime);
        FormData fdlAddTime = new FormData();
        fdlAddTime.left = new FormAttachment(0, 0);
        fdlAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        fdlAddTime.right = new FormAttachment(middle, -margin);
        this.wlAddTime.setLayoutData((Object)fdlAddTime);
        this.wAddTime = new Button((Composite)wFileName, 32);
        PropsUi.setLook((Widget)this.wAddTime);
        FormData fdAddTime = new FormData();
        fdAddTime.left = new FormAttachment(middle, 0);
        fdAddTime.top = new FormAttachment((Control)this.wlAddTime, 0, 0x1000000);
        fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wbShowFiles = new Button((Composite)wFileName, 0x1000008);
        PropsUi.setLook((Widget)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(middle, 0);
        fdbShowFiles.top = new FormAttachment((Control)this.wAddTime, margin * 2);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputMeta tfoi = new JsonOutputMeta();
                JsonOutputDialog.this.getInfo(tfoi);
                String[] files = tfoi.getFiles(JsonOutputDialog.this.variables);
                if (files != null && files.length > 0) {
                    EnterSelectionDialog esd = new EnterSelectionDialog(JsonOutputDialog.this.shell, files, BaseMessages.getString(PKG, (String)"JsonOutputDialog.SelectOutputFiles.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JsonOutputDialog.SelectOutputFiles.DialogMessage", (String[])new String[0]));
                    esd.setViewOnly();
                    esd.open();
                } else {
                    MessageBox mb = new MessageBox(JsonOutputDialog.this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"JsonOutputDialog.NoFilesFound.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.DialogTitle.Error", (String[])new String[0]));
                    mb.open();
                }
            }
        });
        this.wlAddToResult = new Label((Composite)wFileName, 131072);
        this.wlAddToResult.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.AddFileToResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddToResult);
        FormData fdlAddToResult = new FormData();
        fdlAddToResult.left = new FormAttachment(0, 0);
        fdlAddToResult.top = new FormAttachment((Control)this.wbShowFiles, margin);
        fdlAddToResult.right = new FormAttachment(middle, -margin);
        this.wlAddToResult.setLayoutData((Object)fdlAddToResult);
        this.wAddToResult = new Button((Composite)wFileName, 32);
        this.wAddToResult.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.AddFileToResult.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAddToResult);
        FormData fdAddToResult = new FormData();
        fdAddToResult.left = new FormAttachment(middle, 0);
        fdAddToResult.top = new FormAttachment((Control)this.wlAddToResult, 0, 0x1000000);
        fdAddToResult.right = new FormAttachment(100, 0);
        this.wAddToResult.setLayoutData((Object)fdAddToResult);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                JsonOutputDialog.this.input.setChanged();
            }
        };
        this.wAddToResult.addSelectionListener((SelectionListener)lsSelR);
        FormData fdFileName = new FormData();
        fdFileName.left = new FormAttachment(0, margin);
        fdFileName.top = new FormAttachment((Control)wSettings, 2 * margin);
        fdFileName.right = new FormAttachment(100, -margin);
        wFileName.setLayoutData((Object)fdFileName);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = PropsUi.getFormMargin();
        fieldsLayout.marginHeight = PropsUi.getFormMargin();
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        PropsUi.setLook((Widget)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Get.Button", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Get.Tooltip", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wGet}, margin, null);
        int FieldsRows = this.input.getOutputFields().size();
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JsonOutputDialog.ElementName.Column", (String[])new String[0]), 1, false)};
        this.colinf[1].setUsingVariables(true);
        this.wFields = new TableView(this.variables, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wGet.addListener(13, e -> this.get());
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        wTabFolder.setSelection(0);
        this.getData();
        this.updateOperation();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            } else {
                this.wEncoding.select(Const.indexOfString((String)"UTF-8", (String[])this.wEncoding.getItems()));
            }
        }
    }

    public void getData() {
        this.wBlocName.setText(Const.NVL((String)this.input.getJsonBloc(), (String)""));
        this.wNrRowsInBloc.setText(Const.NVL((String)this.input.getNrRowsInBloc(), (String)""));
        this.wEncoding.setText(Const.NVL((String)this.input.getEncoding(), (String)""));
        this.wOutputValue.setText(Const.NVL((String)this.input.getOutputValue(), (String)""));
        this.wCompatibilityMode.setSelection(this.input.isCompatibilityMode());
        this.wOperation.setText(JsonOutputMeta.operationTypeDesc.get(this.input.getOperationType()));
        this.wFilename.setText(Const.NVL((String)this.input.getFileName(), (String)""));
        this.wCreateParentFolder.setSelection(this.input.isCreateParentFolder());
        this.wExtension.setText(Const.NVL((String)this.input.getExtension(), (String)"js"));
        this.wAddDate.setSelection(this.input.isDateInFilename());
        this.wAddTime.setSelection(this.input.isTimeInFilename());
        this.wAppend.setSelection(this.input.isFileAppended());
        this.wEncoding.setText(Const.NVL((String)this.input.getEncoding(), (String)""));
        this.wAddToResult.setSelection(this.input.isAddToResult());
        this.wDoNotOpenNewFileInit.setSelection(this.input.isDoNotOpenNewFileInit());
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        for (int i = 0; i < this.input.getOutputFields().size(); ++i) {
            JsonOutputField field = this.input.getOutputFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getFieldName(), (String)""));
            item.setText(2, Const.NVL((String)field.getElementName(), (String)""));
        }
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(JsonOutputMeta jsometa) {
        jsometa.setJsonBloc(this.wBlocName.getText());
        jsometa.setNrRowsInBloc(this.wNrRowsInBloc.getText());
        jsometa.setEncoding(this.wEncoding.getText());
        jsometa.setOutputValue(this.wOutputValue.getText());
        jsometa.setCompatibilityMode(this.wCompatibilityMode.getSelection());
        jsometa.setOperationType(JsonOutputMeta.operationDescType.get(this.wOperation.getText()));
        jsometa.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        jsometa.setFileName(this.wFilename.getText());
        jsometa.setExtension(this.wExtension.getText());
        jsometa.setFileAppended(this.wAppend.getSelection());
        jsometa.setDateInFilename(this.wAddDate.getSelection());
        jsometa.setTimeInFilename(this.wAddTime.getSelection());
        jsometa.setEncoding(this.wEncoding.getText());
        jsometa.setAddToResult(this.wAddToResult.getSelection());
        jsometa.setDoNotOpenNewFileInit(this.wDoNotOpenNewFileInit.getSelection());
        int nrFields = this.wFields.nrNonEmpty();
        this.input.getOutputFields().clear();
        for (int i = 0; i < nrFields; ++i) {
            JsonOutputField field = new JsonOutputField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setFieldName(item.getText(1));
            field.setElementName(item.getText(2));
            jsometa.getOutputFields().add(field);
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)5, (int)6, (tableItem, v) -> {
                    if (v.isNumber() && v.getLength() > 0) {
                        int m;
                        int le = v.getLength();
                        int pr = v.getPrecision();
                        if (v.getPrecision() <= 0) {
                            pr = 0;
                        }
                        Object mask = " ";
                        for (m = 0; m < le - pr; ++m) {
                            mask = (String)mask + "0";
                        }
                        if (pr > 0) {
                            mask = (String)mask + ".";
                        }
                        for (m = 0; m < pr; ++m) {
                            mask = (String)mask + "0";
                        }
                        tableItem.setText(4, (String)mask);
                    }
                    return true;
                });
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void updateOperation() {
        String opType = this.wOperation.getText();
        boolean activeFile = !opType.equals("outputvalue");
        this.wlFilename.setEnabled(activeFile);
        this.wFilename.setEnabled(activeFile);
        this.wbFilename.setEnabled(activeFile);
        this.wlExtension.setEnabled(activeFile);
        this.wExtension.setEnabled(activeFile);
        this.wlEncoding.setEnabled(activeFile);
        this.wEncoding.setEnabled(activeFile);
        this.wlAppend.setEnabled(activeFile);
        this.wAppend.setEnabled(activeFile);
        this.wlCreateParentFolder.setEnabled(activeFile);
        this.wCreateParentFolder.setEnabled(activeFile);
        this.wlDoNotOpenNewFileInit.setEnabled(activeFile);
        this.wDoNotOpenNewFileInit.setEnabled(activeFile);
        this.wlAddDate.setEnabled(activeFile);
        this.wAddDate.setEnabled(activeFile);
        this.wlAddTime.setEnabled(activeFile);
        this.wAddTime.setEnabled(activeFile);
        this.wlAddToResult.setEnabled(activeFile);
        this.wAddToResult.setEnabled(activeFile);
        this.wbShowFiles.setEnabled(activeFile);
        boolean activeOutputValue = !Objects.equals(this.wOperation.getText(), "writetofile");
        this.wlOutputValue.setEnabled(activeOutputValue);
        this.wOutputValue.setEnabled(activeOutputValue);
    }
}

