/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.html.HTMLTable;
import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTableHeader;
import com.ibm.as400.util.html.HTMLTableRow;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import com.ibm.as400.util.html.LineLayoutFormPanel;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.SectionCompletedListener;
import com.ibm.as400.util.servlet.SectionCompletedSupport;
import com.ibm.as400.util.servlet.StringConverter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLTableConverter
extends StringConverter
implements Serializable {
    static final long serialVersionUID = 9154342923705960360L;
    private HTMLTable htmlTable_;
    private HTMLHyperlink[] links_;
    private int maxTableSize_ = 0;
    private boolean useMetaData_ = false;
    private transient Vector completedListeners_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private transient SectionCompletedSupport sectionCompletedSupport_;

    public void addActionCompletedListener(ActionCompletedListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.completedListeners_ == null) {
            this.completedListeners_ = new Vector();
        }
        this.completedListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addSectionCompletedListener(SectionCompletedListener listener) {
        if (this.sectionCompletedSupport_ == null) {
            this.sectionCompletedSupport_ = new SectionCompletedSupport(this);
        }
        this.sectionCompletedSupport_.addSectionCompletedListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private HTMLTable[] calculateNumberOfTables(int numberRows) {
        int numTables = 1;
        if (this.maxTableSize_ > 0 && numberRows > 0) {
            numTables = numberRows / this.maxTableSize_;
            if (numberRows % this.maxTableSize_ != 0) {
                ++numTables;
            }
        }
        return new HTMLTable[numTables];
    }

    private HTMLTable[] convertRowData(RowData rowdata, RowMetaData metadata) throws PropertyVetoException, RowDataException {
        HTMLTable[] tables = this.calculateNumberOfTables(rowdata.length());
        for (int i = 0; i < tables.length; ++i) {
            tables[i] = this.convertRowData(rowdata, metadata, i);
        }
        return tables;
    }

    private HTMLTable convertRowData(RowData rowdata, RowMetaData metadata, int page) throws PropertyVetoException, RowDataException {
        if (metadata == null) {
            Trace.log(2, "The rowdata's metadata attribute is invalid.");
            throw new ExtendedIllegalStateException("rowdata metadata", 4);
        }
        if (page < 0) {
            throw new ExtendedIllegalArgumentException("page", 4);
        }
        if (this.htmlTable_ == null) {
            this.setUseMetaData(true);
            try {
                this.htmlTable_ = new HTMLTable();
                this.htmlTable_.setHeaderInUse(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (this.isUseMetaData()) {
            this.setTableHeader(metadata);
        }
        HTMLTable table = this.createDefaultTable();
        if (rowdata.length() == 0) {
            return table;
        }
        long numRowsInTable = 1L;
        int numColumns = metadata.getColumnCount();
        if (page == 0) {
            rowdata.beforeFirst();
        } else {
            rowdata.absolute(this.maxTableSize_ * page - 1);
        }
        int rowLocation = 0;
        if (this.maxTableSize_ == 0) {
            this.maxTableSize_ = rowdata.length();
        }
        while (rowdata.next() && this.maxTableSize_ > rowLocation) {
            if (this.maxTableSize_ > 0 && numRowsInTable > 1L && numRowsInTable % (long)this.maxTableSize_ == 1L && this.sectionCompletedSupport_ != null) {
                this.sectionCompletedSupport_.fireSectionCompleted(table.getTag());
            }
            HTMLTableRow row = new HTMLTableRow();
            for (int column = 0; column < numColumns; ++column) {
                Object columnObject;
                Vector properties;
                HTMLTableCell cell = new HTMLTableCell();
                if (metadata.isNumericData(column)) {
                    cell.setHorizontalAlignment("right");
                }
                if ((properties = rowdata.getObjectProperties(column)) != null) {
                    int propSize = properties.size();
                    for (int index = 0; index < propSize; ++index) {
                        if (!(properties.elementAt(index) instanceof HTMLTableCell)) continue;
                        cell = (HTMLTableCell)properties.elementAt(index);
                    }
                }
                if ((columnObject = rowdata.getObject(column)) == null) {
                    columnObject = new LineLayoutFormPanel();
                }
                try {
                    cell.setElement((HTMLTagElement)columnObject);
                }
                catch (ClassCastException e) {
                    cell.setElement(new HTMLText(columnObject.toString()));
                }
                if (metadata.getColumnAlignment(column) != null) {
                    cell.setHorizontalAlignment(metadata.getColumnAlignment(column));
                }
                if (metadata.getColumnDirection(column) != null) {
                    cell.setDirection(metadata.getColumnDirection(column));
                }
                row.addColumn(cell);
            }
            table.addRow(row);
            ++numRowsInTable;
            ++rowLocation;
        }
        if (this.sectionCompletedSupport_ != null) {
            this.sectionCompletedSupport_.fireSectionCompleted(table.getTag());
        }
        this.fireCompleted();
        return table;
    }

    public HTMLTable[] convertToTables(RowData rowdata) throws PropertyVetoException, RowDataException {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        HTMLTable[] tables = this.convertRowData(rowdata, rowdata.getMetaData());
        return tables;
    }

    public HTMLTable convertToTable(RowData rowdata, int page) throws PropertyVetoException, RowDataException {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        HTMLTable table = this.convertRowData(rowdata, rowdata.getMetaData(), page);
        return table;
    }

    private HTMLTable createDefaultTable() {
        HTMLTable table = new HTMLTable();
        try {
            if (this.htmlTable_.getHeader() != null) {
                table.setHeader(this.htmlTable_.getHeader());
            }
            if (this.htmlTable_.getCaption() != null) {
                table.setCaption(this.htmlTable_.getCaption());
            }
            if (this.htmlTable_.getAlignment() != null) {
                table.setAlignment(this.htmlTable_.getAlignment());
            }
            table.setBorderWidth(this.htmlTable_.getBorderWidth());
            table.setCellPadding(this.htmlTable_.getCellPadding());
            table.setCellSpacing(this.htmlTable_.getCellSpacing());
            table.setWidth(this.htmlTable_.getWidth(), this.htmlTable_.isWidthInPercent());
            table.setHeaderInUse(this.htmlTable_.isHeaderInUse());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return table;
    }

    @Override
    String[] doConvert(RowData rowdata, RowMetaData metadata) throws PropertyVetoException, RowDataException {
        HTMLTable[] tables = this.convertRowData(rowdata, metadata);
        String[] data = new String[tables.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = tables[i].getTag();
        }
        return data;
    }

    private void fireCompleted() {
        if (this.completedListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.completedListeners_.clone();
        ActionCompletedEvent event = new ActionCompletedEvent(this);
        for (int i = 0; i < targets.size(); ++i) {
            ActionCompletedListener target = (ActionCompletedListener)targets.elementAt(i);
            target.actionCompleted(event);
        }
    }

    public HTMLHyperlink[] getHeaderHyperlinks() {
        return this.links_;
    }

    public int getMaximumTableSize() {
        return this.maxTableSize_;
    }

    public HTMLHyperlink getObjectHyperlink(RowData rowdata, int column) {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        return this.getObjectHyperlink(rowdata, rowdata.getCurrentPosition(), column);
    }

    public HTMLHyperlink getObjectHyperlink(RowData rowdata, int row, int column) {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        if (!rowdata.absolute(row)) {
            throw new ExtendedIllegalArgumentException("row", 4);
        }
        Vector properties = rowdata.getObjectProperties(column);
        HTMLHyperlink link = null;
        if (properties != null) {
            int size = properties.size();
            for (int index = 0; index < size; ++index) {
                if (!(properties.elementAt(index) instanceof HTMLHyperlink)) continue;
                link = (HTMLHyperlink)properties.elementAt(index);
                break;
            }
        }
        return link;
    }

    public HTMLTable getTable() {
        return this.htmlTable_;
    }

    public boolean isUseMetaData() {
        return this.useMetaData_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeActionCompletedListener(ActionCompletedListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.completedListeners_ != null) {
            this.completedListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeSectionCompletedListener(SectionCompletedListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.sectionCompletedSupport_ != null) {
            this.sectionCompletedSupport_.removeSectionCompletedListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setHeaderHyperlinks(HTMLHyperlink[] links) throws PropertyVetoException {
        if (links == null) {
            throw new NullPointerException("links");
        }
        HTMLHyperlink[] old = this.links_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("links", old, links);
        }
        this.links_ = links;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("links", old, links);
        }
    }

    public void setMaximumTableSize(int size) throws PropertyVetoException {
        if (size < 0) {
            throw new ExtendedIllegalArgumentException("size", 4);
        }
        int oldSize = this.maxTableSize_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("size", (Object)oldSize, (Object)size);
        }
        this.maxTableSize_ = size;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("size", (Object)oldSize, (Object)size);
        }
    }

    public void setObjectHyperlink(RowData rowdata, HTMLHyperlink link, int column) throws RowDataException {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        this.setObjectHyperlink(rowdata, link, rowdata.getCurrentPosition(), column);
    }

    public void setObjectHyperlink(RowData rowdata, HTMLHyperlink link, int row, int column) throws RowDataException {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        if (link == null) {
            throw new NullPointerException("link");
        }
        if (!rowdata.absolute(row)) {
            throw new ExtendedIllegalArgumentException("row", 4);
        }
        Vector<HTMLHyperlink> properties = rowdata.getObjectProperties(column);
        if (properties == null) {
            properties = new Vector<HTMLHyperlink>();
            properties.addElement(link);
        } else {
            HTMLHyperlink old = null;
            int linkIndex = -1;
            int size = properties.size();
            for (int index = 0; index < size; ++index) {
                if (!(properties.elementAt(index) instanceof HTMLHyperlink)) continue;
                old = (HTMLHyperlink)properties.elementAt(index);
                linkIndex = index;
                break;
            }
            if (old == null) {
                properties.addElement(link);
            } else {
                properties.setElementAt(link, linkIndex);
            }
        }
        rowdata.setObjectProperties(properties, column);
    }

    public void setTable(HTMLTable table) throws PropertyVetoException {
        if (table == null) {
            throw new NullPointerException("table");
        }
        HTMLTable old = this.htmlTable_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("table", old, table);
        }
        this.htmlTable_ = table;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("table", old, table);
        }
    }

    private void setTableHeader(RowMetaData metadata) throws RowDataException, PropertyVetoException {
        int numColumns = metadata.getColumnCount();
        HTMLTableHeader[] headerList = new HTMLTableHeader[numColumns];
        String colName = "";
        for (int column = 0; column < numColumns; ++column) {
            HTMLTagAttributes element;
            try {
                colName = metadata.getColumnLabel(column);
            }
            catch (NullPointerException e) {
                colName = metadata.getColumnName(column);
            }
            if (this.links_ != null && this.links_[column] != null) {
                HTMLHyperlink link = this.links_[column];
                link.setText(colName);
                element = link;
            } else {
                element = new HTMLText(colName);
            }
            headerList[column] = new HTMLTableHeader(element);
        }
        this.htmlTable_.setHeader(headerList);
        if (!this.htmlTable_.isHeaderInUse()) {
            this.htmlTable_.setHeaderInUse(true);
        }
    }

    public void setUseMetaData(boolean useMetaData) {
        this.useMetaData_ = useMetaData;
    }
}

