/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.servlet.ServletHyperlink;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class URLParser {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private String url_;
    private String uri_;
    private String reference_;
    private Properties parameters_;

    public URLParser(String url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.url_ = url;
        this.parse(url);
    }

    public String getURL() {
        return this.url_;
    }

    public String getURI() {
        return this.uri_;
    }

    public static String getURI(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        String uri = request.getRequestURI();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            uri = uri.substring(0, uri.lastIndexOf(pathInfo));
        }
        return uri;
    }

    public String getReference() {
        return this.reference_;
    }

    public Properties getParameters() {
        return this.parameters_;
    }

    public HTMLHyperlink getHTMLHyperlink(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        return this.fillHyperlink(new HTMLHyperlink(), text);
    }

    public ServletHyperlink getServletHyperlink(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        return (ServletHyperlink)this.fillHyperlink(new ServletHyperlink(), text);
    }

    private HTMLHyperlink fillHyperlink(HTMLHyperlink link, String text) {
        try {
            if (this.reference_ == null) {
                link.setLink(this.uri_);
            } else {
                link.setLink(this.uri_ + "#" + this.reference_);
            }
            if (this.parameters_ != null) {
                link.setProperties(this.parameters_);
            }
            link.setText(text);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return link;
    }

    private void parse(String url) {
        String parms;
        int index = url.indexOf("?");
        if (index != -1) {
            this.uri_ = url.substring(0, index);
            parms = url.substring(index + 1);
        } else {
            this.uri_ = url;
            parms = null;
        }
        index = this.uri_.indexOf("#");
        if (index != -1) {
            this.reference_ = this.uri_.substring(index + 1);
            this.uri_ = this.uri_.substring(0, index);
        } else {
            this.reference_ = null;
        }
        if (parms != null) {
            this.parameters_ = new Properties();
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String value;
                String key;
                String parm = st.nextToken();
                index = parm.indexOf("=");
                if (index != -1) {
                    key = parm.substring(0, index);
                    value = parm.substring(index + 1);
                } else {
                    key = parm;
                    value = "";
                }
                this.parameters_.put(key, value);
            }
        }
    }
}

