/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagElement;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class LayoutFormPanel
implements HTMLTagElement,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7299636405173131600L;
    private Vector list = new Vector();
    private int cols;
    transient PropertyChangeSupport changes_;
    transient VetoableChangeSupport vetos_;
    transient Vector elementListeners_;

    public void addElement(HTMLTagElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.list.addElement(element);
        this.fireElementEvent(0);
    }

    public void addElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ == null) {
            this.elementListeners_ = new Vector();
        }
        this.elementListeners_.addElement(listener);
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners_.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    HTMLTagElement getElement(int index) {
        return (HTMLTagElement)this.list.elementAt(index);
    }

    public int getSize() {
        return this.list.size();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeElement(HTMLTagElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (this.list.removeElement(element)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ != null) {
            this.elementListeners_.removeElement(listener);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

