/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.util.html.HTMLTagElement;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;

public abstract class HTMLTagAttributes
implements HTMLTagElement,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = -8745891871151787644L;
    private Properties attributes_;
    transient PropertyChangeSupport changes_;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public Properties getAttributes() {
        return this.attributes_;
    }

    public String getAttributeString() {
        if (this.attributes_ == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("");
        Enumeration<?> e = this.attributes_.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            buffer.append(" ");
            buffer.append(s);
            buffer.append("=");
            buffer.append("\"");
            buffer.append(this.attributes_.getProperty(s));
            buffer.append("\"");
        }
        return buffer.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void setAttributes(Properties attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        Properties old = this.attributes_;
        this.attributes_ = attributes;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("attributes", old, this.attributes_);
        }
    }
}

