/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLTableRow
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -3968067893063774982L;
    private Vector row_ = new Vector();
    private String hAlign_;
    private String vAlign_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private int borderWidth_ = 1;
    private int cellPadding_ = 1;
    private transient Vector columnListeners_;
    private transient VetoableChangeSupport vetos_;

    public HTMLTableRow() {
    }

    public HTMLTableRow(HTMLTableCell[] cells) {
        this();
        if (cells == null) {
            throw new NullPointerException("cells");
        }
        for (int i = 0; i < cells.length; ++i) {
            this.row_.addElement(cells[i]);
        }
    }

    public void addColumn(HTMLTableCell cell) {
        if (cell == null) {
            throw new NullPointerException("cell");
        }
        this.row_.addElement(cell);
        this.fireAdded();
    }

    public void addColumnListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.columnListeners_ == null) {
            this.columnListeners_ = new Vector();
        }
        this.columnListeners_.addElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private void fireAdded() {
        if (this.columnListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.columnListeners_.clone();
        ElementEvent event = new ElementEvent(this, 0);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            target.elementAdded(event);
        }
    }

    private void fireChanged() {
        if (this.columnListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.columnListeners_.clone();
        ElementEvent event = new ElementEvent(this, 1);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            target.elementChanged(event);
        }
    }

    private void fireRemoved() {
        if (this.columnListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.columnListeners_.clone();
        ElementEvent event = new ElementEvent(this, 2);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            target.elementRemoved(event);
        }
    }

    public HTMLTableCell getColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.row_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        return (HTMLTableCell)this.row_.elementAt(columnIndex);
    }

    public int getColumnCount() {
        return this.row_.size();
    }

    public int getColumnIndex(HTMLTableCell cell) {
        if (cell == null) {
            throw new NullPointerException("cell");
        }
        return this.row_.indexOf(cell);
    }

    public int getColumnIndex(HTMLTableCell cell, int index) {
        if (cell == null) {
            throw new NullPointerException("cell");
        }
        if (index >= this.row_.size() || index < 0) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return this.row_.indexOf(cell, index);
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" dir=\"");
            buffer.append(this.dir_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    public String getHorizontalAlignment() {
        return this.hAlign_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" lang=\"");
            buffer.append(this.lang_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.row_.size() == 0) {
            Trace.log(2, "Attempting to get tag before adding a column to the row.");
            throw new ExtendedIllegalStateException("column", 4);
        }
        StringBuffer tag = new StringBuffer("<tr");
        if (this.hAlign_ != null) {
            tag.append(" align=\"");
            tag.append(this.hAlign_);
            tag.append("\"");
        }
        if (this.vAlign_ != null) {
            tag.append(" valign=\"");
            tag.append(this.vAlign_);
            tag.append("\"");
        }
        tag.append(this.getLanguageAttributeTag());
        tag.append(this.getDirectionAttributeTag());
        tag.append(this.getAttributeString());
        tag.append(">\n");
        for (int i = 0; i < this.row_.size(); ++i) {
            HTMLTableCell cell = (HTMLTableCell)this.row_.elementAt(i);
            tag.append(cell.getTag());
        }
        tag.append("</tr>\n");
        return tag.toString();
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        int size = this.row_.size();
        if (size == 0) {
            Trace.log(2, "Attempting to get XSL-FO tag before adding a column to the row.");
            throw new ExtendedIllegalStateException("column", 4);
        }
        StringBuffer tag = new StringBuffer("");
        tag.append("<fo:table-row");
        if (this.hAlign_ != null) {
            tag.append(" text-align=\"");
            if (this.hAlign_.equalsIgnoreCase("center")) {
                tag.append("center");
            } else if (this.hAlign_.equalsIgnoreCase("left")) {
                tag.append("start");
            } else if (this.hAlign_.equalsIgnoreCase("right")) {
                tag.append("end");
            }
            tag.append("\"");
        }
        tag.append(">\n");
        for (int i = 0; i < size; ++i) {
            HTMLTableCell cell = (HTMLTableCell)this.row_.elementAt(i);
            cell.setBorderWidth(this.borderWidth_);
            if (this.cellPadding_ > -1) {
                cell.setCellPadding(this.cellPadding_);
            }
            if (this.dir_ != null && this.dir_.length() > 0) {
                try {
                    cell.setDirection(this.dir_);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            tag.append(cell.getFOTag());
        }
        tag.append("</fo:table-row>\n");
        this.setUseFO(useFO);
        return tag.toString();
    }

    public String getVerticalAlignment() {
        return this.vAlign_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeAllColumns() {
        this.row_.removeAllElements();
        this.fireRemoved();
    }

    public void removeColumn(HTMLTableCell cell) {
        if (cell == null) {
            throw new NullPointerException("cell");
        }
        if (this.row_.removeElement(cell)) {
            this.fireRemoved();
        }
    }

    public void removeColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.row_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        this.row_.removeElement((HTMLTableCell)this.row_.elementAt(columnIndex));
        this.fireRemoved();
    }

    public void removeColumnListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.columnListeners_ != null) {
            this.columnListeners_.removeElement(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setColumn(HTMLTableCell cell, int columnIndex) {
        if (cell == null) {
            throw new NullPointerException("cell");
        }
        if (columnIndex > this.row_.size() || columnIndex < 0) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        if (columnIndex == this.row_.size()) {
            this.addColumn(cell);
        } else {
            this.row_.setElementAt(cell, columnIndex);
            this.fireChanged();
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setHorizontalAlignment(String alignment) throws PropertyVetoException {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (alignment.equalsIgnoreCase("left") || alignment.equalsIgnoreCase("center") || alignment.equalsIgnoreCase("right")) {
            String old = this.hAlign_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", old, alignment);
            }
            this.hAlign_ = alignment;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", old, alignment);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setBorderWidth(int borderWidth) {
        Integer oldWidth = this.borderWidth_;
        Integer newWidth = borderWidth;
        this.borderWidth_ = borderWidth;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("borderWidth", oldWidth, newWidth);
        }
    }

    public void setCellPadding(int cellPadding) {
        Integer oldPadding = this.cellPadding_;
        Integer newPadding = cellPadding;
        this.cellPadding_ = cellPadding;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellPadding", oldPadding, newPadding);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public void setVerticalAlignment(String alignment) throws PropertyVetoException {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (alignment.equalsIgnoreCase("top") || alignment.equalsIgnoreCase("middle") || alignment.equalsIgnoreCase("bottom") || alignment.equalsIgnoreCase("baseline")) {
            String old = this.vAlign_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", old, alignment);
            }
            this.vAlign_ = alignment;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", old, alignment);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

