/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLImage
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7792796091910634206L;
    private String name_;
    private String source_;
    private String align_;
    private String alt_;
    private int border_ = -1;
    private int height_ = 0;
    private int hspace_ = 0;
    private int width_ = 0;
    private int vspace_ = 0;
    private boolean useFO_ = false;

    public HTMLImage() {
    }

    public HTMLImage(String source, String alt) {
        this.setSrc(source);
        this.setAlt(alt);
    }

    public String getAlign() {
        return this.align_;
    }

    public String getAlt() {
        return this.alt_;
    }

    public int getBorder() {
        return this.border_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getHSpace() {
        return this.hspace_;
    }

    public String getName() {
        return this.name_;
    }

    public String getSrc() {
        return this.source_;
    }

    public int getVSpace() {
        return this.vspace_;
    }

    public int getWidth() {
        return this.width_;
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.source_ == null) {
            Trace.log(2, "Attempting to get tag before setting image source.");
            throw new ExtendedIllegalStateException("source", 4);
        }
        if (this.alt_ == null) {
            Trace.log(2, "Attempting to get tag before setting image alt.");
            throw new ExtendedIllegalStateException("alt", 4);
        }
        StringBuffer tag = new StringBuffer("<img");
        tag.append(" src=\"");
        tag.append(this.source_);
        tag.append("\"");
        tag.append(" alt=\"");
        tag.append(this.alt_);
        tag.append("\"");
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                tag.append(" align=\"left\"");
            } else if (this.align_.equals("right")) {
                tag.append(" align=\"right\"");
            } else if (this.align_.equals("top")) {
                tag.append(" align=\"top\"");
            } else if (this.align_.equals("texttop")) {
                tag.append(" align=\"texttop\"");
            } else if (this.align_.equals("middle")) {
                tag.append(" align=\"middle\"");
            } else if (this.align_.equals("absmiddle")) {
                tag.append(" align=\"absmiddle\"");
            } else if (this.align_.equals("baseline")) {
                tag.append(" align=\"baseline\"");
            } else if (this.align_.equals("bottom")) {
                tag.append(" align=\"bottom\"");
            } else if (this.align_.equals("absbottom")) {
                tag.append(" align=\"absbottom\"");
            }
        }
        if (this.name_ != null) {
            tag.append(" name=\"");
            tag.append(this.name_);
            tag.append("\"");
        }
        if (this.border_ > -1) {
            tag.append(" border=\"");
            tag.append(this.border_);
            tag.append("\"");
        }
        if (this.height_ > 0) {
            tag.append(" height=\"");
            tag.append(this.height_);
            tag.append("\"");
        }
        if (this.width_ > 0) {
            tag.append(" width=\"");
            tag.append(this.width_);
            tag.append("\"");
        }
        if (this.hspace_ > 0) {
            tag.append(" hspace=\"");
            tag.append(this.hspace_);
            tag.append("\"");
        }
        if (this.vspace_ > 0) {
            tag.append(" vspace=\"");
            tag.append(this.vspace_);
            tag.append("\"");
        }
        tag.append(this.getAttributeString());
        tag.append(" />");
        return tag.toString();
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        if (this.source_ == null) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting image source.");
            throw new ExtendedIllegalStateException("source", 4);
        }
        StringBuffer tag = new StringBuffer("");
        tag.append("<fo:block");
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                tag.append(" text-align='start'");
            } else if (this.align_.equals("right")) {
                tag.append(" text-align='end'");
            } else if (this.align_.equals("center")) {
                tag.append(" text-align='center'");
            }
        }
        tag.append(">\n");
        tag.append("<fo:external-graphic");
        tag.append(" src=\"file:");
        tag.append(this.source_);
        tag.append("\"");
        if (this.border_ > -1) {
            tag.append(" border-width=\"");
            tag.append(this.border_);
            tag.append("mm\"");
            tag.append(" border-style='solid'");
        }
        if (this.height_ > 0) {
            tag.append(" content-height=\"");
            tag.append(this.height_);
            tag.append("px\"");
        }
        if (this.width_ > 0) {
            tag.append(" content-width=\"");
            tag.append(this.width_);
            tag.append("px\"");
        }
        if (this.hspace_ > 0) {
            tag.append(" width=\"");
            tag.append(this.hspace_);
            tag.append("px\"");
        }
        if (this.vspace_ > 0) {
            tag.append(" height=\"");
            tag.append(this.vspace_);
            tag.append("px\"");
        }
        tag.append("/>\n");
        tag.append("</fo:block>\n");
        this.setUseFO(useFO);
        return tag.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setAlign(String align) {
        if (align == null) {
            throw new NullPointerException("align");
        }
        if (!(align.equals("left") || align.equals("right") || align.equals("top") || align.equals("texttop") || align.equals("middle") || align.equals("absmiddle") || align.equals("baseline") || align.equals("bottom") || align.equals("absbottom"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        String old = this.align_;
        this.align_ = align;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("align", old, align);
        }
    }

    public void setAlt(String alt) {
        if (alt == null) {
            throw new NullPointerException("alt");
        }
        String old = this.alt_;
        this.alt_ = alt;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("alt", old, alt);
        }
    }

    public void setBorder(int border) {
        if (border < 0) {
            throw new ExtendedIllegalArgumentException("border", 4);
        }
        int old = this.border_;
        this.border_ = border;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("border", (Object)old, (Object)border);
        }
    }

    public void setHeight(int height) {
        if (height < 0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        int old = this.height_;
        this.height_ = height;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", (Object)old, (Object)height);
        }
    }

    public void setHSpace(int hspace) {
        if (hspace < 0) {
            throw new ExtendedIllegalArgumentException("hspace", 4);
        }
        int old = this.hspace_;
        this.hspace_ = hspace;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("hspace", (Object)old, (Object)hspace);
        }
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String old = this.name_;
        this.name_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, name);
        }
    }

    public void setSrc(String source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        String old = this.source_;
        this.source_ = source;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("source", old, source);
        }
    }

    public void setVSpace(int vspace) {
        if (vspace < 0) {
            throw new ExtendedIllegalArgumentException("vspace", 4);
        }
        int old = this.vspace_;
        this.vspace_ = vspace;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("vspace", (Object)old, (Object)vspace);
        }
    }

    public void setWidth(int width) {
        if (width < 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int old = this.width_;
        this.width_ = width;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", (Object)old, (Object)width);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

