/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.URLEncoder;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;

public class HTMLHyperlink
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 83601853360783566L;
    private String bookmarkName_;
    private String link_;
    private Properties properties_;
    private String target_;
    private String text_;
    private String title_;
    private String location_;
    private String lang_;
    private String dir_;
    transient VetoableChangeSupport vetos_;

    public HTMLHyperlink() {
    }

    public HTMLHyperlink(String link) {
        if (link == null) {
            throw new NullPointerException("link");
        }
        this.link_ = link;
    }

    public HTMLHyperlink(String link, String text) {
        this(link);
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.text_ = text;
    }

    public HTMLHyperlink(String link, String text, String target) {
        this(link, text);
        if (target == null) {
            throw new NullPointerException("target");
        }
        this.target_ = target;
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public Object clone() {
        HTMLHyperlink l = new HTMLHyperlink();
        try {
            if (this.location_ != null) {
                l.setLocation(this.location_);
            }
            if (this.properties_ != null) {
                l.setProperties(this.properties_);
            }
            if (this.getAttributes() != null) {
                l.setAttributes(this.getAttributes());
            }
            if (this.link_ != null) {
                l.setLink(this.link_);
            }
            if (this.target_ != null) {
                l.setTarget(this.target_);
            }
            if (this.text_ != null) {
                l.setText(this.text_);
            }
            if (this.title_ != null) {
                l.setTitle(this.title_);
            }
            if (this.dir_ != null) {
                l.setDirection(this.dir_);
            }
            if (this.lang_ != null) {
                l.setLanguage(this.lang_);
            }
            if (this.bookmarkName_ != null) {
                l.setName(this.bookmarkName_);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return l;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public String getLink() {
        return this.link_;
    }

    public String getLocation() {
        return this.location_;
    }

    public String getName() {
        return this.bookmarkName_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public String getTarget() {
        return this.target_;
    }

    public String getText() {
        return this.text_;
    }

    public String getTitle() {
        return this.title_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLHyperlink was here -->";
    }

    @Override
    public String getTag() {
        return this.getTag(this.text_, this.properties_);
    }

    public String getTag(String text, Properties properties) {
        return this.getTag(text, this.bookmarkName_, this.link_, properties);
    }

    public String getTag(String text, String name, String link, Properties properties) {
        if (link == null) {
            Trace.log(2, "Attempting to get tag before setting the link.");
            throw new ExtendedIllegalStateException("link", 4);
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<a href=\"");
        buffer.append(link);
        if (properties != null) {
            String parmStart = "?";
            Enumeration<?> propertyList = properties.propertyNames();
            while (propertyList.hasMoreElements()) {
                String propName = (String)propertyList.nextElement();
                buffer.append(parmStart);
                buffer.append(URLEncoder.encode(propName));
                buffer.append("=");
                buffer.append(URLEncoder.encode(properties.getProperty(propName)));
                parmStart = "&";
            }
        }
        if (this.location_ != null) {
            buffer.append("#");
            buffer.append(this.location_);
        }
        buffer.append("\"");
        if (name != null) {
            buffer.append(" name=\"");
            buffer.append(name);
            buffer.append("\"");
        }
        if (this.title_ != null) {
            buffer.append(" title=\"");
            buffer.append(this.title_);
            buffer.append("\"");
        }
        if (this.target_ != null) {
            buffer.append(" target=\"");
            buffer.append(this.target_);
            buffer.append("\"");
        }
        buffer.append(this.getLanguageAttributeTag());
        buffer.append(this.getDirectionAttributeTag());
        buffer.append(this.getAttributeString());
        buffer.append(">");
        buffer.append(text);
        buffer.append("</a>");
        return new String(buffer);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setLocation(String location) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        String old = this.location_;
        this.location_ = location;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("location", old, location);
        }
    }

    public void setLink(String link) throws PropertyVetoException {
        if (link == null) {
            throw new NullPointerException("link");
        }
        String old = this.link_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("link", old, link);
        }
        this.link_ = link;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("link", old, link);
        }
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String old = this.bookmarkName_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", old, name);
        }
        this.bookmarkName_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, name);
        }
    }

    public void setProperties(Properties properties) throws PropertyVetoException {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        Properties old = this.properties_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("properties", old, properties);
        }
        this.properties_ = properties;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("properties", old, properties);
        }
    }

    public void setTarget(String target) throws PropertyVetoException {
        if (target == null) {
            throw new NullPointerException("target");
        }
        String old = this.target_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("target", old, target);
        }
        this.target_ = target;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("target", old, target);
        }
    }

    public void setText(String text) throws PropertyVetoException {
        if (text == null) {
            throw new NullPointerException("text");
        }
        String old = this.text_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("text", old, text);
        }
        this.text_ = text;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", old, text);
        }
    }

    public void setTitle(String title) throws PropertyVetoException {
        if (title == null) {
            throw new NullPointerException("title");
        }
        String old = this.title_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("title", old, title);
        }
        this.title_ = title;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("title", old, title);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

