/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.PersistenceException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ValidationListAttribute;
import com.ibm.as400.access.ValidationListAttributeInfo;
import com.ibm.as400.access.ValidationListEntry;
import com.ibm.as400.access.ValidationListTranslatedData;
import java.beans.PropertyVetoException;

public class ValidationList {
    private static int LISTBUFFER_LENGTH_INITIAL = 32768;
    private static int LISTBUFFER_LENGTH_NEXT = 524288;
    private AS400 as400_ = null;
    private AS400Structure listInfo_ = null;
    private AS400Structure vlde0100_ = null;
    private QSYSObjectPathName path_ = null;
    private String description_ = null;

    public ValidationList() {
    }

    public ValidationList(AS400 as400) {
        this();
        this.setAS400(as400);
    }

    public ValidationList(AS400 as400, QSYSObjectPathName path) {
        this();
        this.setAS400(as400);
        this.setPath(path);
    }

    public ValidationList(AS400 as400, String obj, String lib) {
        this();
        this.setAS400(as400);
        this.setPath(new QSYSObjectPathName(lib, obj, "vldl"));
    }

    public void addEntry(ValidationListEntry entry) throws PersistenceException {
        ProgramCall pgm = new ProgramCall(this.getAS400());
        ProgramParameter[] parmList = new ProgramParameter[6];
        try {
            pgm.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYADVLE", "PGM"), parmList);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        parmList[0] = this.getQualifiedNameParm();
        parmList[1] = new ProgramParameter(entry.getEntryID().toBytes());
        parmList[2] = new ProgramParameter(entry.getDataToEncrypt().toBytes());
        parmList[3] = new ProgramParameter(entry.getUnencryptedData().toBytes());
        parmList[4] = new ProgramParameter(entry.getAttributeInfo().toBytes());
        parmList[5] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(pgm);
    }

    public void changeEntry(ValidationListEntry entry) throws PersistenceException {
        ProgramCall pgm = new ProgramCall(this.getAS400());
        ProgramParameter[] parmList = new ProgramParameter[6];
        try {
            pgm.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYCHVLE", "PGM"), parmList);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        parmList[0] = this.getQualifiedNameParm();
        parmList[1] = new ProgramParameter(entry.getEntryID().toBytes());
        parmList[2] = new ProgramParameter(entry.getDataToEncrypt().toBytes());
        parmList[3] = new ProgramParameter(entry.getUnencryptedData().toBytes());
        parmList[4] = new ProgramParameter(entry.getAttributeInfo().toBytes());
        parmList[5] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(pgm);
    }

    private void closeList(byte[] handle) throws PersistenceException {
        ProgramCall pgm = new ProgramCall(this.getAS400());
        ProgramParameter[] parmList = new ProgramParameter[2];
        try {
            pgm.setProgram(QSYSObjectPathName.toPath("QGY", "QGYCLST", "PGM"), parmList);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        parmList[0] = new ProgramParameter(new AS400ByteArray(handle.length).toBytes(handle));
        parmList[1] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(pgm);
    }

    public void create() throws PersistenceException {
        String obj = this.getPath().getObjectName();
        String lib = this.getPath().getLibraryName();
        CommandCall cmd = new CommandCall(this.getAS400(), "CRTVLDL VLDL(" + lib + "/" + obj + ") TEXT('" + this.getDescription() + "')");
        this.runCommand(cmd);
    }

    public void delete() throws PersistenceException {
        String obj = this.getPath().getObjectName();
        String lib = this.getPath().getLibraryName();
        CommandCall cmd = new CommandCall(this.getAS400(), "DLTVLDL VLDL(" + lib + "/" + obj + ")");
        this.runCommand(cmd);
    }

    private void fillStringBuffer(StringBuffer buffer, int offset, String s) {
        for (int i = 0; i < s.length(); ++i) {
            buffer.setCharAt(i + offset, s.charAt(i));
        }
    }

    public ValidationListEntry findEntry(String identifier, int ccsid) throws PersistenceException {
        return this.findEntry(identifier, ccsid, new ValidationListAttribute[0]);
    }

    public ValidationListEntry findEntry(String identifier, int ccsid, ValidationListAttribute[] attributes) throws PersistenceException {
        ValidationListEntry entry = new ValidationListEntry();
        ProgramCall pgm = new ProgramCall(this.getAS400());
        ProgramParameter[] parmList = new ProgramParameter[6];
        try {
            pgm.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYFDVLE", "PGM"), parmList);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        ValidationListTranslatedData entryID = new ValidationListTranslatedData(identifier, ccsid, this.getAS400());
        ValidationListAttributeInfo attrInfo = new ValidationListAttributeInfo(attributes);
        parmList[0] = this.getQualifiedNameParm();
        parmList[1] = new ProgramParameter(entryID.toBytes());
        parmList[2] = new ProgramParameter(attrInfo.toBytes());
        parmList[3] = new ProgramParameter(entry.getByteLength());
        parmList[4] = new ProgramParameter(attrInfo.getByteLength());
        parmList[5] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(pgm);
        entry.init(parmList[3].getOutputData(), 0);
        attrInfo.setAttributesData(parmList[4].getOutputData(), 0);
        entry.setAttributeInfo(attrInfo);
        return entry;
    }

    public AS400 getAS400() {
        return this.as400_;
    }

    public String getDescription() {
        if (this.description_ != null) {
            return this.description_;
        }
        return "";
    }

    public ValidationListEntry[] getEntries() throws PersistenceException {
        int listPosition;
        ProgramCall pgm = new ProgramCall(this.getAS400());
        ProgramParameter[] parmList = new ProgramParameter[7];
        int bufferLength = LISTBUFFER_LENGTH_INITIAL;
        try {
            pgm.setProgram(QSYSObjectPathName.toPath("QGY", "QSYOLVLE", "PGM"), parmList);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        parmList[0] = new ProgramParameter(bufferLength);
        parmList[1] = new ProgramParameter(new AS400Bin4().toBytes(bufferLength));
        parmList[2] = new ProgramParameter(this.getListInfoStruct().getByteLength());
        parmList[3] = new ProgramParameter(new AS400Bin4().toBytes(-1));
        parmList[4] = new ProgramParameter(new AS400Text(8, this.getAS400()).toBytes("VLDE0100"));
        parmList[5] = this.getQualifiedNameParm();
        parmList[6] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(pgm);
        Object[] listInfo = (Object[])this.getListInfoStruct().toObject(parmList[2].getOutputData());
        ValidationListEntry[] list = new ValidationListEntry[((Integer)listInfo[0]).intValue()];
        byte[] listHandle = (byte[])listInfo[2];
        this.parseEntries(list, 0, parmList[0].getOutputData(), listPosition);
        for (listPosition = ((Integer)listInfo[1]).intValue(); listPosition < list.length; listPosition += this.getNextEntries(listHandle, listPosition, list)) {
        }
        this.closeList(listHandle);
        return list;
    }

    private AS400Structure getListInfoStruct() {
        if (this.listInfo_ == null) {
            this.listInfo_ = new AS400Structure(new AS400DataType[]{new AS400Bin4(), new AS400Bin4(), new AS400ByteArray(4), new AS400Bin4(), new AS400Text(1, this.as400_), new AS400ByteArray(13), new AS400Text(1, this.as400_), new AS400ByteArray(1), new AS400Bin4(), new AS400Bin4()});
        }
        return this.listInfo_;
    }

    private int getNextEntries(byte[] listHandle, int listPosition, ValidationListEntry[] list) throws PersistenceException {
        int recordsToReturn = list.length - listPosition;
        int recordsReturned = 0;
        if (recordsToReturn > 0) {
            ProgramCall pgm = new ProgramCall(this.getAS400());
            ProgramParameter[] parmList = new ProgramParameter[7];
            int bufferLength = LISTBUFFER_LENGTH_NEXT;
            try {
                pgm.setProgram(QSYSObjectPathName.toPath("QGY", "QGYGTLE", "PGM"), parmList);
            }
            catch (PropertyVetoException pve) {
                Trace.log(2, pve);
            }
            parmList[0] = new ProgramParameter(bufferLength);
            parmList[1] = new ProgramParameter(new AS400Bin4().toBytes(bufferLength));
            parmList[2] = new ProgramParameter(listHandle);
            parmList[3] = new ProgramParameter(this.getListInfoStruct().getByteLength());
            parmList[4] = new ProgramParameter(new AS400Bin4().toBytes(recordsToReturn));
            parmList[5] = new ProgramParameter(new AS400Bin4().toBytes(listPosition + 1));
            parmList[6] = new ProgramParameter(new AS400Bin4().toBytes(0));
            this.runProgram(pgm);
            Object[] listInfo = (Object[])this.getListInfoStruct().toObject(parmList[3].getOutputData());
            recordsReturned = (Integer)listInfo[1];
            this.parseEntries(list, listPosition, parmList[0].getOutputData(), recordsReturned);
        }
        return recordsReturned;
    }

    public int getNumberOfEntries() throws PersistenceException {
        ProgramCall pgm = new ProgramCall(this.getAS400());
        ProgramParameter[] parmList = new ProgramParameter[7];
        int bufferLength = 512;
        try {
            pgm.setProgram(QSYSObjectPathName.toPath("QGY", "QSYOLVLE", "PGM"), parmList);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        parmList[0] = new ProgramParameter(bufferLength);
        parmList[1] = new ProgramParameter(new AS400Bin4().toBytes(bufferLength));
        parmList[2] = new ProgramParameter(this.getListInfoStruct().getByteLength());
        parmList[3] = new ProgramParameter(new AS400Bin4().toBytes(-1));
        parmList[4] = new ProgramParameter(new AS400Text(8, this.getAS400()).toBytes("VLDE0100"));
        parmList[5] = this.getQualifiedNameParm();
        parmList[6] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(pgm);
        Object[] listInfo = (Object[])this.getListInfoStruct().toObject(parmList[2].getOutputData());
        this.closeList((byte[])listInfo[2]);
        return (Integer)listInfo[0];
    }

    public QSYSObjectPathName getPath() {
        return this.path_;
    }

    protected ProgramParameter getQualifiedNameParm() {
        StringBuffer buffer = new StringBuffer("                    ");
        this.fillStringBuffer(buffer, 0, this.getPath().getObjectName());
        this.fillStringBuffer(buffer, 10, this.getPath().getLibraryName());
        return new ProgramParameter(2, new AS400Text(20, this.getAS400()).toBytes(buffer.toString()));
    }

    private AS400Structure getVlde0100Struct() {
        if (this.vlde0100_ == null) {
            this.vlde0100_ = new AS400Structure(new AS400DataType[]{new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4()});
        }
        return this.vlde0100_;
    }

    private void handleUnexpectedAS400Exception(Throwable e) throws PersistenceException {
        throw new PersistenceException(e);
    }

    private void handleUnexpectedAS400Messages(AS400Message[] messages) throws PersistenceException {
        throw new PersistenceException(messages);
    }

    private void parseEntries(ValidationListEntry[] list, int start, byte[] buffer, int numberInBuffer) {
        int position = 0;
        for (int i = 0; i < numberInBuffer; ++i) {
            ValidationListEntry entry;
            list[start + i] = entry = new ValidationListEntry();
            Object[] vlde0100 = (Object[])this.getVlde0100Struct().toObject(buffer, position);
            int entryLength = (Integer)vlde0100[0];
            entry.setEntryID(new ValidationListTranslatedData((Integer)vlde0100[3], this.parseEntryData(buffer, position + (Integer)vlde0100[1], (Integer)vlde0100[2])));
            entry.setEncryptedData(new ValidationListTranslatedData((Integer)vlde0100[6], this.parseEntryData(buffer, position + (Integer)vlde0100[4], (Integer)vlde0100[5])));
            entry.setUnencryptedData(new ValidationListTranslatedData((Integer)vlde0100[9], this.parseEntryData(buffer, position + (Integer)vlde0100[7], (Integer)vlde0100[8])));
            position += entryLength;
        }
    }

    private byte[] parseEntryData(byte[] buffer, int start, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(buffer, start, bytes, 0, length);
        return bytes;
    }

    public void removeEntry(ValidationListEntry entry) throws PersistenceException {
        ProgramCall pgm = new ProgramCall(this.getAS400());
        ProgramParameter[] parmList = new ProgramParameter[3];
        try {
            pgm.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYRMVLE", "PGM"), parmList);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        parmList[0] = this.getQualifiedNameParm();
        parmList[1] = new ProgramParameter(entry.getEntryID().toBytes());
        parmList[2] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(pgm);
    }

    private void runCommand(CommandCall c) throws PersistenceException {
        boolean success = false;
        try {
            success = c.run();
        }
        catch (Exception e) {
            this.handleUnexpectedAS400Exception(e);
        }
        if (!success) {
            this.handleUnexpectedAS400Messages(c.getMessageList());
        }
    }

    private void runProgram(ProgramCall p) throws PersistenceException {
        PersistenceException err;
        int i = 0;
        boolean success = false;
        boolean lockedObj = false;
        do {
            try {
                success = false;
                lockedObj = false;
                err = null;
                try {
                    if (i > 0) {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    success = p.run();
                }
                catch (Exception e) {
                    this.handleUnexpectedAS400Exception(e);
                }
                if (success) continue;
                AS400Message[] msgs = p.getMessageList();
                if (msgs != null) {
                    for (int j = 0; !lockedObj && j < msgs.length; ++j) {
                        lockedObj = "CPF9803".equals(msgs[j].getID());
                    }
                }
                this.handleUnexpectedAS400Messages(msgs);
            }
            catch (PersistenceException pe) {
                err = pe;
            }
        } while (++i < 5 && lockedObj);
        if (err != null) {
            throw err;
        }
    }

    private void runServiceProgram(ServiceProgramCall spc) throws PersistenceException {
        int i = 0;
        int errno = 0;
        do {
            try {
                if (i > 0) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.runProgram(spc);
            int n = errno = spc.getReturnValueFormat() == 1 && spc.getIntegerReturnValue() == 0 ? 0 : spc.getErrno();
        } while (++i < 5 && errno == 3406);
        if (errno == 0) {
            return;
        }
        PersistenceException pe = new PersistenceException(new StringBuffer("Procedure named ").append(spc.getProcedureName()).append(" failed with errorno ").append(errno).toString());
        throw pe;
    }

    public void setAS400(AS400 as400) {
        this.as400_ = as400;
    }

    public void setDescription(String s) {
        this.description_ = s;
    }

    public void setPath(QSYSObjectPathName path) {
        this.path_ = path;
    }

    public boolean verifyEntry(ValidationListEntry entry) throws PersistenceException {
        int len = entry.getDataToEncrypt().getBytes().length;
        if (len < 1 || len > 600) {
            return false;
        }
        len = entry.getEntryID().getBytes().length;
        if (len < 1 || len > 100) {
            return false;
        }
        ProgramParameter[] parmList = new ProgramParameter[]{this.getQualifiedNameParm(), new ProgramParameter(2, entry.getEntryID().toBytes()), new ProgramParameter(2, entry.getDataToEncrypt().toBytes())};
        ServiceProgramCall sPGMCall = new ServiceProgramCall(this.getAS400());
        try {
            sPGMCall.setProgram("/QSYS.LIB/QSYVLDL.SRVPGM", parmList);
            sPGMCall.setProcedureName("QsyVerifyValidationLstEntry");
            sPGMCall.setReturnValueFormat(1);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        this.runServiceProgram(sPGMCall);
        return sPGMCall.getIntegerReturnValue() == 0;
    }
}

