/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBColumnDescriptorsDataFormat;
import com.ibm.as400.access.SQLConversionSettings;
import java.sql.SQLException;

class DBExtendedColumnDescriptors {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] data_;
    private int offset_;

    public DBExtendedColumnDescriptors(byte[] data, int offset) {
        this.data_ = data;
        this.offset_ = offset;
    }

    public int getAttributeBitmap(int columnIndex) {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + this.getExtendedColumnDescriptorOffset(columnIndex));
    }

    public DBColumnDescriptorsDataFormat getColumnDescriptors(int columnIndex, SQLConversionSettings settings) throws SQLException {
        int variableColumnInfoLength = this.getVariableColumnInfoLength(columnIndex);
        if (variableColumnInfoLength > 0) {
            int offsetToDescriptor = this.getVariableColumnInfoOffset(columnIndex);
            DBColumnDescriptorsDataFormat columnDescriptorsDataFormat = new DBColumnDescriptorsDataFormat(settings);
            columnDescriptorsDataFormat.overlay(this.data_, this.offset_ - 6 + offsetToDescriptor, variableColumnInfoLength);
            return columnDescriptorsDataFormat;
        }
        return null;
    }

    public DBColumnDescriptorsDataFormat getColumnDescriptors(int columnIndex, ConvTable convTable, SQLConversionSettings settings) throws SQLException {
        if (columnIndex <= this.getNumberOfColumns()) {
            int variableColumnInfoLength = this.getVariableColumnInfoLength(columnIndex);
            if (variableColumnInfoLength > 0) {
                int offsetToDescriptor = this.getVariableColumnInfoOffset(columnIndex);
                DBColumnDescriptorsDataFormat columnDescriptorsDataFormat = new DBColumnDescriptorsDataFormat(convTable.getCcsid(), settings);
                columnDescriptorsDataFormat.overlay(this.data_, this.offset_ - 6 + offsetToDescriptor, variableColumnInfoLength);
                return columnDescriptorsDataFormat;
            }
            return null;
        }
        return null;
    }

    private int getExtendedColumnDescriptorOffset(int columnIndex) {
        return (columnIndex - 1) * 16 + 10;
    }

    private int getVariableColumnInfoLength(int columnIndex) {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getExtendedColumnDescriptorOffset(columnIndex) + 8);
    }

    private int getVariableColumnInfoOffset(int columnIndex) {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getExtendedColumnDescriptorOffset(columnIndex) + 4);
    }

    int getNumberOfColumns() {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_);
    }

    byte getSearchable(int columnIndex) {
        return this.data_[this.offset_ + this.getExtendedColumnDescriptorOffset(columnIndex) + 1];
    }

    byte getUpdateable(int columnIndex) {
        return this.data_[this.offset_ + this.getExtendedColumnDescriptorOffset(columnIndex)];
    }
}

