/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableDoubleMap;
import com.ibm.as400.access.ConvTableSingleMap;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

public abstract class ConvTableMixedMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    public ConvTableSingleMap sbTable_ = null;
    public ConvTableDoubleMap dbTable_ = null;
    static final byte shiftOut_ = 14;
    static final byte shiftIn_ = 15;
    static final byte ebcdicSpace_ = 64;

    ConvTableMixedMap(int ccsid, int sbCcsid, int dbCcsid) throws UnsupportedEncodingException {
        super(ccsid);
        this.sbTable_ = (ConvTableSingleMap)ConvTable.getTable(sbCcsid, null);
        this.dbTable_ = (ConvTableDoubleMap)ConvTable.getTable(dbCcsid, null);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded mixed-byte map for ccsid: " + this.ccsid_);
        }
    }

    @Override
    final String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length];
        boolean inSBMode = true;
        int destPos = 0;
        for (int srcPos = offset; srcPos < offset + length; ++srcPos) {
            byte curByte = buf[srcPos];
            if (inSBMode) {
                if (curByte == 14) {
                    inSBMode = false;
                    continue;
                }
                dest[destPos++] = this.sbTable_.toUnicode_[0xFF & curByte];
                continue;
            }
            if (curByte == 15) {
                inSBMode = true;
                continue;
            }
            try {
                if (srcPos + 1 < offset + length) {
                    int unicodeLength = this.dbTable_.toUnicode(dest, destPos, ((0xFF & curByte) << 8) + (0xFF & buf[++srcPos]));
                    destPos += unicodeLength;
                    continue;
                }
                if (CharConverter.isFaultTolerantConversion()) continue;
                dest[destPos++] = 65533;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                if (CharConverter.isFaultTolerantConversion()) continue;
                throw aioobe;
            }
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_ + ": 0," + destPos, ConvTable.dumpCharArray(dest));
        }
        return String.copyValueOf(dest, 0, destPos);
    }

    @Override
    final byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        return this.charArrayToByteArray(source.toCharArray(), properties);
    }

    @Override
    final char[] byteArrayToCharArray(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length];
        boolean inSBMode = true;
        int destPos = 0;
        for (int srcPos = offset; srcPos < offset + length; ++srcPos) {
            byte curByte = buf[srcPos];
            if (inSBMode) {
                if (curByte == 14) {
                    inSBMode = false;
                    continue;
                }
                dest[destPos++] = this.sbTable_.toUnicode_[0xFF & curByte];
                continue;
            }
            if (curByte == 15) {
                inSBMode = true;
                continue;
            }
            try {
                if (srcPos + 1 < offset + length) {
                    int unicodeLength = this.dbTable_.toUnicode(dest, destPos, ((0xFF & curByte) << 8) + (0xFF & buf[++srcPos]));
                    destPos += unicodeLength;
                    continue;
                }
                if (CharConverter.isFaultTolerantConversion()) continue;
                dest[destPos++] = 65533;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                if (CharConverter.isFaultTolerantConversion()) continue;
                throw aioobe;
            }
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_ + ": 0," + destPos, ConvTable.dumpCharArray(dest));
        }
        char[] destChar = new char[destPos];
        System.arraycopy(dest, 0, destChar, 0, destPos);
        return destChar;
    }

    @Override
    final byte[] charArrayToByteArray(char[] src, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src));
        }
        byte[] dest = new byte[(src.length * 5 + 3) / 2];
        boolean inSBMode = true;
        byte sbLookup = 0;
        char dbLookup = '\u0000';
        int[] increment = new int[1];
        int destPos = 0;
        for (int srcPos = 0; srcPos < src.length; ++srcPos) {
            char curChar = src[srcPos];
            if ((curChar & 0xFF00) == 0 || curChar == '\u20ac' || curChar == '\u203e' && (this.ccsid_ == 935 || this.ccsid_ == 1388)) {
                sbLookup = this.sbTable_.fromUnicode_[curChar];
                if (sbLookup == 63 && curChar != '\u001a') {
                    dbLookup = this.dbTable_.fromUnicode(src, srcPos, increment);
                    if (increment[0] == 2) {
                        ++srcPos;
                    }
                    if (dbLookup == '\ufefe') {
                        if (!inSBMode) {
                            inSBMode = true;
                            dest[destPos++] = 15;
                        }
                        dest[destPos++] = 63;
                        continue;
                    }
                    if (inSBMode) {
                        inSBMode = false;
                        dest[destPos++] = 14;
                    }
                    dest[destPos++] = (byte)((0xFFFF & dbLookup) >>> 8);
                    dest[destPos++] = (byte)(0xFF & dbLookup);
                    continue;
                }
                if (!inSBMode) {
                    inSBMode = true;
                    dest[destPos++] = 15;
                }
                dest[destPos++] = sbLookup;
                continue;
            }
            dbLookup = this.dbTable_.fromUnicode(src, srcPos, increment);
            if (increment[0] >= 2) {
                srcPos = srcPos + increment[0] - 1;
            }
            if (dbLookup == '\ufefe' && curChar != '\ufffd') {
                sbLookup = this.sbTable_.fromUnicode_[curChar];
                if (sbLookup == 63) {
                    if (inSBMode) {
                        dest[destPos++] = 63;
                        continue;
                    }
                    dest[destPos++] = -2;
                    dest[destPos++] = -2;
                    continue;
                }
                if (!inSBMode) {
                    inSBMode = true;
                    dest[destPos++] = 15;
                }
                dest[destPos++] = sbLookup;
                continue;
            }
            if (inSBMode) {
                inSBMode = false;
                dest[destPos++] = 14;
            }
            dest[destPos++] = (byte)((0xFFFF & dbLookup) >>> 8);
            dest[destPos++] = (byte)(0xFF & dbLookup);
        }
        if (!inSBMode) {
            dest[destPos++] = 15;
        }
        byte[] ret = new byte[destPos];
        System.arraycopy(dest, 0, ret, 0, destPos);
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, ret);
        }
        return ret;
    }

    @Override
    public int validateData(byte[] buf, int offset, int length) {
        int endOffset = offset + length;
        int doubleByteStart = -1;
        boolean doubleByte = false;
        for (int i = offset; i < endOffset; ++i) {
            if (doubleByteStart == -1) {
                if (buf[i] != 14) continue;
                doubleByteStart = i + 1;
                continue;
            }
            if (buf[i] == 15) {
                doubleByteStart = -1;
                continue;
            }
            ++i;
        }
        if (doubleByteStart >= 0) {
            if ((0xFFFFFFFFL & (long)(endOffset - doubleByteStart)) % 2L == 1L) {
                if (buf[endOffset - 2] == 14) {
                    length -= 2;
                    buf[endOffset - 2] = 64;
                    buf[endOffset - 1] = 64;
                } else {
                    buf[endOffset - 1] = 15;
                }
            } else if (doubleByteStart == endOffset) {
                buf[endOffset - 1] = 64;
                --length;
            } else if (buf[endOffset - 3] == 14) {
                length -= 3;
                buf[endOffset - 3] = 64;
                buf[endOffset - 2] = 64;
                buf[endOffset - 1] = 64;
            } else {
                buf[endOffset - 2] = 15;
                buf[endOffset - 1] = 64;
                --length;
            }
        }
        return length;
    }
}

