/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.file;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.HopFileTypePlugin;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;

@HopFileTypePlugin(id="ExcelFileType", name="Excel File Type", description="Excel file handling in the explorer perspective", image="excel.svg")
public class ExcelFileType
implements IHopFileType {
    private static final String[] EXTENSIONS = new String[]{"*.xls", "*.xlsx"};
    private static final String[] FILTER_EXTENSIONS = new String[]{"*.xls;*.xlsx"};
    private static final String[] FILTER_NAMES = new String[]{"Excel files"};

    public String getName() {
        return "Excel";
    }

    public String getDefaultFileExtension() {
        return "xlsx";
    }

    public String[] getFilterExtensions() {
        return FILTER_EXTENSIONS;
    }

    public String[] getFilterNames() {
        return FILTER_NAMES;
    }

    public Properties getCapabilities() {
        return new Properties();
    }

    public boolean hasCapability(String capability) {
        return false;
    }

    public IHopFileTypeHandler openFile(HopGui hopGui, String filename, IVariables variables) throws HopException {
        return new EmptyHopFileTypeHandler();
    }

    public IHopFileTypeHandler newFile(HopGui hopGui, IVariables variables) throws HopException {
        return new EmptyHopFileTypeHandler();
    }

    public boolean isHandledBy(String filename, boolean checkContent) throws HopException {
        try {
            FileObject fileObject = HopVfs.getFileObject((String)filename);
            FileName fileName = fileObject.getName();
            String fileExtension = fileName.getExtension().toLowerCase();
            if (Utils.isEmpty((CharSequence)fileExtension)) {
                return false;
            }
            for (String typeExtension : EXTENSIONS) {
                if (!typeExtension.toLowerCase().endsWith(fileExtension)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new HopException("Unable to verify file handling of file '" + filename + "' by extension", (Throwable)e);
        }
    }

    public boolean supportsFile(IHasFilename metaObject) {
        return false;
    }

    public List<IGuiContextHandler> getContextHandlers() {
        return Collections.emptyList();
    }

    public String getFileTypeImage() {
        return this.getClass().getAnnotation(HopFileTypePlugin.class).image();
    }
}

