/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.util.Objects;

public class JsonNode {
    private final String source;

    public JsonNode(String string) {
        this.source = string;
    }

    public boolean isArray() {
        return this.source.charAt(0) == '[';
    }

    public boolean isObject() {
        return this.source.charAt(0) == '{';
    }

    public boolean isBoolean() {
        return "true".equals(this.source) || "false".equals(this.source);
    }

    public boolean isNull() {
        return "null".equals(this.source);
    }

    public boolean isNumber() {
        return Character.isDigit(this.source.charAt(0));
    }

    public boolean isString() {
        return !this.isObject() && !this.isBoolean() && !this.isNull() && !this.isArray() && !this.isNumber();
    }

    public String toString() {
        return this.source;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JsonNode)) {
            return false;
        }
        JsonNode jsonNode = (JsonNode)object;
        return Objects.equals(this.source, jsonNode.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }
}

