/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import com.fasterxml.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;
import java.util.List;
import org.apache.avro.Schema;

public class ArrayVisitor
extends JsonArrayFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final VisitorFormatWrapperImpl _visitorWrapper;
    protected Schema _elementSchema;

    public ArrayVisitor(SerializerProvider p, JavaType type, VisitorFormatWrapperImpl visitorWrapper) {
        super(p);
        this._type = type;
        this._visitorWrapper = visitorWrapper;
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._elementSchema == null) {
            throw new IllegalStateException("No element schema created for: " + this._type);
        }
        Schema schema = Schema.createArray((Schema)this._elementSchema);
        if (!this._type.hasRawClass(List.class)) {
            schema.addProp("java-class", AvroSchemaHelper.getTypeId(this._type));
        }
        return schema;
    }

    public void itemsFormat(JsonFormatVisitable visitable, JavaType type) throws JsonMappingException {
        VisitorFormatWrapperImpl wrapper = this._visitorWrapper.createChildWrapper();
        visitable.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)wrapper, type);
        this._elementSchema = wrapper.getAvroSchema();
    }

    public void itemsFormat(JsonFormatTypes type) throws JsonMappingException {
        this._elementSchema = this._type.hasRawClass(char[].class) ? AvroSchemaHelper.typedSchema(Schema.Type.INT, this._type.getContentType()) : AvroSchemaHelper.simpleSchema(type, this._type.getContentType());
    }
}

