/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.script;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.hop.core.exception.HopException;

public class ScriptUtils {
    private static ScriptEngineManager scriptEngineManager;
    private static ScriptUtils instance;
    private static final Map<String, List<ScriptEngineFactory>> languageFactoryMap;
    private static List<ScriptEngineFactory> engineFactories;

    private ScriptUtils() {
        scriptEngineManager = ScriptUtils.getScriptEngineManager();
        List<String> scriptLanguageNames = ScriptUtils.getScriptLanguageNames();
        for (String scriptLanguageName : scriptLanguageNames) {
            ScriptUtils.createNewScriptEngine(scriptLanguageName);
        }
        ScriptUtils.populateEngineFactoryMap();
    }

    public static ScriptUtils getInstance() {
        if (instance == null) {
            instance = new ScriptUtils();
        }
        return instance;
    }

    private static ScriptEngine createNewScriptEngine(String engineName) {
        ScriptEngine scriptEngine = ScriptUtils.getScriptEngineManager().getEngineByName(engineName);
        if (scriptEngine == null) {
            scriptEngine = scriptEngineManager.getEngineByName("groovy");
        }
        return scriptEngine;
    }

    private static ScriptEngine createNewScriptEngineByLanguage(String languageName) throws HopException {
        ScriptEngine scriptEngine = null;
        List<ScriptEngineFactory> factories = languageFactoryMap.get(languageName);
        if (factories != null) {
            for (ScriptEngineFactory factory : factories) {
                try {
                    scriptEngine = factory.getScriptEngine();
                    if (scriptEngine == null) continue;
                    break;
                }
                catch (Exception e) {
                    throw new HopException("Error getting scripting engine '" + factory.getEngineName() + "' for language '" + languageName + "'", (Throwable)e);
                }
            }
        }
        if (scriptEngine == null) {
            throw new HopException("Unable to find script engine for language '" + languageName + "'");
        }
        return scriptEngine;
    }

    private static ScriptEngineManager getScriptEngineManager() {
        if (scriptEngineManager == null) {
            System.setProperty("org.jruby.embed.localvariable.behavior", "persistent");
            System.setProperty("nashorn.args", "--language=es6");
            scriptEngineManager = new ScriptEngineManager(ScriptUtils.class.getClassLoader());
        }
        return scriptEngineManager;
    }

    public static List<String> getScriptLanguageNames() {
        ArrayList<String> scriptEngineNames = new ArrayList<String>();
        engineFactories = ScriptUtils.getScriptEngineManager().getEngineFactories();
        if (engineFactories != null) {
            for (ScriptEngineFactory factory : engineFactories) {
                String engineName = factory.getLanguageName();
                scriptEngineNames.add(engineName);
            }
        }
        return scriptEngineNames;
    }

    private static void populateEngineFactoryMap() {
        engineFactories = ScriptUtils.getScriptEngineManager().getEngineFactories();
        if (engineFactories != null) {
            for (ScriptEngineFactory factory : engineFactories) {
                String languageName = factory.getLanguageName();
                List languageFactories = languageFactoryMap.computeIfAbsent(languageName, k -> new ArrayList());
                languageFactories.add(factory);
            }
        }
    }

    public ScriptEngine getScriptEngineByName(String scriptLanguegeName) {
        return scriptEngineManager.getEngineByName(scriptLanguegeName);
    }

    static {
        languageFactoryMap = new ConcurrentSkipListMap<String, List<ScriptEngineFactory>>();
        engineFactories = null;
    }
}

